/*
 * Decompiled with CFR 0.152.
 */
package com.github.trang.druid.autoconfigure.datasource.init;

import com.alibaba.druid.pool.DruidDataSource;
import com.github.trang.druid.autoconfigure.datasource.init.DataSourceInitializer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.jdbc.DataSourceSchemaCreatedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.core.io.ResourceLoader;

public class DataSourceInitializerInvoker
implements ApplicationListener<DataSourceSchemaCreatedEvent>,
InitializingBean {
    private static final Log logger = LogFactory.getLog(DataSourceInitializerInvoker.class);
    private final List<DruidDataSource> dataSources;
    private final DataSourceProperties properties;
    private final ApplicationContext applicationContext;
    private DataSourceInitializer dataSourceInitializer;
    private boolean initialized;

    public DataSourceInitializerInvoker(ObjectProvider<List<DruidDataSource>> dataSourcesProvider, DataSourceProperties properties, ApplicationContext applicationContext) {
        this.dataSources = (List)dataSourcesProvider.getIfAvailable(ArrayList::new);
        this.properties = properties;
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() {
        boolean schemaCreated;
        DataSourceInitializer initializer = this.getDataSourceInitializer();
        if (initializer != null && (schemaCreated = this.dataSourceInitializer.createSchema())) {
            this.initialize(initializer);
        }
    }

    private void initialize(DataSourceInitializer initializer) {
        try {
            initializer.getDataSources().stream().map(DataSourceSchemaCreatedEvent::new).forEach(arg_0 -> ((ApplicationContext)this.applicationContext).publishEvent(arg_0));
            if (!this.initialized) {
                this.dataSourceInitializer.initSchema();
                this.initialized = true;
            }
        }
        catch (IllegalStateException ex) {
            logger.warn((Object)("Could not send event to complete DataSource initialization (" + ex.getMessage() + ")"));
        }
    }

    public void onApplicationEvent(DataSourceSchemaCreatedEvent event) {
        DataSourceInitializer initializer = this.getDataSourceInitializer();
        if (!this.initialized && initializer != null) {
            initializer.initSchema();
            this.initialized = true;
        }
    }

    private DataSourceInitializer getDataSourceInitializer() {
        List<DruidDataSource> dataSources;
        if (this.dataSourceInitializer == null && !(dataSources = this.dataSources).isEmpty()) {
            this.dataSourceInitializer = new DataSourceInitializer(dataSources, this.properties, (ResourceLoader)this.applicationContext);
        }
        return this.dataSourceInitializer;
    }
}

