/*
 * Decompiled with CFR 0.152.
 */
package com.github.trang.mybatis.generator.plugins;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.internal.util.StringUtility;

public class GuavaToStringPlugin
extends PluginAdapter {
    private static final List<String> NON_TO_STRING_FIELDS = Collections.singletonList("serialVersionUID");
    private boolean useToStringFromRoot;

    public void setProperties(Properties properties) {
        super.setProperties(properties);
        this.useToStringFromRoot = StringUtility.isTrue((String)properties.getProperty("useToStringFromRoot"));
    }

    public boolean validate(List<String> warnings) {
        return true;
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.generateToString(introspectedTable, topLevelClass);
        return true;
    }

    public boolean modelRecordWithBLOBsClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.generateToString(introspectedTable, topLevelClass);
        return true;
    }

    public boolean modelPrimaryKeyClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.generateToString(introspectedTable, topLevelClass);
        return true;
    }

    private void generateToString(IntrospectedTable introspectedTable, TopLevelClass topLevelClass) {
        topLevelClass.addImportedType("com.google.common.base.MoreObjects");
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(FullyQualifiedJavaType.getStringInstance());
        method.setName("toString");
        if (introspectedTable.isJava5Targeted()) {
            method.addAnnotation("@Override");
        }
        this.context.getCommentGenerator().addGeneralMethodComment(method, introspectedTable);
        method.addBodyLine("return MoreObjects.toStringHelper(this).omitNullValues()");
        StringBuilder builder = new StringBuilder();
        for (Field field : topLevelClass.getFields()) {
            builder.setLength(0);
            String fieldName = field.getName();
            if (NON_TO_STRING_FIELDS.contains(fieldName)) continue;
            builder.append("        .add(\"").append(fieldName).append("\", ").append(fieldName).append(")");
            method.addBodyLine(builder.toString());
        }
        if (this.useToStringFromRoot && topLevelClass.getSuperClass() != null) {
            method.addBodyLine("        .add(\"super class\", super.toString())");
        }
        method.addBodyLine("        .toString();");
        topLevelClass.addMethod(method);
    }
}

