/*
 * Decompiled with CFR 0.152.
 */
package com.github.trang.mybatis.generator.plugins;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.JavaFormatter;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.DefaultJavaFormatter;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.internal.util.StringUtility;

public class ServicePlugin
extends PluginAdapter {
    private String baseService;
    private String baseServiceImpl;
    private String targetProject;
    private String targetPackage;

    public void setProperties(Properties properties) {
        super.setProperties(properties);
        String baseService = this.properties.getProperty("baseService");
        if (!StringUtility.stringHasValue((String)baseService)) {
            throw new RuntimeException("baseService \u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.baseService = baseService;
        String baseServiceImpl = this.properties.getProperty("baseServiceImpl");
        if (!StringUtility.stringHasValue((String)baseServiceImpl)) {
            throw new RuntimeException("baseServiceImpl \u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.baseServiceImpl = baseServiceImpl;
        String targetProject = this.properties.getProperty("targetProject");
        if (!StringUtility.stringHasValue((String)targetProject)) {
            throw new RuntimeException("targetProject \u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.targetProject = targetProject;
        String targetPackage = this.properties.getProperty("targetPackage");
        if (!StringUtility.stringHasValue((String)targetPackage)) {
            throw new RuntimeException("targetPackage \u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.targetPackage = targetPackage;
    }

    public boolean validate(List<String> warnings) {
        return true;
    }

    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles(IntrospectedTable table) {
        return Arrays.asList(this.generateService(table), this.generateServiceImpl(table));
    }

    private GeneratedJavaFile generateService(IntrospectedTable table) {
        FullyQualifiedJavaType entityType = new FullyQualifiedJavaType(table.getBaseRecordType());
        FullyQualifiedJavaType primaryType = ((IntrospectedColumn)table.getPrimaryKeyColumns().get(0)).getFullyQualifiedJavaType();
        String service = this.targetPackage + "." + table.getFullyQualifiedTable().getDomainObjectName() + "Service";
        Interface interfaze = new Interface(new FullyQualifiedJavaType(service));
        interfaze.setVisibility(JavaVisibility.PUBLIC);
        interfaze.addImportedType(entityType);
        interfaze.addSuperInterface(new FullyQualifiedJavaType(this.baseService + "<" + entityType.getShortName() + "," + primaryType.getShortName() + ">"));
        return new GeneratedJavaFile((CompilationUnit)interfaze, this.targetProject, (JavaFormatter)new DefaultJavaFormatter());
    }

    private GeneratedJavaFile generateServiceImpl(IntrospectedTable table) {
        FullyQualifiedJavaType entityType = new FullyQualifiedJavaType(table.getBaseRecordType());
        FullyQualifiedJavaType primaryType = ((IntrospectedColumn)table.getPrimaryKeyColumns().get(0)).getFullyQualifiedJavaType();
        String domainObjectName = table.getFullyQualifiedTable().getDomainObjectName();
        String service = this.targetPackage + "." + domainObjectName + "Service";
        String serviceImpl = this.targetPackage + ".impl." + domainObjectName + "ServiceImpl";
        TopLevelClass clazz = new TopLevelClass(new FullyQualifiedJavaType(serviceImpl));
        clazz.addImportedType(entityType);
        clazz.addImportedType(new FullyQualifiedJavaType(service));
        clazz.addImportedType(new FullyQualifiedJavaType("org.springframework.stereotype.Service"));
        clazz.addAnnotation("@Service(\"" + this.firstLetterLowerCase(domainObjectName + "Service") + "\")");
        clazz.setVisibility(JavaVisibility.PUBLIC);
        clazz.setSuperClass(new FullyQualifiedJavaType(this.baseServiceImpl + "<" + entityType.getShortName() + "," + primaryType.getShortName() + ">"));
        clazz.addSuperInterface(new FullyQualifiedJavaType(service));
        return new GeneratedJavaFile((CompilationUnit)clazz, this.targetProject, (JavaFormatter)new DefaultJavaFormatter());
    }

    private String firstLetterLowerCase(String name) {
        char c = name.charAt(0);
        if (c >= 'A' && c <= 'Z') {
            String temp = String.valueOf(c);
            return name.replaceFirst(temp, temp.toLowerCase());
        }
        return name;
    }
}

