/*
 * Decompiled with CFR 0.152.
 */
package com.github.trang.autoconfigure.condition;

import com.github.trang.autoconfigure.condition.BeanTypeRegistry;
import com.github.trang.autoconfigure.condition.ConditionalOnBeans;
import com.github.trang.autoconfigure.condition.ConditionalOnMissingBeans;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

@Order
class OnBeansCondition
extends SpringBootCondition
implements ConfigurationCondition {
    public static final String FACTORY_BEAN_OBJECT_TYPE = "factoryBeanObjectType";

    OnBeansCondition() {
    }

    public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
        return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        boolean matching;
        BeanSearchSpec spec;
        ConditionMessage matchMessage = ConditionMessage.empty();
        if (metadata.isAnnotated(ConditionalOnBeans.class.getName())) {
            spec = new BeanSearchSpec(context, metadata, ConditionalOnBeans.class);
            matching = this.isMatchingBeans(context, spec);
            if (!matching) {
                return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnBeans.class, (Object[])new Object[]{spec}).didNotFind("all beans").atAll());
            }
            matchMessage = matchMessage.andCondition(ConditionalOnBeans.class, new Object[]{spec}).found("all beans").atAll();
        }
        if (metadata.isAnnotated(ConditionalOnMissingBeans.class.getName())) {
            spec = new BeanSearchSpec(context, metadata, ConditionalOnMissingBeans.class);
            matching = this.isNonMatchingBeans(context, spec);
            if (!matching) {
                return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnMissingBeans.class, (Object[])new Object[]{spec}).found("beans").atAll());
            }
            matchMessage = matchMessage.andCondition(ConditionalOnMissingBeans.class, new Object[]{spec}).didNotFind("any beans").atAll();
        }
        return ConditionOutcome.match((ConditionMessage)matchMessage);
    }

    private boolean isMatchingBeans(ConditionContext context, BeanSearchSpec beans) {
        Collection<String> beanNames;
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        if (beans.getStrategy() == SearchStrategy.PARENTS || beans.getStrategy() == SearchStrategy.ANCESTORS) {
            BeanFactory parent = beanFactory.getParentBeanFactory();
            Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)parent, (String)"Unable to use SearchStrategy.PARENTS");
            beanFactory = (ConfigurableListableBeanFactory)parent;
        }
        if (beanFactory == null) {
            return false;
        }
        boolean considerHierarchy = beans.getStrategy() != SearchStrategy.CURRENT;
        for (String type : beans.getTypes()) {
            beanNames = this.getBeanNamesForType((ListableBeanFactory)beanFactory, type, context.getClassLoader(), considerHierarchy);
            if (!beanNames.isEmpty()) continue;
            return false;
        }
        for (String annotation : beans.getAnnotations()) {
            beanNames = this.getBeanNamesForAnnotation(beanFactory, annotation, context.getClassLoader(), considerHierarchy);
            if (!beanNames.isEmpty()) continue;
            return false;
        }
        for (String beanName : beans.getNames()) {
            if (this.containsBean(beanFactory, beanName, considerHierarchy)) continue;
            return false;
        }
        return true;
    }

    private boolean isNonMatchingBeans(ConditionContext context, BeanSearchSpec beans) {
        Collection<String> beanNames;
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        if (beans.getStrategy() == SearchStrategy.PARENTS || beans.getStrategy() == SearchStrategy.ANCESTORS) {
            BeanFactory parent = beanFactory.getParentBeanFactory();
            Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)parent, (String)"Unable to use SearchStrategy.PARENTS");
            beanFactory = (ConfigurableListableBeanFactory)parent;
        }
        if (beanFactory == null) {
            return false;
        }
        boolean considerHierarchy = beans.getStrategy() != SearchStrategy.CURRENT;
        for (String type : beans.getTypes()) {
            beanNames = this.getBeanNamesForType((ListableBeanFactory)beanFactory, type, context.getClassLoader(), considerHierarchy);
            if (beanNames.isEmpty()) continue;
            return false;
        }
        for (String annotation : beans.getAnnotations()) {
            beanNames = this.getBeanNamesForAnnotation(beanFactory, annotation, context.getClassLoader(), considerHierarchy);
            if (beanNames.isEmpty()) continue;
            return false;
        }
        for (String beanName : beans.getNames()) {
            if (!this.containsBean(beanFactory, beanName, considerHierarchy)) continue;
            return false;
        }
        return true;
    }

    private boolean containsBean(ConfigurableListableBeanFactory beanFactory, String beanName, boolean considerHierarchy) {
        if (considerHierarchy) {
            return beanFactory.containsBean(beanName);
        }
        return beanFactory.containsLocalBean(beanName);
    }

    private Collection<String> getBeanNamesForType(ListableBeanFactory beanFactory, String type, ClassLoader classLoader, boolean considerHierarchy) throws LinkageError {
        try {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            this.collectBeanNamesForType(result, beanFactory, ClassUtils.forName((String)type, (ClassLoader)classLoader), considerHierarchy);
            return result;
        }
        catch (ClassNotFoundException | NoClassDefFoundError ex) {
            return Collections.emptySet();
        }
    }

    private void collectBeanNamesForType(Set<String> result, ListableBeanFactory beanFactory, Class<?> type, boolean considerHierarchy) {
        BeanFactory parent;
        result.addAll(BeanTypeRegistry.get(beanFactory).getNamesForType(type));
        if (considerHierarchy && beanFactory instanceof HierarchicalBeanFactory && (parent = ((HierarchicalBeanFactory)beanFactory).getParentBeanFactory()) instanceof ListableBeanFactory) {
            this.collectBeanNamesForType(result, (ListableBeanFactory)parent, type, considerHierarchy);
        }
    }

    private Collection<String> getBeanNamesForAnnotation(ConfigurableListableBeanFactory beanFactory, String type, ClassLoader classLoader, boolean considerHierarchy) throws LinkageError {
        HashSet<String> names = new HashSet<String>();
        try {
            Class annotationType = ClassUtils.forName((String)type, (ClassLoader)classLoader);
            this.collectBeanNamesForAnnotation(names, (ListableBeanFactory)beanFactory, annotationType, considerHierarchy);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return names;
    }

    private void collectBeanNamesForAnnotation(Set<String> names, ListableBeanFactory beanFactory, Class<? extends Annotation> annotationType, boolean considerHierarchy) {
        BeanFactory parent;
        names.addAll(BeanTypeRegistry.get(beanFactory).getNamesForAnnotation(annotationType));
        if (considerHierarchy && (parent = ((HierarchicalBeanFactory)beanFactory).getParentBeanFactory()) instanceof ListableBeanFactory) {
            this.collectBeanNamesForAnnotation(names, (ListableBeanFactory)parent, annotationType, considerHierarchy);
        }
    }

    private boolean hasSingleAutowireCandidate(ConfigurableListableBeanFactory beanFactory, List<String> beanNames, boolean considerHierarchy) {
        return beanNames.size() == 1 || this.getPrimaryBeans(beanFactory, beanNames, considerHierarchy).size() == 1;
    }

    private List<String> getPrimaryBeans(ConfigurableListableBeanFactory beanFactory, List<String> beanNames, boolean considerHierarchy) {
        ArrayList<String> primaryBeans = new ArrayList<String>();
        for (String beanName : beanNames) {
            BeanDefinition beanDefinition = this.findBeanDefinition(beanFactory, beanName, considerHierarchy);
            if (beanDefinition == null || !beanDefinition.isPrimary()) continue;
            primaryBeans.add(beanName);
        }
        return primaryBeans;
    }

    private BeanDefinition findBeanDefinition(ConfigurableListableBeanFactory beanFactory, String beanName, boolean considerHierarchy) {
        if (beanFactory.containsBeanDefinition(beanName)) {
            return beanFactory.getBeanDefinition(beanName);
        }
        if (considerHierarchy && beanFactory.getParentBeanFactory() instanceof ConfigurableListableBeanFactory) {
            return this.findBeanDefinition((ConfigurableListableBeanFactory)beanFactory.getParentBeanFactory(), beanName, considerHierarchy);
        }
        return null;
    }

    static final class BeanTypeDeductionException
    extends RuntimeException {
        private BeanTypeDeductionException(String className, String beanMethodName, Throwable cause) {
            super("Failed to deduce bean type for " + className + "." + beanMethodName, cause);
        }
    }

    private static class BeanSearchSpec {
        private final Class<?> annotationType;
        private final List<String> names = new ArrayList<String>();
        private final List<String> types = new ArrayList<String>();
        private final List<String> annotations = new ArrayList<String>();
        private final List<String> ignoredTypes = new ArrayList<String>();
        private final SearchStrategy strategy;

        BeanSearchSpec(ConditionContext context, AnnotatedTypeMetadata metadata, Class<?> annotationType) {
            this.annotationType = annotationType;
            MultiValueMap attributes = metadata.getAllAnnotationAttributes(annotationType.getName(), true);
            this.collect((MultiValueMap<String, Object>)attributes, "name", this.names);
            this.collect((MultiValueMap<String, Object>)attributes, "value", this.types);
            this.collect((MultiValueMap<String, Object>)attributes, "type", this.types);
            this.collect((MultiValueMap<String, Object>)attributes, "annotation", this.annotations);
            this.collect((MultiValueMap<String, Object>)attributes, "ignored", this.ignoredTypes);
            this.collect((MultiValueMap<String, Object>)attributes, "ignoredType", this.ignoredTypes);
            this.strategy = (SearchStrategy)metadata.getAnnotationAttributes(annotationType.getName()).get("search");
            BeanTypeDeductionException deductionException = null;
            try {
                if (this.types.isEmpty() && this.names.isEmpty()) {
                    this.addDeducedBeanType(context, metadata, this.types);
                }
            }
            catch (BeanTypeDeductionException ex) {
                deductionException = ex;
            }
            this.validate(deductionException);
        }

        protected void validate(BeanTypeDeductionException ex) {
            if (!this.hasAtLeastOne(this.types, this.names, this.annotations)) {
                String message = this.annotationName() + " did not specify a bean using type, name or annotation";
                if (ex == null) {
                    throw new IllegalStateException(message);
                }
                throw new IllegalStateException(message + " and the attempt to deduce the bean's type failed", ex);
            }
        }

        private boolean hasAtLeastOne(List<?> ... lists) {
            for (List<?> list : lists) {
                if (list.isEmpty()) continue;
                return true;
            }
            return false;
        }

        protected String annotationName() {
            return "@" + ClassUtils.getShortName(this.annotationType);
        }

        protected void collect(MultiValueMap<String, Object> attributes, String key, List<String> destination) {
            List values = (List)attributes.get((Object)key);
            if (values != null) {
                for (Object value : values) {
                    if (value instanceof String[]) {
                        Collections.addAll(destination, (String[])value);
                        continue;
                    }
                    destination.add((String)value);
                }
            }
        }

        private void addDeducedBeanType(ConditionContext context, AnnotatedTypeMetadata metadata, List<String> beanTypes) {
            if (metadata instanceof MethodMetadata && metadata.isAnnotated(Bean.class.getName())) {
                this.addDeducedBeanTypeForBeanMethod(context, (MethodMetadata)metadata, beanTypes);
            }
        }

        private void addDeducedBeanTypeForBeanMethod(ConditionContext context, MethodMetadata metadata, List<String> beanTypes) {
            try {
                Class returnType = ClassUtils.forName((String)metadata.getReturnTypeName(), (ClassLoader)context.getClassLoader());
                beanTypes.add(returnType.getName());
            }
            catch (Throwable ex) {
                throw new BeanTypeDeductionException(metadata.getDeclaringClassName(), metadata.getMethodName(), ex);
            }
        }

        public SearchStrategy getStrategy() {
            return this.strategy != null ? this.strategy : SearchStrategy.ALL;
        }

        public List<String> getNames() {
            return this.names;
        }

        public List<String> getTypes() {
            return this.types;
        }

        public List<String> getAnnotations() {
            return this.annotations;
        }

        public List<String> getIgnoredTypes() {
            return this.ignoredTypes;
        }

        public String toString() {
            StringBuilder string = new StringBuilder();
            string.append("(");
            if (!this.names.isEmpty()) {
                string.append("names: ");
                string.append(StringUtils.collectionToCommaDelimitedString(this.names));
                if (!this.types.isEmpty()) {
                    string.append("; ");
                }
            }
            if (!this.types.isEmpty()) {
                string.append("types: ");
                string.append(StringUtils.collectionToCommaDelimitedString(this.types));
            }
            string.append("; SearchStrategy: ");
            string.append(this.strategy.toString().toLowerCase());
            string.append(")");
            return string.toString();
        }
    }
}

