/*
 * Decompiled with CFR 0.152.
 */
package com.github.trang.autoconfigure.context;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringContextHolder
implements ApplicationContextAware {
    private static volatile ApplicationContext context;

    public static ApplicationContext getContext() {
        return context;
    }

    public static <T> T getBean(Class<T> type) {
        return (T)context.getBean(type);
    }

    public static <T> T getBean(String name, Class<T> type) {
        return (T)context.getBean(name, type);
    }

    public static boolean containsBean(String name) {
        return context.containsBean(name);
    }

    public static boolean isSingleton(String name) {
        return context.isSingleton(name);
    }

    public static boolean isPrototype(String name) {
        return context.isPrototype(name);
    }

    public static boolean isPrototype(String name, Class<?> type) {
        return context.isTypeMatch(name, type);
    }

    public static Class<?> getType(String name) {
        return context.getType(name);
    }

    public static String[] getAliases(String name) {
        return context.getAliases(name);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> type) {
        return context.getBeansOfType(type);
    }

    public static Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) {
        return context.getBeansWithAnnotation(annotationType);
    }

    public static String[] getBeanNamesForType(Class<?> type) {
        return context.getBeanNamesForType(type);
    }

    public static String[] getBeanNamesForAnnotation(Class<? extends Annotation> annotationType) {
        return context.getBeanNamesForAnnotation(annotationType);
    }

    public static String[] getBeanDefinitionNames() {
        return context.getBeanDefinitionNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (context != null) return;
        Class<SpringContextHolder> clazz = SpringContextHolder.class;
        synchronized (SpringContextHolder.class) {
            if (context != null) return;
            context = applicationContext;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

