/*
 * Decompiled with CFR 0.152.
 */
package com.github.trang.autoconfigure.context;

import java.util.Map;
import java.util.Objects;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotationMetadata;

@Configuration
@Import(value={SpringProfileImportSelector.class})
@AutoConfigureOrder(value=-2147483648)
public class SpringProfileAutoConfiguration {

    static class SpringProfileImportSelector
    implements ImportSelector,
    EnvironmentAware {
        private static final String CONFIGURE = "spring.profiles.configure.includes";
        private RelaxedPropertyResolver resolver;

        SpringProfileImportSelector() {
        }

        public String[] selectImports(AnnotationMetadata metadata) {
            Map properties = this.resolver.getSubProperties("");
            if (properties == null || properties.isEmpty()) {
                return new String[0];
            }
            return (String[])properties.values().stream().filter(Objects::nonNull).map(Objects::toString).map(String::trim).filter(s -> !s.isEmpty()).toArray(String[]::new);
        }

        public void setEnvironment(Environment environment) {
            this.resolver = new RelaxedPropertyResolver((PropertyResolver)environment, CONFIGURE);
        }
    }
}

