/*
 * Decompiled with CFR 0.152.
 */
package com.github.trang.autoconfigure.context;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

@Configuration
@AutoConfigureOrder(value=-2147483648)
@Import(value={SpringProfileImportSelector.class})
public class ApplicationProfileAutoConfiguration {

    static class SpringProfileImportSelector
    implements ImportSelector,
    EnvironmentAware {
        private static final String PREFIX = "spring.profiles.configure.includes";
        private Set<String> configurations;

        SpringProfileImportSelector() {
        }

        public String[] selectImports(AnnotationMetadata metadata) {
            return (String[])this.configurations.stream().filter(Objects::nonNull).map(String::trim).filter(s -> !s.isEmpty()).toArray(String[]::new);
        }

        public void setEnvironment(Environment environment) {
            this.configurations = (Set)Binder.get((Environment)environment).bind(PREFIX, Bindable.setOf(String.class)).orElse(Collections.emptySet());
        }
    }
}

