/*
 * Decompiled with CFR 0.152.
 */
package com.github.trang.autoconfigure.mybatis;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.visitor.VisitorFeature;
import com.github.trang.autoconfigure.mybatis.SqlFormatterInterceptor;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={DruidDataSource.class})
@ConditionalOnProperty(prefix="mybatis.configuration", name={"sql-format"}, havingValue="true")
@EnableConfigurationProperties(value={SqlFormatProperties.class, DbTypeProperties.class})
public class SqlFormatterConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public SqlSessionFactoryBeanPostProcessor sqlSessionFactoryBeanPostProcessor() {
        return new SqlSessionFactoryBeanPostProcessor();
    }

    static class SqlSessionFactoryBeanPostProcessor
    implements BeanPostProcessor {
        @Autowired
        private SqlFormatProperties sqlFormatProperties;
        @Autowired
        private DbTypeProperties dbTypeProperties;

        SqlSessionFactoryBeanPostProcessor() {
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof SqlSessionFactory) {
                SqlFormatterInterceptor sqlFormatterInterceptor = new SqlFormatterInterceptor(this.dbTypeProperties.getDbType(), this.sqlFormatProperties.getSqlFormatOption());
                SqlSessionFactory sqlSessionFactory = (SqlSessionFactory)bean;
                sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)sqlFormatterInterceptor);
            }
            return bean;
        }
    }

    @ConfigurationProperties(prefix="mybatis.configuration.sql-format-option")
    static class DbTypeProperties {
        private String dbType = "mysql";

        DbTypeProperties() {
        }

        public String getDbType() {
            return this.dbType;
        }

        public void setDbType(String dbType) {
            this.dbType = dbType;
        }
    }

    @ConfigurationProperties(prefix="mybatis.configuration")
    static class SqlFormatProperties {
        @NestedConfigurationProperty
        private SQLUtils.FormatOption sqlFormatOption = new SQLUtils.FormatOption(new VisitorFeature[]{VisitorFeature.OutputUCase});

        SqlFormatProperties() {
        }

        public SQLUtils.FormatOption getSqlFormatOption() {
            return this.sqlFormatOption;
        }

        public void setSqlFormatOption(SQLUtils.FormatOption sqlFormatOption) {
            this.sqlFormatOption = sqlFormatOption;
        }
    }
}

