/*
 * Decompiled with CFR 0.152.
 */
package com.github.trang.autoconfigure.mybatis;

import com.alibaba.druid.sql.SQLUtils;
import java.lang.reflect.Field;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class SqlFormatterInterceptor
implements Interceptor {
    private final String dbType;
    private SQLUtils.FormatOption formatOption;

    public Object intercept(Invocation invocation) throws Throwable {
        CacheKey cacheKey;
        BoundSql boundSql;
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        Object parameter = args[1];
        RowBounds rowBounds = (RowBounds)args[2];
        ResultHandler resultHandler = (ResultHandler)args[3];
        Executor executor = (Executor)invocation.getTarget();
        if (args.length == 4) {
            boundSql = ms.getBoundSql(parameter);
            cacheKey = executor.createCacheKey(ms, parameter, rowBounds, boundSql);
        } else {
            cacheKey = (CacheKey)args[4];
            boundSql = (BoundSql)args[5];
        }
        Field field = BoundSql.class.getDeclaredField("sql");
        field.setAccessible(true);
        String formattedSql = SQLUtils.format((String)boundSql.getSql(), (String)this.dbType, (SQLUtils.FormatOption)this.formatOption);
        String finalSql = formattedSql.replace(" ,", ",");
        field.set(boundSql, finalSql);
        return executor.query(ms, parameter, rowBounds, resultHandler, cacheKey, boundSql);
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    public SqlFormatterInterceptor(String dbType) {
        this.dbType = dbType;
    }

    public SqlFormatterInterceptor(String dbType, SQLUtils.FormatOption formatOption) {
        this.dbType = dbType;
        this.formatOption = formatOption;
    }

    public String getDbType() {
        return this.dbType;
    }

    public SQLUtils.FormatOption getFormatOption() {
        return this.formatOption;
    }

    public void setFormatOption(SQLUtils.FormatOption formatOption) {
        this.formatOption = formatOption;
    }
}

