/*
 * Decompiled with CFR 0.152.
 */
package com.github.trang.autoconfigure.mybatis;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandlerRegistry;

public class SqlUtils {
    private static final ObjectFactory DEFAULT_OBJECT_FACTORY = new DefaultObjectFactory();
    private static final ObjectWrapperFactory DEFAULT_OBJECT_WRAPPER_FACTORY = new DefaultObjectWrapperFactory();

    public static String getMapperSql(Object mapper, String methodName, Object ... args) {
        MetaObject metaObject = SystemMetaObject.forObject((Object)mapper);
        SqlSession session = (SqlSession)metaObject.getValue("h.sqlSession");
        Class mapperInterface = (Class)metaObject.getValue("h.mapperInterface");
        String fullMethodName = mapperInterface.getCanonicalName() + "." + methodName;
        if (args == null || args.length == 0) {
            return SqlUtils.getNamespaceSql(session, fullMethodName, null);
        }
        return SqlUtils.getMapperSql(session, mapperInterface, methodName, args);
    }

    public static String getMapperSql(SqlSession session, String fullMapperMethodName, Object ... args) {
        if (args == null || args.length == 0) {
            return SqlUtils.getNamespaceSql(session, fullMapperMethodName, null);
        }
        String methodName = fullMapperMethodName.substring(fullMapperMethodName.lastIndexOf(46) + 1);
        Class<?> mapperInterface = null;
        try {
            mapperInterface = Class.forName(fullMapperMethodName.substring(0, fullMapperMethodName.lastIndexOf(46)));
            return SqlUtils.getMapperSql(session, mapperInterface, methodName, args);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("\u53c2\u6570" + fullMapperMethodName + "\u65e0\u6548\uff01");
        }
    }

    public static String getMapperSql(SqlSession session, Class<?> mapperInterface, String methodName, Object ... args) {
        Object unParams;
        String fullMapperMethodName = mapperInterface.getCanonicalName() + "." + methodName;
        if (args == null || args.length == 0) {
            return SqlUtils.getNamespaceSql(session, fullMapperMethodName, null);
        }
        Method method = SqlUtils.getDeclaredMethods(mapperInterface, methodName);
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        Class<?>[] argTypes = method.getParameterTypes();
        for (int i = 0; i < argTypes.length; ++i) {
            if (RowBounds.class.isAssignableFrom(argTypes[i]) || ResultHandler.class.isAssignableFrom(argTypes[i])) continue;
            String paramName = "param" + String.valueOf(params.size() + 1);
            paramName = SqlUtils.getParamNameFromAnnotation(method, i, paramName);
            params.put(paramName, i >= args.length ? null : args[i]);
        }
        if (args.length == 1 && (unParams = SqlUtils.wrapCollection(args[0])) instanceof Map) {
            Map unParams2 = (Map)unParams;
            params.putAll(unParams2);
        }
        return SqlUtils.getNamespaceSql(session, fullMapperMethodName, params);
    }

    public static String getNamespaceSql(SqlSession session, String namespace) {
        return SqlUtils.getNamespaceSql(session, namespace, null);
    }

    public static String getNamespaceSql(SqlSession session, String namespace, Object params) {
        params = SqlUtils.wrapCollection(params);
        Configuration configuration = session.getConfiguration();
        MappedStatement mappedStatement = configuration.getMappedStatement(namespace);
        TypeHandlerRegistry typeHandlerRegistry = mappedStatement.getConfiguration().getTypeHandlerRegistry();
        BoundSql boundSql = mappedStatement.getBoundSql(params);
        List parameterMappings = boundSql.getParameterMappings();
        String sql = boundSql.getSql();
        if (parameterMappings != null) {
            for (int i = 0; i < parameterMappings.size(); ++i) {
                Object value;
                ParameterMapping parameterMapping = (ParameterMapping)parameterMappings.get(i);
                if (parameterMapping.getMode() == ParameterMode.OUT) continue;
                String propertyName = parameterMapping.getProperty();
                if (boundSql.hasAdditionalParameter(propertyName)) {
                    value = boundSql.getAdditionalParameter(propertyName);
                } else if (params == null) {
                    value = null;
                } else if (typeHandlerRegistry.hasTypeHandler(params.getClass())) {
                    value = params;
                } else {
                    MetaObject metaObject = configuration.newMetaObject(params);
                    value = metaObject.getValue(propertyName);
                }
                JdbcType jdbcType = parameterMapping.getJdbcType();
                if (value == null && jdbcType == null) {
                    jdbcType = configuration.getJdbcTypeForNull();
                }
                sql = SqlUtils.replaceParameter(sql, value, jdbcType, parameterMapping.getJavaType());
            }
        }
        return sql;
    }

    private static String replaceParameter(String sql, Object value, JdbcType jdbcType, Class<?> javaType) {
        String strValue = String.valueOf(value);
        if (jdbcType != null) {
            switch (jdbcType) {
                case BIT: 
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case BIGINT: 
                case FLOAT: 
                case REAL: 
                case DOUBLE: 
                case NUMERIC: 
                case DECIMAL: {
                    break;
                }
                default: {
                    strValue = "'" + strValue + "'";
                    break;
                }
            }
        } else if (!Number.class.isAssignableFrom(javaType)) {
            strValue = "'" + strValue + "'";
        }
        return sql.replaceFirst("\\?", strValue);
    }

    private static Method getDeclaredMethods(Class<?> clazz, String methodName) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        throw new IllegalArgumentException("\u65b9\u6cd5" + methodName + "\u4e0d\u5b58\u5728\uff01");
    }

    private static String getParamNameFromAnnotation(Method method, int i, String paramName) {
        Annotation[] paramAnnos;
        for (Annotation paramAnno : paramAnnos = method.getParameterAnnotations()[i]) {
            if (!(paramAnno instanceof Param)) continue;
            paramName = ((Param)paramAnno).value();
        }
        return paramName;
    }

    private static Object wrapCollection(Object object) {
        if (object instanceof List) {
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            map.put("list", object);
            return map;
        }
        if (object != null && object.getClass().isArray()) {
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            map.put("array", object);
            return map;
        }
        return object;
    }
}

