/*
 * Decompiled with CFR 0.152.
 */
package com.dxy.library.json.jackson;

import com.dxy.library.json.jackson.exception.JacksonException;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonUtil {
    private static final Logger log = LoggerFactory.getLogger(JacksonUtil.class);
    private static ObjectMapper mapper;
    private static final Set<JsonReadFeature> JSON_READ_FEATURES_ENABLED;

    public static ObjectMapper initMapper() {
        JsonMapper.Builder builder = JsonMapper.builder().enable(JSON_READ_FEATURES_ENABLED.toArray(new JsonReadFeature[0]));
        return JacksonUtil.initMapperConfig(builder.build());
    }

    public static ObjectMapper initMapperConfig(ObjectMapper objectMapper) {
        String dateTimeFormat = "yyyy-MM-dd HH:mm:ss";
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat(dateTimeFormat));
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(SerializationFeature.INDENT_OUTPUT, false);
        objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        objectMapper.enable(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY);
        objectMapper.enable(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.IGNORE_UNKNOWN});
        objectMapper.enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN});
        objectMapper.registerModule((Module)new ParameterNamesModule());
        objectMapper.registerModule((Module)new Jdk8Module());
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern(dateTimeFormat))).addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern(dateTimeFormat)));
        objectMapper.registerModule((Module)javaTimeModule);
        objectMapper.registerModule((Module)new GuavaModule());
        return objectMapper;
    }

    public static ObjectMapper getObjectMapper() {
        return mapper;
    }

    public static <V> V from(URL url, Class<V> type) {
        try {
            return (V)mapper.readValue(url, type);
        }
        catch (IOException e) {
            throw new JacksonException("jackson from error, url: {}, type: {}", url.getPath(), type, e);
        }
    }

    public static <V> V from(URL url, TypeReference<V> type) {
        try {
            return (V)mapper.readValue(url, type);
        }
        catch (IOException e) {
            throw new JacksonException("jackson from error, url: {}, type: {}", url.getPath(), type, e);
        }
    }

    public static <V> List<V> fromList(URL url, Class<V> type) {
        try {
            CollectionType collectionType = mapper.getTypeFactory().constructCollectionType(ArrayList.class, type);
            return (List)mapper.readValue(url, (JavaType)collectionType);
        }
        catch (IOException e) {
            throw new JacksonException("jackson from error, url: {}, type: {}", url.getPath(), type, e);
        }
    }

    public static <V> V from(InputStream inputStream, Class<V> type) {
        try {
            return (V)mapper.readValue(inputStream, type);
        }
        catch (IOException e) {
            throw new JacksonException("jackson from error, type: {}", type, e);
        }
    }

    public static <V> V from(InputStream inputStream, TypeReference<V> type) {
        try {
            return (V)mapper.readValue(inputStream, type);
        }
        catch (IOException e) {
            throw new JacksonException("jackson from error, type: {}", type, e);
        }
    }

    public static <V> List<V> fromList(InputStream inputStream, Class<V> type) {
        try {
            CollectionType collectionType = mapper.getTypeFactory().constructCollectionType(ArrayList.class, type);
            return (List)mapper.readValue(inputStream, (JavaType)collectionType);
        }
        catch (IOException e) {
            throw new JacksonException("jackson from error, type: {}", type, e);
        }
    }

    public static <V> V from(File file, Class<V> type) {
        try {
            return (V)mapper.readValue(file, type);
        }
        catch (IOException e) {
            throw new JacksonException("jackson from error, file path: {}, type: {}", file.getPath(), type, e);
        }
    }

    public static <V> V from(File file, TypeReference<V> type) {
        try {
            return (V)mapper.readValue(file, type);
        }
        catch (IOException e) {
            throw new JacksonException("jackson from error, file path: {}, type: {}", file.getPath(), type, e);
        }
    }

    public static <V> List<V> fromList(File file, Class<V> type) {
        try {
            CollectionType collectionType = mapper.getTypeFactory().constructCollectionType(ArrayList.class, type);
            return (List)mapper.readValue(file, (JavaType)collectionType);
        }
        catch (IOException e) {
            throw new JacksonException("jackson from error, file path: {}, type: {}", file.getPath(), type, e);
        }
    }

    public static <V> V from(String json, Class<V> type) {
        return JacksonUtil.from(json, type);
    }

    public static <V> V from(String json, TypeReference<V> type) {
        return JacksonUtil.from(json, type.getType());
    }

    public static <V> V from(String json, Type type) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            JavaType javaType = mapper.getTypeFactory().constructType(type);
            return (V)mapper.readValue(json, javaType);
        }
        catch (IOException e) {
            throw new JacksonException("jackson from error, json: {}, type: {}", json, type, e);
        }
    }

    public static <V> List<V> fromList(String json, Class<V> type) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            CollectionType collectionType = mapper.getTypeFactory().constructCollectionType(ArrayList.class, type);
            return (List)mapper.readValue(json, (JavaType)collectionType);
        }
        catch (IOException e) {
            throw new JacksonException("jackson from error, json: {}, type: {}", json, type, e);
        }
    }

    public static Map<String, Object> fromMap(String json) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            MapType mapType = mapper.getTypeFactory().constructMapType(HashMap.class, String.class, Object.class);
            return (Map)mapper.readValue(json, (JavaType)mapType);
        }
        catch (IOException e) {
            throw new JacksonException("jackson from error, json: {}, type: {}", json, e);
        }
    }

    public static <V> String to(List<V> list) {
        try {
            return mapper.writeValueAsString(list);
        }
        catch (JsonProcessingException e) {
            throw new JacksonException("jackson to error, data: {}", new Object[]{list, e});
        }
    }

    public static <V> String to(V v) {
        try {
            return mapper.writeValueAsString(v);
        }
        catch (JsonProcessingException e) {
            throw new JacksonException("jackson to error, data: {}", new Object[]{v, e});
        }
    }

    public static <V> void toFile(String path, List<V> list) {
        try (FileWriter writer = new FileWriter(new File(path), true);){
            mapper.writer().writeValues((Writer)writer).writeAll(list);
        }
        catch (Exception e) {
            throw new JacksonException("jackson to file error, path: {}, list: {}", path, list, e);
        }
    }

    public static <V> void toFile(String path, V v) {
        try (FileWriter writer = new FileWriter(new File(path), true);){
            mapper.writer().writeValues((Writer)writer).write(v);
        }
        catch (Exception e) {
            throw new JacksonException("jackson to file error, path: {}, data: {}", path, v, e);
        }
    }

    public static String getAsString(String json, String key) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            JsonNode jsonNode = JacksonUtil.getAsJsonObject(json, key);
            if (null == jsonNode) {
                return null;
            }
            return JacksonUtil.getAsString(jsonNode);
        }
        catch (Exception e) {
            throw new JacksonException("jackson get string error, json: {}, key: {}", json, key, e);
        }
    }

    private static String getAsString(JsonNode jsonNode) {
        return jsonNode.isTextual() ? jsonNode.textValue() : jsonNode.toString();
    }

    public static int getAsInt(String json, String key) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return 0;
        }
        try {
            JsonNode jsonNode = JacksonUtil.getAsJsonObject(json, key);
            if (null == jsonNode) {
                return 0;
            }
            return jsonNode.isInt() ? jsonNode.intValue() : Integer.parseInt(JacksonUtil.getAsString(jsonNode));
        }
        catch (Exception e) {
            throw new JacksonException("jackson get int error, json: {}, key: {}", json, key, e);
        }
    }

    public static long getAsLong(String json, String key) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return 0L;
        }
        try {
            JsonNode jsonNode = JacksonUtil.getAsJsonObject(json, key);
            if (null == jsonNode) {
                return 0L;
            }
            return jsonNode.isLong() ? jsonNode.longValue() : Long.parseLong(JacksonUtil.getAsString(jsonNode));
        }
        catch (Exception e) {
            throw new JacksonException("jackson get long error, json: {}, key: {}", json, key, e);
        }
    }

    public static double getAsDouble(String json, String key) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return 0.0;
        }
        try {
            JsonNode jsonNode = JacksonUtil.getAsJsonObject(json, key);
            if (null == jsonNode) {
                return 0.0;
            }
            return jsonNode.isDouble() ? jsonNode.doubleValue() : Double.parseDouble(JacksonUtil.getAsString(jsonNode));
        }
        catch (Exception e) {
            throw new JacksonException("jackson get double error, json: {}, key: {}", json, key, e);
        }
    }

    public static BigInteger getAsBigInteger(String json, String key) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return new BigInteger(String.valueOf(0.0));
        }
        try {
            JsonNode jsonNode = JacksonUtil.getAsJsonObject(json, key);
            if (null == jsonNode) {
                return new BigInteger(String.valueOf(0.0));
            }
            return jsonNode.isBigInteger() ? jsonNode.bigIntegerValue() : new BigInteger(JacksonUtil.getAsString(jsonNode));
        }
        catch (Exception e) {
            throw new JacksonException("jackson get big integer error, json: {}, key: {}", json, key, e);
        }
    }

    public static BigDecimal getAsBigDecimal(String json, String key) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return new BigDecimal("0.00");
        }
        try {
            JsonNode jsonNode = JacksonUtil.getAsJsonObject(json, key);
            if (null == jsonNode) {
                return new BigDecimal("0.00");
            }
            return jsonNode.isBigDecimal() ? jsonNode.decimalValue() : new BigDecimal(JacksonUtil.getAsString(jsonNode));
        }
        catch (Exception e) {
            throw new JacksonException("jackson get big decimal error, json: {}, key: {}", json, key, e);
        }
    }

    public static boolean getAsBoolean(String json, String key) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return false;
        }
        try {
            JsonNode jsonNode = JacksonUtil.getAsJsonObject(json, key);
            if (null == jsonNode) {
                return false;
            }
            if (jsonNode.isBoolean()) {
                return jsonNode.booleanValue();
            }
            if (jsonNode.isTextual()) {
                String textValue = jsonNode.textValue();
                if ("1".equals(textValue)) {
                    return true;
                }
                return BooleanUtils.toBoolean((String)textValue);
            }
            return BooleanUtils.toBoolean((int)jsonNode.intValue());
        }
        catch (Exception e) {
            throw new JacksonException("jackson get boolean error, json: {}, key: {}", json, key, e);
        }
    }

    public static byte[] getAsBytes(String json, String key) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            JsonNode jsonNode = JacksonUtil.getAsJsonObject(json, key);
            if (null == jsonNode) {
                return null;
            }
            return jsonNode.isBinary() ? jsonNode.binaryValue() : JacksonUtil.getAsString(jsonNode).getBytes();
        }
        catch (Exception e) {
            throw new JacksonException("jackson get byte error, json: {}, key: {}", json, key, e);
        }
    }

    public static <V> V getAsObject(String json, String key, Class<V> type) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            JsonNode jsonNode = JacksonUtil.getAsJsonObject(json, key);
            if (null == jsonNode) {
                return null;
            }
            JavaType javaType = mapper.getTypeFactory().constructType(type);
            return JacksonUtil.from(JacksonUtil.getAsString(jsonNode), (Type)javaType);
        }
        catch (Exception e) {
            throw new JacksonException("jackson get list error, json: {}, key: {}, type: {}", json, key, type, e);
        }
    }

    public static <V> List<V> getAsList(String json, String key, Class<V> type) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            JsonNode jsonNode = JacksonUtil.getAsJsonObject(json, key);
            if (null == jsonNode) {
                return null;
            }
            CollectionType collectionType = mapper.getTypeFactory().constructCollectionType(ArrayList.class, type);
            return (List)JacksonUtil.from(JacksonUtil.getAsString(jsonNode), (Type)collectionType);
        }
        catch (Exception e) {
            throw new JacksonException("jackson get list error, json: {}, key: {}, type: {}", json, key, type, e);
        }
    }

    public static JsonNode getAsJsonObject(String json, String key) {
        try {
            JsonNode node = mapper.readTree(json);
            if (null == node) {
                return null;
            }
            return node.get(key);
        }
        catch (IOException e) {
            throw new JacksonException("jackson get object from json error, json: {}, key: {}", json, key, e);
        }
    }

    public static <V> String add(String json, String key, V value) {
        try {
            JsonNode node = mapper.readTree(json);
            JacksonUtil.add(node, key, value);
            return node.toString();
        }
        catch (IOException e) {
            throw new JacksonException("jackson add error, json: {}, key: {}, value: {}", json, key, value, e);
        }
    }

    private static <V> void add(JsonNode jsonNode, String key, V value) {
        if (value instanceof String) {
            ((ObjectNode)jsonNode).put(key, (String)value);
        } else if (value instanceof Short) {
            ((ObjectNode)jsonNode).put(key, (Short)value);
        } else if (value instanceof Integer) {
            ((ObjectNode)jsonNode).put(key, (Integer)value);
        } else if (value instanceof Long) {
            ((ObjectNode)jsonNode).put(key, (Long)value);
        } else if (value instanceof Float) {
            ((ObjectNode)jsonNode).put(key, (Float)value);
        } else if (value instanceof Double) {
            ((ObjectNode)jsonNode).put(key, (Double)value);
        } else if (value instanceof BigDecimal) {
            ((ObjectNode)jsonNode).put(key, (BigDecimal)value);
        } else if (value instanceof BigInteger) {
            ((ObjectNode)jsonNode).put(key, (BigInteger)value);
        } else if (value instanceof Boolean) {
            ((ObjectNode)jsonNode).put(key, (Boolean)value);
        } else if (value instanceof byte[]) {
            ((ObjectNode)jsonNode).put(key, (byte[])value);
        } else {
            ((ObjectNode)jsonNode).put(key, JacksonUtil.to(value));
        }
    }

    public static String remove(String json, String key) {
        try {
            JsonNode node = mapper.readTree(json);
            ((ObjectNode)node).remove(key);
            return node.toString();
        }
        catch (IOException e) {
            throw new JacksonException("jackson remove error, json: {}, key: {}", json, key, e);
        }
    }

    public static <V> String update(String json, String key, V value) {
        try {
            JsonNode node = mapper.readTree(json);
            ((ObjectNode)node).remove(key);
            JacksonUtil.add(node, key, value);
            return node.toString();
        }
        catch (IOException e) {
            throw new JacksonException("jackson update error, json: {}, key: {}, value: {}", json, key, value, e);
        }
    }

    public static String format(String json) {
        try {
            JsonNode node = mapper.readTree(json);
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)node);
        }
        catch (IOException e) {
            throw new JacksonException("jackson format json error, json: {}", json, e);
        }
    }

    public static boolean isJson(String json) {
        try {
            mapper.readTree(json);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        JSON_READ_FEATURES_ENABLED = Sets.newHashSet((Object[])new JsonReadFeature[]{JsonReadFeature.ALLOW_JAVA_COMMENTS, JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES, JsonReadFeature.ALLOW_SINGLE_QUOTES, JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS, JsonReadFeature.ALLOW_LEADING_ZEROS_FOR_NUMBERS, JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS, JsonReadFeature.ALLOW_MISSING_VALUES, JsonReadFeature.ALLOW_TRAILING_COMMA});
        try {
            mapper = JacksonUtil.initMapper();
        }
        catch (Exception e) {
            log.error("jackson config error", (Throwable)e);
        }
    }
}

