/*
 * Decompiled with CFR 0.152.
 */
package com.github.dzieciou.testing.curl;

import com.github.dzieciou.testing.curl.CurlHandler;
import com.github.dzieciou.testing.curl.Http2Curl;
import com.github.dzieciou.testing.curl.Options;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurlGeneratingInterceptor
implements HttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)"curl");
    private final Options options;
    private final Http2Curl http2Curl;
    private final List<CurlHandler> handlers;

    public CurlGeneratingInterceptor(Options options, List<CurlHandler> handlers) {
        if (handlers.isEmpty()) {
            throw new IllegalArgumentException("Missing handlers, at least one should be given");
        }
        this.options = options;
        this.handlers = new ArrayList<CurlHandler>(handlers);
        this.http2Curl = new Http2Curl(options);
    }

    private static void printStacktrace(StringBuffer sb) {
        StackTraceElement[] trace;
        for (StackTraceElement traceElement : trace = Thread.currentThread().getStackTrace()) {
            sb.append("\tat ").append(traceElement).append(System.lineSeparator());
        }
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        try {
            String curl = this.http2Curl.generateCurl(request);
            StringBuffer message = new StringBuffer(curl);
            if (this.options.canLogStacktrace()) {
                message.append(String.format("%n\tgenerated%n", new Object[0]));
                CurlGeneratingInterceptor.printStacktrace(message);
            }
            String finalMessage = message.toString();
            this.handlers.forEach(h -> h.handle(finalMessage, this.options));
        }
        catch (Exception e) {
            log.warn("Failed to generate CURL command for HTTP request", (Throwable)e);
        }
    }
}

