/*
 * Decompiled with CFR 0.152.
 */
package com.github;

import com.github.collector.LogCollector;
import com.github.collector.NothingCollector;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@ComponentScan
@Configuration
public class AopLogAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AopLogAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={LogCollector.class})
    public LogCollector nothingCollector() {
        return new NothingCollector();
    }

    @Bean
    @ConditionalOnMissingBean(name={"collectorAsyncExecutor"})
    public Executor collectorAsyncExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(5);
        executor.setMaxPoolSize(10);
        executor.setQueueCapacity(256);
        executor.setThreadNamePrefix("collectorAsyncExecutor-");
        executor.setRejectedExecutionHandler((r, exec) -> log.error("collectorAsyncExecutor thread queue is full,activeCount:{},Subsequent collection tasks will be rejected,please check your LogCollector or config your Executor", (Object)exec.getActiveCount()));
        executor.initialize();
        return executor;
    }
}

