/*
 * Decompiled with CFR 0.152.
 */
package com.github;

import com.github.AopLogConfig;
import com.github.AppNameHelper;
import com.github.CollectorExecutor;
import com.github.DataExtractor;
import com.github.LogData;
import com.github.SpringElSupporter;
import com.github.collector.LogCollector;
import com.github.collector.NothingCollector;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class AopLogProcessor {
    private final ApplicationContext applicationContext;
    private final CollectorExecutor collectorExecutor;
    private final LogCollector logCollector;
    private final SpringElSupporter elSupporter = new SpringElSupporter();
    private final Map<Class<? extends LogCollector>, LogCollector> collectors = new HashMap<Class<? extends LogCollector>, LogCollector>();
    private final String appName;

    public AopLogProcessor(@Autowired ApplicationContext applicationContext, @Autowired CollectorExecutor collectorExecutor, @Autowired LogCollector logCollector) {
        this.applicationContext = applicationContext;
        this.collectorExecutor = collectorExecutor;
        this.logCollector = logCollector;
        this.appName = AppNameHelper.getAppNameByApplicationContext(applicationContext);
    }

    public String getAppName() {
        return this.appName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object proceed(AopLogConfig config, ProceedingJoinPoint point) throws Throwable {
        try {
            LogData.removeCurrent();
            LogData data = LogData.getCurrent();
            Object object = this.proceed(config, data, point);
            return object;
        }
        finally {
            LogData.removeCurrent();
        }
    }

    private LogCollector selectLogCollector(Class<? extends LogCollector> clz) {
        LogCollector collector;
        block3: {
            if (clz == NothingCollector.class || clz == null) {
                return this.logCollector;
            }
            try {
                collector = (LogCollector)this.applicationContext.getBean(clz);
            }
            catch (Exception e) {
                collector = this.collectors.get(clz);
                if (collector != null) break block3;
                collector = (LogCollector)BeanUtils.instantiateClass(clz);
                this.collectors.put(clz, collector);
            }
        }
        return collector;
    }

    private Object proceed(AopLogConfig aopLog, LogData data, ProceedingJoinPoint point) throws Throwable {
        Object result = null;
        boolean success = false;
        try {
            result = point.proceed();
            success = true;
            Object object = result;
            return object;
        }
        catch (Throwable throwable) {
            if (aopLog.isStackTraceOnErr()) {
                try (StringWriter sw = new StringWriter();
                     PrintWriter writer = new PrintWriter((Writer)sw, true);){
                    throwable.printStackTrace(writer);
                    LogData.step("Fail : \n" + sw);
                }
            }
            throw throwable;
        }
        finally {
            if (!aopLog.isLogOnErr() || !data.isSuccess()) {
                data.setAppName(this.appName);
                data.setCostTime(System.currentTimeMillis() - data.getLogDate().getTime());
                MethodSignature signature = (MethodSignature)point.getSignature();
                data.setTag(this.elSupporter.getByExpression(signature.getMethod(), point.getTarget(), point.getArgs(), aopLog.getTag()).toString());
                data.setMethod(signature.getDeclaringTypeName() + "#" + signature.getName());
                DataExtractor.logHttpRequest(data, aopLog.getHeaders());
                if (aopLog.isArgs()) {
                    data.setArgs(DataExtractor.getArgs(signature.getParameterNames(), point.getArgs()));
                }
                if (aopLog.isRespBody()) {
                    data.setRespBody(DataExtractor.getResult(result));
                }
                data.setSuccess(success);
                LogData.setCurrent(data);
                if (aopLog.isAsyncMode()) {
                    this.collectorExecutor.asyncExecute(this.selectLogCollector(aopLog.getCollector()), LogData.getCurrent());
                } else {
                    this.collectorExecutor.execute(this.selectLogCollector(aopLog.getCollector()), LogData.getCurrent());
                }
            }
        }
    }
}

