/*
 * Decompiled with CFR 0.152.
 */
package com.github;

import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public class AppNameHelper {
    private AppNameHelper() {
    }

    public static String getAppNameByApplicationContext(ApplicationContext applicationContext) {
        StackTraceElement[] stackTrace;
        Environment environment = applicationContext.getEnvironment();
        String name = environment.getProperty("spring.application.name");
        if (name != null) {
            return name;
        }
        if (applicationContext.getId() != null) {
            return applicationContext.getId();
        }
        for (StackTraceElement stackTraceElement : stackTrace = Thread.currentThread().getStackTrace()) {
            if (!"main".equals(stackTraceElement.getMethodName())) continue;
            return stackTraceElement.getFileName();
        }
        return applicationContext.getApplicationName();
    }
}

