/*
 * Decompiled with CFR 0.152.
 */
package com.github;

import com.github.LogData;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class DataExtractor {
    private static final Logger log = LoggerFactory.getLogger(DataExtractor.class);
    private static final String AND_REG = "&";
    private static final String EQUALS_REG = "=";
    private static final Map<Class<?>, Marshaller> marshallerMap = new HashMap();

    private DataExtractor() {
    }

    public static HttpServletRequest getRequest() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return attributes != null ? attributes.getRequest() : null;
    }

    public static HttpServletResponse getResponse() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return attributes != null ? attributes.getResponse() : null;
    }

    public static Object getArgs(String[] parameterNames, Object[] args) {
        Object target = args.length == 1 ? args[0] : args;
        if (target == null) {
            return null;
        }
        HttpServletRequest request = DataExtractor.getRequest();
        if (request != null && request.getContentType() != null) {
            String contentType = request.getContentType();
            if ("application/xml".equals(contentType)) {
                return DataExtractor.xmlArgs(target);
            }
            if ("application/json".equals(contentType)) {
                return target;
            }
        }
        return DataExtractor.appletArgs(parameterNames, args);
    }

    public static Object getResult(Object resp) {
        if (resp == null) {
            return null;
        }
        HttpServletResponse response = DataExtractor.getResponse();
        if (response != null && "application/xml".equals(response.getContentType())) {
            return DataExtractor.xmlArgs(resp);
        }
        return resp;
    }

    public static Object appletArgs(String[] parameterNames, Object[] args) {
        if (parameterNames == null || parameterNames.length == 0 || args == null || args.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parameterNames.length; ++i) {
            String parameterValue = "";
            if (args[i] != null) {
                parameterValue = args[i].toString();
            }
            sb.append(parameterNames[i]).append(EQUALS_REG).append(parameterValue).append(AND_REG);
        }
        if (sb.lastIndexOf(AND_REG) != -1) {
            sb.deleteCharAt(sb.lastIndexOf(AND_REG));
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object xmlArgs(Object pointArgs) {
        try (StringWriter writer = new StringWriter();){
            Marshaller marshaller = DataExtractor.getMarshaller(pointArgs.getClass());
            if (marshaller == null) return pointArgs;
            marshaller.marshal(pointArgs, (Writer)writer);
            String string = writer.toString().replace("standalone=\"yes\"", "");
            return string;
        }
        catch (JAXBException e) {
            log.warn("parse xml data exception", e.getLinkedException());
            return pointArgs;
        }
        catch (IOException e) {
            log.warn("writer close exception", (Throwable)e);
        }
        return pointArgs;
    }

    private static Marshaller getMarshaller(Class<?> clz) throws JAXBException {
        if (marshallerMap.containsKey(clz)) {
            return marshallerMap.get(clz);
        }
        Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{clz}).createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)false);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshallerMap.put(clz, marshaller);
        return marshaller;
    }

    public static void logHttpRequest(LogData data, String[] headers) {
        HttpServletRequest request = DataExtractor.getRequest();
        if (request != null) {
            data.setHost(request.getLocalAddr());
            data.setPort(request.getLocalPort());
            data.setClientIp(request.getRemoteAddr());
            data.setReqUrl(request.getRequestURL().toString());
            data.setHttpMethod(request.getMethod());
            HashMap<String, String> headersMap = new HashMap<String, String>(8);
            for (String header : headers) {
                headersMap.put(header, request.getHeader(header));
            }
            data.setHeaders(headersMap);
        }
    }
}

