/*
 * Decompiled with CFR 0.152.
 */
package com.github;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.context.expression.MethodBasedEvaluationContext;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.StringUtils;

public class SpringElSupporter {
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private final ParameterNameDiscoverer paramNameDiscoverer = new DefaultParameterNameDiscoverer();
    private final Map<String, Expression> expressions = new HashMap<String, Expression>();

    public Object getByExpression(Method method, Object target, Object[] args, String expressionString) {
        try {
            if (StringUtils.hasText((String)expressionString)) {
                MethodBasedEvaluationContext evaluationContext = new MethodBasedEvaluationContext((Object)new ExpressionRootObject(target, args), method, args, this.paramNameDiscoverer);
                if (this.expressions.containsKey(expressionString)) {
                    return this.expressions.get(expressionString).getValue((EvaluationContext)evaluationContext);
                }
                Expression expression = this.parser.parseExpression(expressionString);
                Object value = expression.getValue((EvaluationContext)evaluationContext);
                this.expressions.put(expressionString, expression);
                return value;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return expressionString;
    }

    static class ExpressionRootObject {
        private Object target;
        private Object[] args;

        public ExpressionRootObject(Object target, Object[] args) {
            this.target = target;
            this.args = args;
        }

        public Object getTarget() {
            return this.target;
        }

        public void setTarget(Object target) {
            this.target = target;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public void setArgs(Object[] args) {
            this.args = args;
        }
    }
}

