/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.util;

import com.sap.conn.jco.util.SharedStorage;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSharedStorage<K, V>
implements SharedStorage<K, V> {
    private String name;
    private Map<K, V> map;

    public DefaultSharedStorage(String name) {
        this.name = name;
        this.map = new Hashtable();
    }

    @Override
    public V store(K key, V obj) {
        V removed = this.map.put(key, obj);
        return removed;
    }

    @Override
    public V remove(K key) {
        V removed = this.map.remove(key);
        return removed;
    }

    @Override
    public V get(K key) {
        V value = this.map.get(key);
        return value;
    }

    @Override
    public V getMutableValue(K key) {
        V value = this.map.get(key);
        return value;
    }

    @Override
    public boolean contains(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public Collection<K> getAllKeys() {
        return this.map.keySet();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeLocked(Runnable toRun) {
        Map<K, V> map = this.map;
        synchronized (map) {
            toRun.run();
        }
    }

    @Override
    public boolean supportsSharedLocking() {
        return false;
    }
}

