/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.util;

import java.util.HashMap;
import java.util.Locale;

public abstract class Language {
    static HashMap<String, MapEntry> t002 = new HashMap(101);

    public static String getISOLanguage(Locale locale) {
        if (locale == null) {
            return null;
        }
        String language = locale.getLanguage();
        if (language == null) {
            return null;
        }
        if ((language = language.toUpperCase(Locale.ENGLISH)).length() != 2) {
            return null;
        }
        if (language.equals("ZH")) {
            String country = locale.getCountry();
            if (country == null) {
                return "ZH";
            }
            if ((country = country.toUpperCase(Locale.ENGLISH)).equals("TW") || country.equals("HK")) {
                return "ZF";
            }
            return "ZH";
        }
        if (language.equals("IW")) {
            return "HE";
        }
        if (language.equals("IN")) {
            return "ID";
        }
        char c1 = language.charAt(0);
        char c2 = language.charAt(1);
        if (' ' < c1 && c1 < '\u0080' && ' ' < c2 && c2 < '\u0080') {
            return language;
        }
        return null;
    }

    public static String getISOLanguage(String language) {
        if (language == null || language.length() == 0 || language.length() > 2) {
            return null;
        }
        MapEntry entry = t002.get(language);
        if (entry != null) {
            return entry.isoLanguage;
        }
        if (language.length() == 1) {
            char ch = language.charAt(0);
            if ('\uac60' < ch && ch < '\ud000') {
                ch = (char)(ch - 44032);
                char c1 = Character.toUpperCase((char)(ch / 96 + 32));
                char c2 = Character.toUpperCase((char)(ch % 96 + 32));
                if (c2 != ' ') {
                    return new String(new char[]{c1, c2});
                }
            }
        } else {
            char c1 = Character.toUpperCase(language.charAt(0));
            char c2 = Character.toUpperCase(language.charAt(1));
            if (' ' < c1 && c1 < '\u0080' && ' ' < c2 && c2 < '\u0080') {
                return new String(new char[]{c1, c2});
            }
        }
        return null;
    }

    public static String getSAPLanguage(Locale locale) {
        return Language.getSAPLanguage(Language.getISOLanguage(locale));
    }

    public static String getSAPLanguage(String language) {
        if (language == null || language.length() == 0 || language.length() > 2) {
            return null;
        }
        MapEntry entry = t002.get(language);
        if (entry != null) {
            return entry.sapLanguage;
        }
        if (language.length() == 1) {
            char ch = language.charAt(0);
            if ('\uac60' < ch && ch < '\ud000') {
                ch = (char)(ch - 44032);
                char c1 = Character.toUpperCase((char)(ch / 96 + 32));
                char c2 = Character.toUpperCase((char)(ch % 96 + 32));
                if (c2 != ' ') {
                    entry = t002.get(new String(new char[]{c1, c2}));
                    if (entry != null) {
                        return entry.sapLanguage;
                    }
                    return String.valueOf((char)((c1 - 32) * 96 + (c2 - 32) + 44032));
                }
            }
        } else {
            char c1 = Character.toUpperCase(language.charAt(0));
            char c2 = Character.toUpperCase(language.charAt(1));
            if (' ' < c1 && c1 < '\u0080' && ' ' < c2 && c2 < '\u0080') {
                return String.valueOf((char)((c1 - 32) * 96 + (c2 - 32) + 44032));
            }
        }
        return null;
    }

    static {
        new MapEntry("0", "SR", "Serbian");
        new MapEntry("1", "ZH", "Chinese");
        new MapEntry("2", "TH", "Thai");
        new MapEntry("3", "KO", "Korean");
        new MapEntry("4", "RO", "Romanian");
        new MapEntry("5", "SL", "Slovenian");
        new MapEntry("6", "HR", "Croatian");
        new MapEntry("7", "MS", "Malay");
        new MapEntry("8", "UK", "Ukrainian");
        new MapEntry("9", "ET", "Estonian");
        new MapEntry("A", "AR", "Arabic");
        new MapEntry("B", "HE", "Hebrew");
        new MapEntry("C", "CS", "Czech");
        new MapEntry("D", "DE", "German");
        new MapEntry("E", "EN", "English");
        new MapEntry("F", "FR", "French");
        new MapEntry("G", "EL", "Greek");
        new MapEntry("H", "HU", "Hungarian");
        new MapEntry("I", "IT", "Italian");
        new MapEntry("J", "JA", "Japanese");
        new MapEntry("K", "DA", "Danish");
        new MapEntry("L", "PL", "Polish");
        new MapEntry("M", "ZF", "Chinese trad.");
        new MapEntry("N", "NL", "Dutch");
        new MapEntry("O", "NO", "Norwegian");
        new MapEntry("P", "PT", "Portuguese");
        new MapEntry("Q", "SK", "Slovak");
        new MapEntry("R", "RU", "Russian");
        new MapEntry("S", "ES", "Spanish");
        new MapEntry("T", "TR", "Turkish");
        new MapEntry("U", "FI", "Finnish");
        new MapEntry("V", "SV", "Swedish");
        new MapEntry("W", "BG", "Bulgarian");
        new MapEntry("X", "LT", "Lithuanian");
        new MapEntry("Y", "LV", "Latvian");
        new MapEntry("Z", "Z1", "Reserved for Customer");
        new MapEntry("a", "AF", "Afrikaans");
        new MapEntry("b", "IS", "Icelandic");
        new MapEntry("c", "CA", "Catalan");
        new MapEntry("d", "SH", "Serbo-Croatian");
        new MapEntry("i", "ID", "Indonesian");
    }

    protected static class MapEntry {
        String sapLanguage;
        String isoLanguage;
        String description;

        protected MapEntry(String sapLanguage, String isoLanguage, String description) {
            this.sapLanguage = sapLanguage;
            this.isoLanguage = isoLanguage;
            this.description = description;
            t002.put(sapLanguage, this);
            t002.put(isoLanguage, this);
            char upper1 = isoLanguage.charAt(0);
            char upper2 = isoLanguage.charAt(1);
            char lower1 = Character.toLowerCase(upper1);
            char lower2 = Character.toLowerCase(upper2);
            t002.put(new StringBuilder(2).append(lower1).append(lower2).toString(), this);
            t002.put(new StringBuilder(2).append(upper1).append(lower2).toString(), this);
            t002.put(new StringBuilder(2).append(lower1).append(upper2).toString(), this);
        }
    }
}

