/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.driver;

import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.rfc.api.RfcAcceptInfo;
import com.sap.conn.rfc.api.RfcApi;
import com.sap.conn.rfc.api.RfcOptions;
import com.sap.conn.rfc.driver.CpicDriver;
import com.sap.conn.rfc.driver.LG;
import com.sap.conn.rfc.engine.GUID;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.exceptions.RfcException;
import java.io.UnsupportedEncodingException;

public final class RfcTypeDirectCpic
extends CpicDriver {
    private static byte[] traceHead = new byte[]{84};

    public RfcTypeDirectCpic(RfcIoOpenCntl iocntl) {
        super(iocntl);
    }

    public synchronized int listen(byte[] buffer, int bufsize, int[] bytes_read, int timeout) {
        return this.coxread(buffer, bufsize, bytes_read, timeout);
    }

    public synchronized int read(byte[] buffer, int bufsize, int[] bytes_read) {
        int rc = this.coxread(buffer, bufsize, bytes_read, 100);
        while (rc == -1) {
            if (this.act_cntl.RfcIsCanceled()) {
                bytes_read[0] = 0;
                rc = this.cancel();
                if (rc == 0) {
                    return 34;
                }
                return rc;
            }
            rc = this.coxread(buffer, bufsize, bytes_read, 100);
        }
        return rc;
    }

    public synchronized int open(RfcOptions options) throws RfcException {
        int rc = 0;
        this.act_cntl.rfc_uuid = GUID.Factory.createGUID();
        this.act_cntl.rfc_uuid_set = true;
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("UUID: ab_coxopen create uuid:");
            Trc.ab_rfctrc(GUID.toString(this.act_cntl.rfc_uuid));
            Trc.ab_rfctrc("\n");
        }
        this.deallocated = true;
        this.server_mode = false;
        this.act_cntl.signon = true;
        switch (options.getType()) {
            case 'E': 
            case 'R': {
                if (options.isTrace() <= 0) break;
                rc = this.ab_drvfill(traceHead);
                break;
            }
            default: {
                rc = this.ab_drvfill(this.get_com_head(options.isTrace()));
            }
        }
        if (rc != 0) {
            return 1;
        }
        if (this.cox_cpic_init(options) != 0) {
            return 1;
        }
        rc = this.CMALLC();
        if (rc != 0) {
            this.setMessageTRC(this.getErrorInfo("Connect from SAP gateway to RFC server failed", options));
            return 1;
        }
        this.act_cntl.updateConvID();
        this.deallocated = false;
        return 0;
    }

    public synchronized void abort() {
        if (!this.deallocated) {
            this.CMDEAL();
            this.deallocated = true;
        }
        this.tOfLastIO = System.currentTimeMillis();
    }

    public synchronized void close() {
        if (!this.deallocated) {
            this.CMDEAL();
            this.deallocated = true;
        }
        this.tOfLastIO = System.currentTimeMillis();
    }

    public int wflush() {
        if (this.deallocated || this.broken) {
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("wflush :: Error : (deallocated or broken)");
            }
            return 1;
        }
        return 0;
    }

    public synchronized int accept(RfcAcceptInfo acceptInfo) {
        return 1;
    }

    protected int cox_cpic_init(RfcOptions options) throws RfcException {
        String proto = null;
        String lu = null;
        String tp = null;
        String sysnr = null;
        String gwhost = null;
        String gwserv = null;
        String target = null;
        int rc = 0;
        int sncMode = options.getSnc_mode();
        String sncPartnerName = options.getSnc_partnername();
        String sapRouter = options.getSaprouter();
        switch (options.getType()) {
            case 'A': {
                proto = "I";
                target = options.getAshost();
                if (target == null) {
                    target = "";
                }
                if ((sysnr = options.getSysnr()) == null) {
                    sysnr = "";
                }
                lu = target;
                tp = new StringBuilder(7).append("sapdp").append(sysnr).toString();
                gwhost = options.getGwhost();
                if (gwhost == null) {
                    gwhost = target;
                }
                if (sapRouter != null && sapRouter.length() > 0) {
                    StringBuilder gwhost_buf = new StringBuilder(sapRouter.length() + gwhost.length() + 3);
                    gwhost_buf.append(sapRouter);
                    if (!sapRouter.endsWith("/H/")) {
                        gwhost_buf.append("/H/");
                    }
                    gwhost_buf.append(gwhost);
                    gwhost = gwhost_buf.toString();
                }
                if ((gwserv = options.getGwserv()) == null) {
                    gwserv = sysnr.length() == 0 ? "" : (options.useSymbolicService() ? (sncMode == 0 ? new StringBuilder(7).append("sapgw").append(sysnr).toString() : new StringBuilder(8).append("sapgw").append(sysnr).append('s').toString()) : (sncMode == 0 ? new StringBuilder(4).append("33").append(sysnr).toString() : new StringBuilder(4).append("48").append(sysnr).toString()));
                }
                this.act_cntl.target = new StringBuilder(target.length() + 3).append(target).append('|').append(sysnr).toString();
                this.act_cntl.sysid = "<empty>";
                break;
            }
            case 'B': {
                String msserv;
                proto = "I";
                String mshost = options.getMshost();
                if (mshost == null) {
                    mshost = "";
                }
                if (sapRouter != null && sapRouter.length() > 0) {
                    StringBuilder mshost_buf = new StringBuilder(sapRouter.length() + mshost.length() + 3);
                    mshost_buf.append(sapRouter);
                    if (!sapRouter.endsWith("/H/")) {
                        mshost_buf.append("/H/");
                    }
                    mshost_buf.append(mshost);
                    mshost = mshost_buf.toString();
                }
                if ((msserv = options.getMsserv()) == null) {
                    String r3name = options.getR3name();
                    if (r3name == null) {
                        msserv = "sapms";
                    } else if (r3name.length() == 4) {
                        char digit;
                        int i;
                        for (i = 0; i < 4 && (digit = r3name.charAt(i)) >= '0' && digit <= '9'; ++i) {
                        }
                        msserv = i == 4 ? r3name : new StringBuilder(8).append("sapms").append(r3name).toString();
                    } else {
                        msserv = new StringBuilder(8).append("sapms").append(r3name).toString();
                    }
                }
                byte[] ipAdr = new byte[100];
                int[] port = new int[1];
                if (sncMode == 0) {
                    rc = LG.get_MS(options.getGroup(), mshost, msserv, ipAdr, port, this.act_cntl);
                    if (rc != 0) {
                        this.setMessageTRC(this.getErrorInfo("Connect to message server host failed", options));
                        return 1;
                    }
                    sysnr = RfcOptions.sysNrToString(port[0] % 100);
                    gwserv = options.useSymbolicService() ? new StringBuilder(7).append("sapgw").append(sysnr).toString() : new StringBuilder(4).append("33").append(sysnr).toString();
                } else {
                    byte[] sncNameApp = new byte[256];
                    rc = LG.get_MS_SNC(options.getGroup(), mshost, msserv, sncPartnerName, sncNameApp, ipAdr, port, this.act_cntl);
                    if (rc != 0) {
                        this.setMessageTRC(this.getErrorInfo("Connect to message server host failed", options));
                        return 1;
                    }
                    sysnr = RfcOptions.sysNrToString(port[0] % 100);
                    gwserv = options.useSymbolicService() ? new StringBuilder(8).append("sapgw").append(sysnr).append('s').toString() : new StringBuilder(4).append("48").append(sysnr).toString();
                    try {
                        sncPartnerName = new String(sncNameApp, "UTF-8");
                        int endIdx = sncPartnerName.indexOf(0);
                        if (endIdx >= 0) {
                            sncPartnerName = sncPartnerName.substring(0, endIdx);
                        }
                    }
                    catch (UnsupportedEncodingException uee) {
                        // empty catch block
                    }
                }
                try {
                    target = new String(ipAdr, "UTF-8");
                    int endIdx = target.indexOf(0);
                    if (endIdx >= 0) {
                        target = target.substring(0, endIdx);
                    }
                }
                catch (UnsupportedEncodingException uee) {
                    // empty catch block
                }
                lu = target;
                tp = new StringBuilder(7).append("sapdp").append(sysnr).toString();
                gwhost = target;
                if (sapRouter != null && sapRouter.length() > 0) {
                    StringBuilder gwhost_buf = new StringBuilder(sapRouter.length() + gwhost.length() + 3);
                    gwhost_buf.append(sapRouter);
                    if (!sapRouter.endsWith("/H/")) {
                        gwhost_buf.append("/H/");
                    }
                    gwhost_buf.append(gwhost);
                    gwhost = gwhost_buf.toString();
                }
                this.act_cntl.target = new StringBuilder(target.length() + 3).append(target).append('/').append(sysnr).toString();
                this.act_cntl.sysid = options.getR3name();
                break;
            }
            case 'E': {
                proto = "E";
                lu = options.getReg_host();
                if (lu == null) {
                    lu = "";
                }
                if ((tp = options.getReg_name()) == null) {
                    tp = "";
                }
                if ((gwhost = options.getGwhost()) == null) {
                    gwhost = "";
                }
                target = gwhost;
                if (sapRouter != null && sapRouter.length() > 0) {
                    StringBuilder gwhost_buf = new StringBuilder(sapRouter.length() + gwhost.length() + 3);
                    gwhost_buf.append(sapRouter);
                    if (!sapRouter.endsWith("/H/")) {
                        gwhost_buf.append("/H/");
                    }
                    gwhost_buf.append(gwhost);
                    gwhost = gwhost_buf.toString();
                }
                if ((gwserv = options.getGwserv()) == null) {
                    sysnr = options.getSysnr();
                    gwserv = sysnr == null ? "" : (options.useSymbolicService() ? (sncMode == 0 ? new StringBuilder(7).append("sapgw").append(sysnr).toString() : new StringBuilder(8).append("sapgw").append(sysnr).append('s').toString()) : (sncMode == 0 ? new StringBuilder(4).append("33").append(sysnr).toString() : new StringBuilder(4).append("48").append(sysnr).toString()));
                }
                this.act_cntl.target = new StringBuilder(target.length() + 5).append(target).append('/').append(gwserv).toString();
                this.act_cntl.sysid = "<extern>";
                break;
            }
            case 'R': {
                proto = "R";
                lu = "";
                tp = options.getReg_name();
                if (tp == null) {
                    tp = "";
                }
                if ((gwhost = options.getGwhost()) == null) {
                    gwhost = "";
                }
                target = gwhost;
                if (sapRouter != null && sapRouter.length() > 0) {
                    StringBuilder gwhost_buf = new StringBuilder(sapRouter.length() + gwhost.length() + 3);
                    gwhost_buf.append(sapRouter);
                    if (!sapRouter.endsWith("/H/")) {
                        gwhost_buf.append("/H/");
                    }
                    gwhost_buf.append(gwhost);
                    gwhost = gwhost_buf.toString();
                }
                if ((gwserv = options.getGwserv()) == null) {
                    sysnr = options.getSysnr();
                    gwserv = sysnr == null ? "" : (options.useSymbolicService() ? (sncMode == 0 ? new StringBuilder(7).append("sapgw").append(sysnr).toString() : new StringBuilder(8).append("sapgw").append(sysnr).append('s').toString()) : (sncMode == 0 ? new StringBuilder(4).append("33").append(sysnr).toString() : new StringBuilder(4).append("48").append(sysnr).toString()));
                }
                this.act_cntl.target = new StringBuilder(target.length() + 5).append(target).append('/').append(gwserv).toString();
                this.act_cntl.sysid = "<extern>";
                break;
            }
            default: {
                assert (false) : "ConnectionType '" + options.getType() + "' invalid";
                break;
            }
        }
        this.act_cntl.useDeltaManagement = RfcApi.isDeltaManagementActive() && options.isDeltaManagementOn();
        JCoRuntime rt = JCoRuntimeFactory.getRuntime();
        boolean isTaskMonitorOn = rt.isTaskMonitorOn();
        if (isTaskMonitorOn) {
            StringBuilder msg = new StringBuilder(this.act_cntl.target.length() + 41).append("JCo executing connect [").append(this.act_cntl.sysid).append('|').append(this.act_cntl.target).append("|<empty>]");
            rt.startTask(msg.toString());
        }
        rc = this.SAP_CMINIT3(options.getDestination(), lu, tp, gwhost, gwserv, proto, options.getCpicTrace(), sncMode, options.getSnc_qop(), options.getSnc_myname(), sncPartnerName, options.getSnc_lib(), rc);
        if (isTaskMonitorOn) {
            rt.endTask();
        }
        if (rc != 0) {
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("cox_cpic_init :: Error : " + Integer.toString(rc));
            }
            this.setMessage(this.getErrorInfo("Connect to SAP gateway failed", options));
            return 1;
        }
        if (lu.length() > 0 && (rc = this.CMSPLN(lu)) != 0) {
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("cox_cpic_init :: Error : " + Integer.toString(rc));
            }
            this.setMessage("Cannot set R/3 or external hostname");
            return 1;
        }
        return 0;
    }

    private String getErrorInfo(String message, RfcOptions options) {
        StringBuilder buffer = new StringBuilder(512);
        String cpicMessage = RfcTypeDirectCpic.SAP_CMPERR();
        buffer.append(message);
        buffer.append("\nConnection parameters: ").append(options.toString(true)).append('\n');
        buffer.append(cpicMessage == null || cpicMessage.length() == 0 ? "No specific error info available" : cpicMessage);
        return buffer.toString();
    }
}

