/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.tools.monitor;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.LogController;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class ConfigurationMonitor {
    public static void listConfiguration(PrintWriter out) {
        ConfigurationMonitor.writeHereDoc(out, "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\">\n<html>\n<head><title>Logging Configuration</title>\n<style type=\"text/css\"><!--\n body.lc {\n   font:10pt Verdana,sans-serif;\n }\n table.lc {\n   border:0pt; background-color:whitesmoke; border-collapse:collapse; width:100%\n }\n h2.lc {\n   font-size:14pt; background-color:burlywood\n }\n tr.lcHeader {\n   font-weight:bold;\n }\n tr.lcBody {\n }\n tr.lcSep {\n   font-size:4pt;\n }\n td {\n   vertical-align:text-top; text-align:left; padding-top:1pt; padding-bottom:1pt\n }\n td.lcSep1 {\n   padding:6pt;\n }\n td.lcSep2 {\n   padding:0pt;\n }\n td.catHeader1 {\n   font-size:12pt; background-color:khaki\n }\n td.locHeader1 {\n   font-size:12pt; background-color:mediumturquoise\n }\n td.sumHeader1 {\n   font-size:12pt; background-color:lightsalmon\n }\n td.catHeader2 {\n   font-size:9pt; color:maroon; background-color:lemonchiffon\n }\n td.locHeader2 {\n   font-size:9pt; color:maroon; background-color:paleturquoise\n }\n td.lcHeader3 {\n   font-size:8pt; padding-left:3ex;\n }\n td.lcSeverity {\n   font-size:8pt; font-weight:bold; color:maroon; width:33%; padding-left:3ex;\n }\n td.lcEntry {\n   font-size:8pt; padding-left:6ex;\n }\n--></style>\n</head>\n<body class=lc>\n<h2 class=lc>Logging Configuration</h2>\n<table class=lc cellpadding=0 cellspacing=1>\n");
        try {
            HashMap logRegistry = new HashMap();
            ConfigurationMonitor.writeHereDoc(out, " <tr class=lcHeader>\n  <td class=catHeader1 colspan=3><a name=\"cat\">Categories</a></td>\n </tr>\n <tr class=lcSep><td class=lcSep2>&nbsp;</td></tr>\n");
            int countCategory = ConfigurationMonitor.listLogControllers(out, Category.getCategory("/"), logRegistry);
            ConfigurationMonitor.writeHereDoc(out, " <tr class=lcSep><td class=lcSep1>&nbsp;</td></tr>\n <tr class=lcHeader>\n  <td class=locHeader1 colspan=3><a name=\"loc\">Locations</a></td>\n </tr>\n <tr class=lcSep><td class=lcSep2>&nbsp;</td></tr>\n");
            int countLocation = ConfigurationMonitor.listLogControllers(out, Location.getLocation(""), logRegistry);
            ConfigurationMonitor.writeHereDoc(out, " <tr class=lcSep><td class=lcSep1>&nbsp;</td></tr>\n <tr class=lcHeader>\n  <td class=sumHeader1 colspan=3>Totals</td>\n </tr>\n <tr class=lcHeader>\n  <td class=lcHeader3 colspan=3><a href=\"#cat\">Categories(");
            out.print(Integer.toString(countCategory));
            out.println(")</a></td></tr>");
            out.println(" <tr class=lcHeader>");
            out.print("  <td class=lcHeader3 colspan=3><a href=\"#loc\">Locations(");
            out.print(Integer.toString(countLocation));
            out.println(")</a></td></tr>");
            out.println(" <tr class=lcHeader>");
            out.print("  <td class=lcHeader3 colspan=3><a href=\"#loc\">Logs(");
            out.print(Integer.toString(logRegistry.size()));
            out.println(")</a></td></tr>");
            for (Map.Entry entry : logRegistry.entrySet()) {
                int count = (Integer)entry.getValue();
                out.println(" <tr class=lcBody>");
                out.print("  <td class=lcEntry colspan=3>");
                if (1 != count) {
                    out.print("<b>");
                }
                ConfigurationMonitor.writeName(out, (String)entry.getKey(), false);
                out.print(" (");
                out.print(count);
                out.println(1 == count ? ")</td></tr>" : ")</b></td></tr>");
            }
        }
        catch (Exception ex) {
            ConfigurationMonitor.listException(out, ex);
        }
        out.println("</table>");
        out.println("</body></html>");
        out.flush();
    }

    private static int listLogControllers(PrintWriter out, LogController root, HashMap registry) {
        int lcCount = 1;
        try {
            int i;
            out.println(" <tr class=lcHeader>");
            out.print(root instanceof Category ? "  <td class=cat" : "  <td class=loc");
            out.print("Header2 colspan=3>");
            ConfigurationMonitor.writeName(out, root.getName().equals("") ? "ROOT" : root.getName(), true);
            out.println("</td></tr>");
            out.println(" <tr class=lcHeader>");
            out.print("  <td class=lcSeverity>Effective severity: ");
            out.print(ConfigurationMonitor.convertSeverity(root.getEffectiveSeverity()));
            out.println("</td>");
            out.print("  <td class=lcSeverity>Minimum severity: ");
            out.print(ConfigurationMonitor.convertSeverity(root.getMinimumSeverity()));
            out.println("</td>");
            out.print("  <td class=lcSeverity>Maximum severity: ");
            out.print(ConfigurationMonitor.convertSeverity(root.getMaximumSeverity()));
            out.println("</td></tr>");
            Object[] children = root.getChildren().toArray();
            if (children != null && 0 != children.length) {
                out.println(" <tr class=lcHeader>");
                out.print("  <td class=lcHeader3 colspan=3>Children (");
                out.print(Integer.toString(children.length));
                out.println(")</td></tr>");
                for (i = 0; i < children.length; ++i) {
                    out.println(" <tr class=lcBody>");
                    out.print("  <td class=lcEntry colspan=3>");
                    ConfigurationMonitor.writeName(out, ((LogController)children[i]).getName(), false);
                    out.println("</td></tr>");
                }
            }
            ConfigurationMonitor.listRelatives(out, root);
            ConfigurationMonitor.listLogs(out, root, registry);
            for (i = 0; i < children.length; ++i) {
                lcCount += ConfigurationMonitor.listLogControllers(out, (LogController)children[i], registry);
            }
        }
        catch (Exception ex) {
            ConfigurationMonitor.listException(out, ex);
        }
        return lcCount;
    }

    private static void listRelatives(PrintWriter out, LogController controller) {
        try {
            LogController[] lcList = controller.getRelatives();
            if (lcList != null && 0 != lcList.length) {
                out.println(" <tr class=lcHeader>");
                out.print("  <td class=lcHeader3 colspan=3>Relatives (");
                out.print(Integer.toString(lcList.length));
                out.println(")</td></tr>");
                for (int i = 0; i < lcList.length; ++i) {
                    out.println(" <tr class=lcBody>");
                    out.print("  <td class=lcEntry colspan=3>");
                    ConfigurationMonitor.writeName(out, lcList[i].getName(), false);
                    out.println("</td></tr>");
                }
            }
        }
        catch (Exception ex) {
            ConfigurationMonitor.listException(out, ex);
        }
    }

    private static void listLogs(PrintWriter out, LogController controller, HashMap registry) {
        try {
            Object[] logList = controller.getAllLogs().toArray();
            if (logList != null && 0 != logList.length) {
                out.println(" <tr class=lcHeader>");
                out.print("  <td class=lcHeader3 colspan=3>Logs (");
                out.print(Integer.toString(logList.length));
                out.println(")</td></tr>");
                for (int i = 0; i < logList.length; ++i) {
                    String logName = ((Log)logList[i]).getName();
                    out.println(" <tr class=lcBody>");
                    out.print("  <td class=lcEntry colspan=3>");
                    ConfigurationMonitor.writeName(out, logName, true);
                    out.println("</td></tr>");
                    Integer count = (Integer)registry.get(logName);
                    registry.put(logName, new Integer(null == count ? 1 : count + 1));
                }
            }
        }
        catch (Exception ex) {
            ConfigurationMonitor.listException(out, ex);
        }
    }

    private static void listException(PrintWriter out, Throwable ex) {
        out.println(" <tr class=lcBody>");
        out.println("  <td class=lcEntry style=\"font-weight:bold;color:red;\">Error:");
        out.println(ex.getMessage());
        out.println("  </td><td class=lcEntry colspan=2>");
        ex.printStackTrace(out);
        out.println("  </td></tr>");
    }

    private static String convertSeverity(int sev) {
        String sevTxt;
        switch (sev) {
            case 0: {
                sevTxt = "ALL";
                break;
            }
            case 701: {
                sevTxt = "NONE";
                break;
            }
            case 800: {
                sevTxt = "GROUP";
                break;
            }
            case 100: {
                sevTxt = "DEBUG";
                break;
            }
            case 500: {
                sevTxt = "ERROR";
                break;
            }
            case 600: {
                sevTxt = "FATAL";
                break;
            }
            case 300: {
                sevTxt = "INFO";
                break;
            }
            case 200: {
                sevTxt = "PATH";
                break;
            }
            case 400: {
                sevTxt = "WARNING";
                break;
            }
            default: {
                sevTxt = "UNKNOWN(" + sev + ")";
            }
        }
        return sevTxt;
    }

    private static void writeName(PrintWriter out, String name, boolean isAnchor) {
        out.print(isAnchor ? "<a name=\"" : "<a href=\"#");
        if (null == name) {
            out.print("\"><i>&laquo;null&raquo;</i></a>");
        } else {
            char[] txt = name.toCharArray();
            for (int i = 0; i < txt.length; ++i) {
                char ch = txt[i];
                if (!('a' <= ch && 'z' >= ch || 'A' <= ch && 'Z' >= ch) && ('0' > ch || '9' < ch)) continue;
                out.print(txt[i]);
            }
            out.print("\">");
            out.print(name);
            out.print("</a>");
        }
    }

    private static void writeHereDoc(PrintWriter out, String doc) {
        int fromIdx = 0;
        while (true) {
            int pos;
            if (fromIdx == (pos = doc.indexOf(10, fromIdx))) {
                out.println();
            } else if (0 <= pos) {
                out.println(doc.substring(fromIdx, pos));
            } else {
                if (fromIdx >= doc.length()) break;
                out.print(doc.substring(fromIdx));
                break;
            }
            fromIdx = pos + 1;
        }
    }
}

