/*
 * Decompiled with CFR 0.152.
 */
package com.github.easonjim;

import com.github.easonjim.OsUtils;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class JcoProvisioner {
    private static final Logger logger = Logger.getLogger(JcoProvisioner.class.getName());
    public static final String LIB_DIR = "native";
    public static final String ENVIRONMENT_VARIABLE_TARGET = "SAP_JCO_TARGET_FOLDER";
    public static final String SYSTEM_PROPERTY_TARGET = "sap.jco.target.folder";
    public static final String DEFAULT_LOCATION_TARGET = System.getProperty("user.dir") + File.separator + "native";
    public static final String JCO_NATIVE_SYSTEM_PROPERTY = "java.library.path";
    public static final Map<String, String> JCO_NATIVE_LIBRARY_NAMES = new HashMap<String, String>(3){
        {
            this.put("windows", "sapjco3.dll");
            this.put("linux", "libsapjco3.so");
            this.put("mac", "libsapjco3.jnilib");
        }
    };
    static final int EOF = -1;
    static final int SIZE = 65536;

    public static String discoverLocation(String options) {
        String variable;
        if (options != null) {
            String[] optionArray;
            for (String option : optionArray = options.split(",")) {
                if (!option.startsWith(SYSTEM_PROPERTY_TARGET) || !option.contains("=")) continue;
                logger.info("Using location provided by options. for target.");
                return option.substring(option.indexOf("=") + 1);
            }
        }
        if ((variable = System.getenv(ENVIRONMENT_VARIABLE_TARGET)) != null) {
            logger.info("Using location provided by environment variable. for target. path:" + variable);
            return variable;
        }
        String property = System.getProperty(SYSTEM_PROPERTY_TARGET);
        if (property != null) {
            logger.info("Using location provided by system property. for target. path:" + property);
            return property;
        }
        logger.info("Using location provided by hard coded value. for target. path:" + DEFAULT_LOCATION_TARGET);
        return DEFAULT_LOCATION_TARGET;
    }

    public static synchronized boolean isNativeLoaded() {
        try {
            return JcoProvisioner.isJcoAlreadyLoaded();
        }
        catch (Throwable e) {
            try {
                return JcoProvisioner.isJcoAlreadyLoaded();
            }
            catch (Throwable ex) {
                logger.info("Jco Runtime load error:" + ex.getMessage());
                return false;
            }
        }
    }

    public static void provision() throws Exception {
        JcoProvisioner.provision(new File(JcoProvisioner.discoverLocation(null)));
    }

    public static synchronized void provision(File targetFolder) throws Exception {
        if (!targetFolder.exists()) {
            targetFolder.mkdirs();
        }
        String libraryName = JCO_NATIVE_LIBRARY_NAMES.get(OsUtils.getOsShotName());
        String sourcePath = "/native/" + libraryName;
        File targetPath = new File(targetFolder, libraryName).getAbsoluteFile();
        InputStream sourceStream = JcoProvisioner.class.getResourceAsStream(sourcePath);
        FileOutputStream targetStream = new FileOutputStream(targetPath);
        JcoProvisioner.transfer(sourceStream, targetStream);
        sourceStream.close();
        ((OutputStream)targetStream).close();
        String libraryPath = targetPath.getAbsolutePath().replace(libraryName, "");
        String jcoSystemNativePath = System.getProperty(JCO_NATIVE_SYSTEM_PROPERTY);
        jcoSystemNativePath = OsUtils.isWindows() ? jcoSystemNativePath + ";" + libraryPath : jcoSystemNativePath + ":" + libraryPath;
        System.setProperty(JCO_NATIVE_SYSTEM_PROPERTY, jcoSystemNativePath);
        logger.info("Jco system native path: " + System.getProperty(JCO_NATIVE_SYSTEM_PROPERTY));
        if (JcoProvisioner.isNativeLoaded()) {
            logger.info("Jco library is already provisioned.");
        }
    }

    public static void transfer(InputStream input, OutputStream output) throws Exception {
        int count;
        byte[] data = new byte[65536];
        while ((count = input.read(data, 0, 65536)) != -1) {
            output.write(data, 0, count);
        }
    }

    private static boolean isJcoAlreadyLoaded() throws Exception {
        JCoRuntime runtime = JCoRuntimeFactory.getRuntime();
        return runtime != null;
    }
}

