/*
 * Decompiled with CFR 0.152.
 */
package com.ehsaniara.s3;

import com.ehsaniara.s3.ListenerContainer;
import com.ehsaniara.s3.ListenerContainerImpl;
import com.ehsaniara.s3.SessionListenerContainer;
import com.ehsaniara.s3.SessionListenerContainerImpl;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.proxy.ProxyInfoProvider;
import org.apache.maven.wagon.repository.Repository;

public abstract class AbstractStorageWagon
implements Wagon {
    private static final boolean SUPPORTS_DIRECTORY_COPY = true;
    private int connectionTimeOut = 0;
    private int readConnectionTimeOut = 0;
    protected Repository repository = null;
    protected final SessionListenerContainer sessionListenerContainer = new SessionListenerContainerImpl(this);
    protected final ListenerContainer listenerContainer = new ListenerContainerImpl(this);
    private boolean interactive;

    public boolean supportsDirectoryCopy() {
        return true;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void openConnection() {
        throw new UnsupportedOperationException();
    }

    public void connect(Repository repository) throws ConnectionException, AuthenticationException {
        this.connect(repository, null, null);
    }

    public void connect(Repository repository, ProxyInfo proxyInfo) throws ConnectionException, AuthenticationException {
        this.connect(repository, null, proxyInfo);
    }

    public void connect(Repository repository, ProxyInfoProvider proxyInfoProvider) throws ConnectionException, AuthenticationException {
        this.connect(repository, null, proxyInfoProvider);
    }

    public void connect(Repository repository, AuthenticationInfo authenticationInfo) throws ConnectionException, AuthenticationException {
        this.connect(repository, authenticationInfo, null);
    }

    public void connect(Repository repository, AuthenticationInfo authenticationInfo, ProxyInfo proxyInfo) throws ConnectionException, AuthenticationException {
        this.connect(repository, authenticationInfo, p -> {
            if (p == null || proxyInfo == null || p.equalsIgnoreCase(proxyInfo.getType())) {
                return proxyInfo;
            }
            return null;
        });
    }

    public void setTimeout(int i) {
        this.connectionTimeOut = i;
    }

    public int getTimeout() {
        return this.connectionTimeOut;
    }

    public void setReadTimeout(int i) {
        this.readConnectionTimeOut = i;
    }

    public int getReadTimeout() {
        return this.readConnectionTimeOut;
    }

    public void addSessionListener(SessionListener sessionListener) {
        this.sessionListenerContainer.addSessionListener(sessionListener);
    }

    public void removeSessionListener(SessionListener sessionListener) {
        this.sessionListenerContainer.removeSessionListener(sessionListener);
    }

    public boolean hasSessionListener(SessionListener sessionListener) {
        return this.sessionListenerContainer.hasSessionListener(sessionListener);
    }

    public void addTransferListener(TransferListener transferListener) {
        this.listenerContainer.addTransferListener(transferListener);
    }

    public void removeTransferListener(TransferListener transferListener) {
        this.listenerContainer.removeTransferListener(transferListener);
    }

    public boolean hasTransferListener(TransferListener transferListener) {
        return this.listenerContainer.hasTransferListener(transferListener);
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean b) {
        this.interactive = b;
    }
}

