/*
 * Decompiled with CFR 0.152.
 */
package com.ehsaniara.s3;

import com.ehsaniara.s3.ListenerContainer;
import java.io.File;
import java.util.Vector;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.resource.Resource;

public class ListenerContainerImpl
implements ListenerContainer {
    private final Wagon wagon;
    private final Vector<TransferListener> transferListeners;

    public ListenerContainerImpl(Wagon wagon) {
        this.wagon = wagon;
        this.transferListeners = new Vector();
    }

    @Override
    public void addTransferListener(TransferListener transferListener) {
        if (transferListener == null) {
            throw new NullPointerException();
        }
        if (!this.transferListeners.contains(transferListener)) {
            this.transferListeners.add(transferListener);
        }
    }

    @Override
    public void removeTransferListener(TransferListener transferListener) {
        this.transferListeners.remove(transferListener);
    }

    @Override
    public boolean hasTransferListener(TransferListener transferListener) {
        return this.transferListeners.contains(transferListener);
    }

    @Override
    public void fireTransferInitiated(Resource resource, int requestType) {
        TransferEvent transferEvent = new TransferEvent(this.wagon, resource, 0, requestType);
        this.transferListeners.forEach(tl -> tl.transferInitiated(transferEvent));
    }

    @Override
    public void fireTransferStarted(Resource resource, int requestType, File localFile) {
        resource.setContentLength(localFile.length());
        resource.setLastModified(localFile.lastModified());
        TransferEvent transferEvent = new TransferEvent(this.wagon, resource, 1, requestType);
        transferEvent.setLocalFile(localFile);
        this.transferListeners.forEach(tl -> tl.transferStarted(transferEvent));
    }

    @Override
    public void fireTransferProgress(Resource resource, int requestType, byte[] buffer, int length) {
        TransferEvent transferEvent = new TransferEvent(this.wagon, resource, 3, requestType);
        this.transferListeners.forEach(tl -> tl.transferProgress(transferEvent, buffer, length));
    }

    @Override
    public void fireTransferCompleted(Resource resource, int requestType) {
        TransferEvent transferEvent = new TransferEvent(this.wagon, resource, 2, requestType);
        this.transferListeners.forEach(tl -> tl.transferCompleted(transferEvent));
    }

    @Override
    public void fireTransferError(Resource resource, int requestType, Exception exception) {
        TransferEvent transferEvent = new TransferEvent(this.wagon, resource, exception, requestType);
        this.transferListeners.forEach(tl -> tl.transferError(transferEvent));
    }
}

