/*
 * Decompiled with CFR 0.152.
 */
package com.ehsaniara.s3;

import com.ehsaniara.s3.Progress;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public final class ProgressFileInputStream
extends FileInputStream {
    private final Progress progress;
    private long byteLeft;

    public ProgressFileInputStream(File file, Progress progress) throws IOException {
        super(file);
        this.progress = progress;
        this.resetByteLeft();
    }

    private void resetByteLeft() throws IOException {
        this.byteLeft = this.getChannel().size();
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        this.resetByteLeft();
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        if (b != -1) {
            this.progress.progress(new byte[]{(byte)b}, 1);
            --this.byteLeft;
        }
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int count = super.read(b);
        if (count != -1) {
            this.progress.progress(b, b.length);
            this.byteLeft -= (long)b.length;
        } else {
            this.progress.progress(b, Math.toIntExact(this.byteLeft));
        }
        return count;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int count = super.read(b, off, len);
        if (off == 0) {
            if (count != -1) {
                this.progress.progress(b, count);
                this.byteLeft -= (long)count;
            } else {
                this.progress.progress(b, Math.toIntExact(this.byteLeft));
            }
        } else if (count != -1) {
            byte[] bytes = new byte[count];
            System.arraycopy(b, off, bytes, 0, count);
            this.progress.progress(bytes, len);
            this.byteLeft -= (long)count;
        } else {
            byte[] bytes = new byte[Math.toIntExact(this.byteLeft)];
            System.arraycopy(b, off, bytes, 0, Math.toIntExact(this.byteLeft));
            this.progress.progress(b, Math.toIntExact(this.byteLeft));
        }
        return count;
    }
}

