/*
 * Decompiled with CFR 0.152.
 */
package com.ehsaniara.s3;

import com.amazonaws.SdkClientException;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.ehsaniara.s3.AwsCredentialsFactory;
import com.ehsaniara.s3.EndpointProperty;
import com.ehsaniara.s3.PathStyleEnabledProperty;
import com.ehsaniara.s3.S3RegionProviderOrder;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;

public class S3Connect {
    private static final Logger log = Logger.getLogger(S3Connect.class.getName());

    public static AmazonS3 connect(AuthenticationInfo authenticationInfo, String region, EndpointProperty endpoint, PathStyleEnabledProperty pathStyle) throws AuthenticationException {
        AmazonS3ClientBuilder builder = null;
        try {
            builder = S3Connect.createAmazonS3ClientBuilder(authenticationInfo, region, endpoint, pathStyle);
            AmazonS3 amazonS3 = (AmazonS3)builder.build();
            log.finer(String.format("Connected to S3 using bucket %s.", endpoint.get()));
            return amazonS3;
        }
        catch (SdkClientException e) {
            if (Objects.nonNull(builder)) {
                StringBuilder errorMessage = new StringBuilder();
                errorMessage.append("Failed to connect");
                if (Objects.nonNull(builder.getEndpoint())) {
                    errorMessage.append(String.format(" to endpoint [%s] using region [%s]", builder.getEndpoint().getServiceEndpoint(), builder.getEndpoint().getSigningRegion()));
                } else {
                    errorMessage.append(String.format(" using region [%s]", builder.getRegion()));
                }
                throw new AuthenticationException(errorMessage.toString(), (Throwable)e);
            }
            throw new AuthenticationException("Could not authenticate", (Throwable)e);
        }
    }

    private static AmazonS3ClientBuilder createAmazonS3ClientBuilder(AuthenticationInfo authenticationInfo, String region, EndpointProperty endpoint, PathStyleEnabledProperty pathStyle) {
        S3RegionProviderOrder regionProvider = new S3RegionProviderOrder(region);
        AmazonS3ClientBuilder builder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials(new AwsCredentialsFactory().connect(authenticationInfo));
        if (endpoint.isPresent()) {
            builder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint.get(), builder.getRegion()));
        } else {
            builder.setRegion(regionProvider.getRegion());
        }
        builder.setPathStyleAccessEnabled(Boolean.valueOf(pathStyle.get()));
        return builder;
    }
}

