/*
 * Decompiled with CFR 0.152.
 */
package com.ehsaniara.s3;

import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.ehsaniara.s3.AbstractStorageWagon;
import com.ehsaniara.s3.EndpointProperty;
import com.ehsaniara.s3.KeyResolver;
import com.ehsaniara.s3.PathStyleEnabledProperty;
import com.ehsaniara.s3.ProgressImpl;
import com.ehsaniara.s3.PublicReadProperty;
import com.ehsaniara.s3.S3StorageRepo;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.proxy.ProxyInfoProvider;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.resource.Resource;

public class S3StorageWagon
extends AbstractStorageWagon {
    private static final Logger log = Logger.getLogger(S3StorageWagon.class.getName());
    private S3StorageRepo s3StorageRepo;
    private final KeyResolver keyResolver = new KeyResolver();
    private String region;
    private Boolean publicRepository;
    private String endpoint;
    private String pathStyleEnabled;

    public void get(String resourceName, File file) throws TransferFailedException, ResourceDoesNotExistException {
        Resource resource = new Resource(resourceName);
        this.listenerContainer.fireTransferInitiated(resource, 5);
        this.listenerContainer.fireTransferStarted(resource, 5, file);
        ProgressImpl progress = new ProgressImpl(resource, 5, this.listenerContainer);
        try {
            this.s3StorageRepo.copy(resourceName, file, progress);
            this.listenerContainer.fireTransferCompleted(resource, 5);
        }
        catch (Exception e) {
            this.listenerContainer.fireTransferError(resource, 5, e);
            throw e;
        }
    }

    public List<String> getFileList(String s) throws TransferFailedException, ResourceDoesNotExistException {
        try {
            List<String> list = this.s3StorageRepo.list(s);
            list = this.convertS3ListToMavenFileList(list, s);
            if (list.isEmpty()) {
                throw new ResourceDoesNotExistException(s);
            }
            return list;
        }
        catch (AmazonS3Exception e) {
            throw new TransferFailedException("Could not fetch objects with prefix: " + s);
        }
    }

    public void put(File file, String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(resourceName);
        log.log(Level.FINER, String.format("Uploading file %s to %s", file.getAbsolutePath(), resourceName));
        this.listenerContainer.fireTransferInitiated(resource, 6);
        this.listenerContainer.fireTransferStarted(resource, 6, file);
        ProgressImpl progress = new ProgressImpl(resource, 6, this.listenerContainer);
        try {
            this.s3StorageRepo.put(file, resourceName, progress);
            this.listenerContainer.fireTransferCompleted(resource, 6);
        }
        catch (TransferFailedException e) {
            this.listenerContainer.fireTransferError(resource, 6, (Exception)((Object)e));
            throw e;
        }
    }

    public boolean getIfNewer(String resourceName, File file, long timeStamp) throws TransferFailedException, ResourceDoesNotExistException {
        if (this.s3StorageRepo.newResourceAvailable(resourceName, timeStamp)) {
            this.get(resourceName, file);
            return true;
        }
        return false;
    }

    public void putDirectory(File source, String destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Collection allFiles = FileUtils.listFiles((File)source, null, (boolean)true);
        String relativeDestination = destination;
        if (destination != null && destination.startsWith(".")) {
            relativeDestination = destination.length() == 1 ? "" : destination.substring(1);
        }
        for (File file : allFiles) {
            String relativePath = PathUtils.toRelative((File)source, (String)file.getAbsolutePath());
            this.put(file, relativeDestination + "/" + relativePath);
        }
    }

    public boolean resourceExists(String resourceName) {
        return this.s3StorageRepo.exists(resourceName);
    }

    private List<String> convertS3ListToMavenFileList(List<String> list, String path) {
        String prefix = this.keyResolver.resolve(this.s3StorageRepo.getBaseDirectory(), path);
        HashSet folders = new HashSet();
        List<String> result = list.stream().map(key -> {
            String filePath = key;
            if (prefix != null && prefix.length() > 0) {
                filePath = key.substring(prefix.length() + 1);
            }
            this.extractFolders(folders, filePath);
            return filePath;
        }).collect(Collectors.toList());
        result.addAll(folders);
        return result;
    }

    private void extractFolders(Set<String> folders, String filePath) {
        if (filePath.contains("/")) {
            String folder = filePath.substring(0, filePath.lastIndexOf(47));
            folders.add(folder + '/');
            if (folder.contains("/")) {
                this.extractFolders(folders, folder);
            }
        } else {
            folders.add(filePath);
        }
    }

    public void connect(Repository repository, AuthenticationInfo authenticationInfo, ProxyInfoProvider proxyInfoProvider) throws AuthenticationException {
        this.repository = repository;
        this.sessionListenerContainer.fireSessionOpening();
        String bucket = repository.getHost();
        StringBuilder stringBuilder = new StringBuilder(repository.getBasedir()).deleteCharAt(0);
        if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) != '/') {
            stringBuilder.append('/');
        }
        String directory = stringBuilder.toString();
        log.log(Level.FINER, String.format("Opening connection for bucket %s and directory %s", bucket, directory));
        this.s3StorageRepo = new S3StorageRepo(bucket, directory, new PublicReadProperty(this.publicRepository));
        this.s3StorageRepo.connect(authenticationInfo, this.region, new EndpointProperty(this.endpoint), new PathStyleEnabledProperty(this.pathStyleEnabled));
        this.sessionListenerContainer.fireSessionLoggedIn();
        this.sessionListenerContainer.fireSessionOpened();
    }

    public void disconnect() {
        this.sessionListenerContainer.fireSessionDisconnecting();
        this.s3StorageRepo.disconnect();
        this.sessionListenerContainer.fireSessionLoggedOff();
        this.sessionListenerContainer.fireSessionDisconnected();
    }

    public void setS3StorageRepo(S3StorageRepo s3StorageRepo) {
        this.s3StorageRepo = s3StorageRepo;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setPublicRepository(Boolean publicRepository) {
        this.publicRepository = publicRepository;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setPathStyleEnabled(String pathStyleEnabled) {
        this.pathStyleEnabled = pathStyleEnabled;
    }

    public S3StorageRepo getS3StorageRepo() {
        return this.s3StorageRepo;
    }

    public KeyResolver getKeyResolver() {
        return this.keyResolver;
    }

    public String getRegion() {
        return this.region;
    }

    public Boolean getPublicRepository() {
        return this.publicRepository;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getPathStyleEnabled() {
        return this.pathStyleEnabled;
    }
}

