/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.mojo;

import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.TaskRunnerException;
import com.github.eirslett.maven.plugins.frontend.mojo.AbstractFrontendMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.LoggerFactory;

@Mojo(name="karma", defaultPhase=LifecyclePhase.TEST)
public final class KarmaRunMojo
extends AbstractFrontendMojo {
    @Parameter(defaultValue="karma.conf.js", property="karmaConfPath")
    private String karmaConfPath;
    @Parameter(property="skipTests", required=false, defaultValue="false")
    private Boolean skipTests;
    @Parameter(property="testFailureIgnore", required=false, defaultValue="false")
    private Boolean testFailureIgnore;
    @Parameter(property="skip.karma", defaultValue="false")
    private Boolean skip;

    @Override
    protected boolean isSkipped() {
        return this.skip;
    }

    @Override
    public void execute(FrontendPluginFactory factory) throws TaskRunnerException {
        try {
            if (this.skipTests.booleanValue()) {
                LoggerFactory.getLogger(KarmaRunMojo.class).info("Skipping karma tests.");
            } else {
                factory.getKarmaRunner().execute("start " + this.karmaConfPath);
            }
        }
        catch (TaskRunnerException e) {
            if (this.testFailureIgnore.booleanValue()) {
                LoggerFactory.getLogger(KarmaRunMojo.class).warn("There are ignored test failures/errors for: " + this.workingDirectory);
            }
            throw e;
        }
    }
}

