package com.github.eirslett.maven.plugins.frontend;

enum OS { Windows, Mac, Linux, SunOS;
    public static OS guess() {
        final String osName = System.getProperty("os.name");
        return  osName.contains("Windows") ? OS.Windows :
                osName.contains("Mac") ? OS.Mac :
                        osName.contains("SunOS") ? OS.SunOS :
                                OS.Linux;
    }

    public static boolean isWindows(){
        return guess() == OS.Windows;
    }
}
