/*
 * Decompiled with CFR 0.152.
 */
package echo.util;

import echo.exception.FailureException;
import echo.output.PluginLog;
import echo.parameter.PluginParameters;
import echo.util.FindFileInAbsolutePath;
import echo.util.FindFileInClassPath;
import echo.util.UrlWrapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class FileUtil {
    private final PluginLog mavenPluginLog;
    private final String encoding;
    private final String fromFile;
    private final File basePath;
    private final String toFile;
    private final boolean appendToFile;
    private final boolean forceOverwrite;

    public FileUtil(PluginParameters parameters, PluginLog mavenPluginLog) {
        this.mavenPluginLog = mavenPluginLog;
        this.encoding = parameters.getEncoding();
        this.fromFile = parameters.getFromFile();
        this.basePath = parameters.getBasePath();
        this.toFile = parameters.getToFile();
        this.appendToFile = parameters.isAppendToFile();
        this.forceOverwrite = parameters.isForce();
    }

    public void saveToFile(String message) {
        File saveFile = new File(this.basePath, this.toFile);
        String absolutePath = saveFile.getAbsolutePath();
        this.mavenPluginLog.info("Saving output to " + absolutePath);
        try {
            this.checkForNonWritableFile(saveFile);
            this.makeFileWritable(saveFile);
            FileUtils.write((File)saveFile, (CharSequence)message, (String)this.encoding, (boolean)this.appendToFile);
        }
        catch (UnsupportedEncodingException ex) {
            throw new FailureException("Unsupported encoding: " + ex.getMessage(), ex);
        }
        catch (UnsupportedCharsetException ex) {
            throw new FailureException("Unsupported encoding: " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            this.mavenPluginLog.debug(ex);
            throw new FailureException("Could not save file: " + absolutePath, ex);
        }
    }

    private void checkForNonWritableFile(File saveFile) {
        if (saveFile.isDirectory()) {
            throw new FailureException("File " + saveFile.getAbsolutePath() + " exists but is a directory");
        }
    }

    private void makeFileWritable(File saveFile) {
        if (saveFile.isFile() && saveFile.exists() && !saveFile.canWrite()) {
            if (this.forceOverwrite) {
                boolean writableStatus = saveFile.setWritable(true);
                if (!writableStatus) {
                    throw new FailureException("Could not make file writable " + saveFile.getAbsolutePath());
                }
            } else {
                throw new FailureException("Cannot write to read-only file " + saveFile.getAbsolutePath());
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getFromFile() throws IOException {
        String string;
        InputStream inputStream = null;
        try {
            UrlWrapper urlWrapper = new UrlWrapper(this.fromFile);
            inputStream = urlWrapper.isUrl() ? urlWrapper.openStream() : this.getFileFromRelativeOrClassPath(this.basePath, this.fromFile);
            string = IOUtils.toString((InputStream)inputStream, (String)this.encoding);
        }
        catch (UnsupportedEncodingException ex) {
            try {
                throw new FailureException("Unsupported encoding: " + ex.getMessage(), ex);
                catch (UnsupportedCharsetException ex2) {
                    throw new FailureException("Unsupported encoding: " + ex2.getMessage(), ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return string;
    }

    private InputStream getFileFromRelativeOrClassPath(File basePath, String file) throws IOException {
        FindFileInAbsolutePath findFileInAbsolutePath = new FindFileInAbsolutePath(this.mavenPluginLog);
        findFileInAbsolutePath.openFile(new File(file));
        if (findFileInAbsolutePath.isFound()) {
            this.mavenPluginLog.debug("Reading input from " + findFileInAbsolutePath.getAbsoluteFilePath());
            return findFileInAbsolutePath.getInputStream();
        }
        findFileInAbsolutePath.openFile(new File(basePath, file));
        if (findFileInAbsolutePath.isFound()) {
            this.mavenPluginLog.debug("Reading input from " + findFileInAbsolutePath.getAbsoluteFilePath());
            return findFileInAbsolutePath.getInputStream();
        }
        FindFileInClassPath findFileInClassPath = new FindFileInClassPath(this.mavenPluginLog);
        findFileInClassPath.openFile(file);
        if (findFileInClassPath.isFound()) {
            this.mavenPluginLog.debug("Reading input from " + findFileInClassPath.getAbsoluteFilePath());
            return findFileInClassPath.getInputStream();
        }
        throw new FileNotFoundException(String.format("Could not find %s, %s or %s in classpath", new File(file).getAbsolutePath(), new File(basePath, file).getAbsolutePath(), file));
    }
}

