/*
 * Decompiled with CFR 0.152.
 */
package echo;

import echo.parameter.PluginParameters;

class CharacterOutput {
    private final boolean writeOutput;
    private boolean firstCharacter = true;
    private StringBuilder outputStringBuilder;

    public CharacterOutput(PluginParameters pluginParameters) {
        this.writeOutput = pluginParameters.isCharacterOutput();
    }

    public String getOutput(String message) {
        if (!this.writeOutput) {
            return "";
        }
        this.generateOutput(message.toCharArray());
        return this.outputStringBuilder.toString();
    }

    private void generateOutput(char[] messageChars) {
        this.outputStringBuilder = new StringBuilder();
        this.outputStringBuilder.append("[");
        for (char messageChar : messageChars) {
            this.appendOneCharOutput(messageChar);
        }
        this.outputStringBuilder.append("]");
    }

    private void appendOneCharOutput(char messageChar) {
        if (this.firstCharacter) {
            this.firstCharacter = false;
        } else {
            this.outputStringBuilder.append(",");
        }
        this.outputStringBuilder.append("['").append(messageChar).append("' , ").append((int)messageChar).append(" ").append("]");
    }

    public boolean isWriteOutput() {
        return this.writeOutput;
    }
}

