/*
 * Decompiled with CFR 0.152.
 */
package echo.parameter;

import echo.parameter.LineSeparator;
import echo.parameter.OutputLevelType;
import echo.parameter.PluginParameters;
import java.io.File;

public class PluginParametersBuilder {
    private String message;
    private String fromFile;
    private File basePath;
    private String toFile;
    private boolean appendToFile;
    private boolean force;
    private OutputLevelType level = OutputLevelType.INFO;
    private String encoding = "UTF-8";
    private LineSeparator lineSeparator = new LineSeparator("\n");
    private boolean characterOutput;

    public PluginParametersBuilder setMessage(String message, String fromFile) {
        this.message = message;
        this.fromFile = fromFile;
        return this;
    }

    public PluginParametersBuilder setFile(File basePath, String toFile, boolean appendToFile, boolean force) {
        this.basePath = basePath;
        this.toFile = toFile;
        this.appendToFile = appendToFile;
        this.force = force;
        return this;
    }

    public PluginParametersBuilder setLevel(String level) {
        this.level = OutputLevelType.fromString(level);
        return this;
    }

    public PluginParametersBuilder setFormatting(String encoding, String lineSeparatorString) {
        this.encoding = encoding;
        this.lineSeparator = new LineSeparator(lineSeparatorString);
        return this;
    }

    public PluginParametersBuilder setDebug(boolean characterOutput) {
        this.characterOutput = characterOutput;
        return this;
    }

    public PluginParameters createPluginParameters() {
        this.lineSeparator.checkLineSeparator();
        return new PluginParameters(this.message, this.fromFile, this.basePath, this.toFile, this.appendToFile, this.force, this.level, this.encoding, this.lineSeparator, this.characterOutput);
    }
}

