/*
 * Decompiled with CFR 0.152.
 */
package echo.util;

import echo.output.PluginLog;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

class FindFileInClassPath {
    private final PluginLog mavenPluginLog;
    private InputStream inputStream;
    private String absoluteFilePath;

    public FindFileInClassPath(PluginLog mavenPluginLog) {
        this.mavenPluginLog = mavenPluginLog;
    }

    public void openFile(String fileName) {
        try {
            URL resource = this.getClass().getClassLoader().getResource(fileName);
            if (resource != null) {
                this.inputStream = resource.openStream();
                this.absoluteFilePath = resource.getPath();
            }
        }
        catch (IOException iex) {
            this.mavenPluginLog.debug(iex);
        }
    }

    public boolean isFound() {
        return this.inputStream != null;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getAbsoluteFilePath() {
        return this.absoluteFilePath;
    }
}

