/*
 * Decompiled with CFR 0.152.
 */
package echo.parameter;

import echo.exception.FailureException;
import java.util.Arrays;

public class LineSeparator {
    private final String formattedLineSeparator;
    private final String lineSeparatorString;

    LineSeparator(String lineSeparatorString) {
        this.lineSeparatorString = lineSeparatorString;
        this.formattedLineSeparator = lineSeparatorString.replaceAll("\\\\r", "\r").replaceAll("\\\\n", "\n");
    }

    void checkLineSeparator() {
        if (this.isIllegalString()) {
            throw new FailureException("LineSeparator must be either \\n, \\r or \\r\\n, but separator characters were " + Arrays.toString(this.lineSeparatorString.getBytes()));
        }
    }

    private boolean isIllegalString() {
        return !"\n".equalsIgnoreCase(this.formattedLineSeparator) && !"\r".equalsIgnoreCase(this.formattedLineSeparator) && !"\r\n".equalsIgnoreCase(this.formattedLineSeparator);
    }

    public String getFormattedLineSeparator() {
        return this.formattedLineSeparator;
    }
}

