/*
 * Decompiled with CFR 0.152.
 */
package echo.parameter;

import echo.exception.FailureException;
import java.util.Locale;
import java.util.function.Function;

public enum OutputLevelType {
    FAIL(name -> "FAIL".equals(name) || "FATAL".equals(name)),
    ERROR("ERROR"::equals),
    WARNING(name -> "WARNING".equals(name) || "WARN".equals(name)),
    INFO("INFO"::equals),
    DEBUG(name -> "DEBUG".equals(name) || "TRACE".equals(name));

    private final Function<String, Boolean> matchName;
    private static final String ERROR_LEVEL_MSG = "level must be either FAIL, ERROR, WARNING, INFO or DEBUG.";

    private OutputLevelType(Function<String, Boolean> matchName) {
        this.matchName = matchName;
    }

    static OutputLevelType fromString(String level) {
        if (level == null) {
            throw new FailureException("level must be either FAIL, ERROR, WARNING, INFO or DEBUG. Was: null");
        }
        String upperCaseLevel = level.toUpperCase(Locale.getDefault());
        for (OutputLevelType outputLevelType : OutputLevelType.values()) {
            if (!outputLevelType.matchName.apply(upperCaseLevel).booleanValue()) continue;
            return outputLevelType;
        }
        throw new FailureException("level must be either FAIL, ERROR, WARNING, INFO or DEBUG. Was: " + level);
    }
}

