/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.IAdaptable;
import org.xmind.core.IBoundary;
import org.xmind.core.IFileEntry;
import org.xmind.core.IHtmlNotesContent;
import org.xmind.core.IHyperlinkSpan;
import org.xmind.core.IImage;
import org.xmind.core.IImageSpan;
import org.xmind.core.IManifest;
import org.xmind.core.INotes;
import org.xmind.core.INumbering;
import org.xmind.core.IParagraph;
import org.xmind.core.IPlainNotesContent;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ISpanList;
import org.xmind.core.ITextSpan;
import org.xmind.core.ITitled;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.internal.compatibility.FileFormat;
import org.xmind.core.internal.dom.ManifestImpl;
import org.xmind.core.internal.dom.MarkerGroupImpl;
import org.xmind.core.internal.dom.MarkerImpl;
import org.xmind.core.internal.dom.MarkerSheetImpl;
import org.xmind.core.internal.dom.MetaImpl;
import org.xmind.core.internal.dom.NumberUtils;
import org.xmind.core.internal.dom.StyleSheetImpl;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.style.IStyled;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.core.util.IXMLLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileFormat_1
extends FileFormat {
    private static final String VERSION = "1.0";
    private static final String TAG_MAP = "map";
    private static final String TAG_ROOT_TOPIC = "root-topic";
    private static final String TAG_MARKERS = "markers";
    private static final String TAG_ATTACHED_TOPICS = "attached-topics";
    private static final String TAG_DETACHED_TOPICS = "detached-topics";
    private static final String TAG_PLAIN = "plain";
    private static final String TAG_RICH = "rich";
    private static final String ATTR_FOLDED = "folded";
    private static final String ATTR_FLOATING_TYPE = "floating-type";
    private static final String ATTR_INHERITED = "inherited";
    private static final String ATTR_FROM = "from-id";
    private static final String ATTR_TO = "to-id";
    private static final String ATTR_END_INDEX = "end-index";
    private static final String ATTR_START_INDEX = "start-index";
    private static final String ATTR_RAINBOWCOLOR = "rainbowcolor";
    private static final String ATTR_SPINYLINES = "spinylines";
    private static final String ATTR_FROM_POINT = "control-point1";
    private static final String ATTR_TO_POINT = "control-point2";
    private static final String VAL_CENTRAL = "central";
    private static final String VAL_MULTI_LINE_COLORS = "#ac6060 #acac60 #60ac60 #60acac #6060ac #ac60ac";
    private static final String VAL_USER = "User";
    private static final String VAL_ATTACHMENT = "Attachment";
    private Document contentDocument;
    private MarkerSheetImpl markerSheet;
    private String defaultMarkerGroupId;

    public FileFormat_1(IInputSource source, IXMLLoader loader, IStorage storage) {
        super(source, loader, storage);
    }

    @Override
    public boolean identifies() throws CoreException {
        if (this.source.hasEntry("content.xml")) {
            try {
                this.contentDocument = this.loader.loadXMLFile(this.source, "content.xml");
                Element ele = this.contentDocument.getDocumentElement();
                String version = DOMUtils.getAttribute(ele, "version");
                return version == null || VERSION.equals(version);
            }
            catch (CoreException e) {
                if (e.getType() == 17 || e.getType() == 100) {
                    throw e;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public WorkbookImpl load() throws CoreException, IOException {
        WorkbookImpl wb = new WorkbookImpl(this.loader.createDocument());
        if (this.storage != null) {
            wb.setTempStorage(this.storage);
        }
        DOMUtils.setAttribute(wb.getWorkbookElement(), "version", VERSION);
        if (this.source.hasEntry("meta.xml")) {
            Document metaDocument = this.loader.loadXMLFile(this.source, "meta.xml");
            MetaImpl meta = new MetaImpl(metaDocument);
            wb.setMeta(meta);
        }
        if (this.source.hasEntry("META-INF/manifest.xml")) {
            Document mfDocument = this.loader.loadXMLFile(this.source, "META-INF/manifest.xml");
            ManifestImpl manifest = new ManifestImpl(mfDocument);
            manifest.setWorkbook(wb);
            wb.setManifest(manifest);
            manifest.getFileEntries();
            if (this.storage != null) {
                IOutputTarget target = this.storage.getOutputTarget();
                Iterator<String> entries = this.source.getEntries();
                while (entries.hasNext()) {
                    String path = entries.next();
                    this.copyEntry(this.source, target, path);
                }
            }
        }
        if (this.source.hasEntry("styles.xml")) {
            Document ssDocument = this.loader.loadXMLFile(this.source, "styles.xml");
            this.upgradeStyleSheet(ssDocument);
            StyleSheetImpl ss = new StyleSheetImpl(ssDocument);
            wb.setStyleSheet(ss);
            ss.getAllStyles();
        }
        this.loadWorkbookContent(wb, this.contentDocument);
        return wb;
    }

    private void copyEntry(IInputSource source, IOutputTarget target, String entryPath) throws CoreException {
        try {
            InputStream in = this.getInputStream(source, entryPath);
            if (in != null) {
                OutputStream out;
                long time = source.getEntryTime(entryPath);
                if (time >= 0L) {
                    target.setEntryTime(entryPath, time);
                }
                if ((out = this.getOutputStream(target, entryPath)) != null) {
                    FileUtils.transfer(in, out, true);
                }
            }
        }
        catch (IOException e) {
            Core.getLogger().log(e);
        }
        catch (CoreException e) {
            if (e.getType() == 17 || e.getType() == 100) {
                throw e;
            }
            Core.getLogger().log(e);
        }
    }

    private InputStream getInputStream(IInputSource source, String entryPath) throws CoreException {
        if (!source.hasEntry(entryPath)) {
            return null;
        }
        InputStream in = source.getEntryStream(entryPath);
        if (in == null) {
            return null;
        }
        return in;
    }

    private OutputStream getOutputStream(IOutputTarget target, String entryPath) {
        if (!target.isEntryAvaialble(entryPath)) {
            return null;
        }
        return target.getEntryStream(entryPath);
    }

    private void upgradeStyleSheet(Document ssDocument) {
        Element element = ssDocument.getDocumentElement();
        if (element != null) {
            this.upgradeStyles(element);
        }
    }

    private void upgradeStyles(Element element) {
        this.upgradeStyle(element);
        Iterator<Element> it = DOMUtils.childElementIter(element);
        while (it.hasNext()) {
            Element subElement = it.next();
            this.upgradeStyles(subElement);
        }
    }

    private void upgradeStyle(Element element) {
        NamedNodeMap attributes = element.getAttributes();
        Map<String, String> added = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr = (Attr)attributes.item(i);
            String name = attr.getName();
            String value = attr.getValue();
            if ("type".equals(name)) {
                attr.setValue(value.toLowerCase());
            } else if ("style-family".equals(name)) {
                attr.setValue(value.toLowerCase());
            } else if (ATTR_RAINBOWCOLOR.equals(name)) {
                if (Boolean.TRUE.toString().equalsIgnoreCase(value)) {
                    added = this.add(added, "multi-line-colors", VAL_MULTI_LINE_COLORS);
                }
            } else if (ATTR_SPINYLINES.equals(name) && Boolean.TRUE.toString().equalsIgnoreCase(value)) {
                added = this.add(added, "line-tapered", "tapered");
            }
            if ("floatingMainTopic".equals(value)) {
                attr.setValue("floatingTopic");
                continue;
            }
            if (!"$none$".equals(value)) continue;
            attr.setValue("none");
        }
        if (added != null) {
            for (Map.Entry e : added.entrySet()) {
                element.setAttribute((String)e.getKey(), (String)e.getValue());
            }
        }
    }

    private Map<String, String> add(Map<String, String> map, String key, String value) {
        if (map == null) {
            map = new HashMap<String, String>();
        }
        map.put(key, value);
        return map;
    }

    private void loadWorkbookContent(WorkbookImpl workbook, Document wbDocument) throws CoreException {
        Element wbEle = wbDocument.getDocumentElement();
        Iterator<Element> sheetIter = DOMUtils.childElementIterByTag(wbEle, TAG_MAP);
        boolean primary = true;
        while (sheetIter.hasNext()) {
            ISheet sheet;
            Element sheetEle = sheetIter.next();
            if (primary) {
                sheet = workbook.getPrimarySheet();
                primary = false;
            } else {
                sheet = workbook.createSheet();
                workbook.addSheet(sheet);
            }
            this.loadSheet(sheet, sheetEle, workbook);
        }
    }

    private void loadId(IAdaptable elementAdaptable, Element oldElement, WorkbookImpl workbook) {
        String id;
        Element newElement = this.getElement(elementAdaptable);
        if (newElement != null && (id = DOMUtils.getAttribute(oldElement, "id")) != null) {
            Document doc = newElement.getOwnerDocument();
            workbook.getAdaptableRegistry().unregisterById(elementAdaptable, newElement.getAttribute("id"), doc);
            DOMUtils.replaceId(newElement, id);
            workbook.getAdaptableRegistry().registerById(elementAdaptable, id, doc);
        }
    }

    private Element getElement(IAdaptable elementAdaptable) {
        return (Element)elementAdaptable.getAdapter(Element.class);
    }

    private void loadTitle(ITitled titled, Element oldElement) {
        String title = DOMUtils.getTextContentByTag(oldElement, "title");
        titled.setTitleText(title);
    }

    private void loadStyle(IStyled styled, Element oldElement) {
        String styleId = DOMUtils.getAttribute(oldElement, "style-id");
        styled.setStyleId(styleId);
    }

    private void loadSheet(ISheet sheet, Element sheetEle, WorkbookImpl workbook) {
        Element relsEle;
        this.loadId(sheet, sheetEle, workbook);
        this.loadTitle(sheet, sheetEle);
        this.loadSheetStyle(sheet, sheetEle, workbook);
        String themeId = DOMUtils.getAttribute(sheetEle, "theme");
        sheet.setThemeId(themeId);
        Element topicEle = DOMUtils.getFirstChildElementByTag(sheetEle, TAG_ROOT_TOPIC);
        if (topicEle != null) {
            this.loadTopic(sheet.getRootTopic(), topicEle, workbook);
        }
        if ((relsEle = DOMUtils.getFirstChildElementByTag(sheetEle, "relationships")) != null) {
            Iterator<Element> relIter = DOMUtils.childElementIterByTag(relsEle, "relationship");
            while (relIter.hasNext()) {
                Element relEle = relIter.next();
                IRelationship rel = workbook.createRelationship();
                sheet.addRelationship(rel);
                this.loadRelationship(rel, relEle, workbook);
            }
        }
    }

    private void loadSheetStyle(ISheet sheet, Element sheetEle, IWorkbook workbook) {
        String type;
        String styleId = DOMUtils.getAttribute(sheetEle, "style-id");
        IStyleSheet styleSheet = workbook.getStyleSheet();
        IStyle style = styleSheet.findStyle(styleId);
        if (style != null && TAG_MAP.equals(type = style.getType())) {
            String p = style.getProperty("background");
            String url = this.findAttachmentUrl(p, workbook);
            style.setProperty("background", url);
        }
        sheet.setStyleId(styleId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findAttachmentUrl(String url, IWorkbook workbook) {
        if (HyperlinkUtils.isAttachmentURL(url)) {
            IFileEntry entry;
            String attId = HyperlinkUtils.toAttachmentPath(url);
            if (attId.startsWith("#")) {
                attId = attId.substring(1, attId.length());
            }
            if ((entry = this.findAttachmentEntry(attId, workbook.getManifest())) != null) {
                String string;
                InputStream is = entry.getInputStream();
                try {
                    String path = entry.getPath();
                    IFileEntry fileEntry = workbook.getManifest().createAttachmentFromStream(is, path);
                    string = HyperlinkUtils.toAttachmentURL(fileEntry.getPath());
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                is.close();
                return string;
            }
        }
        return url;
    }

    private void loadTopic(ITopic topic, Element topicEle, WorkbookImpl workbook) {
        this.loadId(topic, topicEle, workbook);
        this.loadTitle(topic, topicEle);
        this.loadStyle(topic, topicEle);
        this.loadFolded(topic, topicEle);
        this.loadPosition(topic, topicEle);
        this.loadHyperlink(topic, topicEle);
        this.loadStructureClass(topic, topicEle);
        this.loadLabels(topic, topicEle);
        this.loadImage(topic, topicEle, workbook);
        this.loadMarkers(topic, topicEle, workbook);
        this.loadNotes(topic, topicEle, workbook);
        this.loadNumbering(topic, topicEle);
        this.loadSubTopics(topic, topicEle, TAG_ATTACHED_TOPICS, "attached", workbook);
        this.loadSubTopics(topic, topicEle, TAG_DETACHED_TOPICS, "detached", workbook);
        this.loadBoundaries(topic, topicEle, workbook);
    }

    private void loadHyperlink(ITopic topic, Element topicEle) {
        String url = DOMUtils.getAttribute(topicEle, "xlink:href");
        if (url != null) {
            url = this.readAttachment(topic, url);
        }
        topic.setHyperlink(url);
    }

    private String readAttachment(ITopic topic, String url) {
        IFileEntry entry;
        String path = HyperlinkUtils.toAttachmentPath(url);
        if (path.startsWith("#")) {
            path = path.substring(1);
        }
        if ((entry = this.findAttachmentEntry(path, topic.getOwnedWorkbook().getManifest())) != null) {
            url = HyperlinkUtils.toAttachmentURL(entry.getPath());
        }
        return url;
    }

    private void loadFolded(ITopic topic, Element topicEle) {
        String folded = DOMUtils.getAttribute(topicEle, ATTR_FOLDED);
        topic.setFolded(Boolean.TRUE.toString().equalsIgnoreCase(folded));
    }

    private void loadPosition(ITopic topic, Element topicEle) {
        Element positionEle = DOMUtils.getFirstChildElementByTag(topicEle, "position");
        if (positionEle != null) {
            String x = DOMUtils.getAttribute(positionEle, "svg:x");
            String y = DOMUtils.getAttribute(positionEle, "svg:y");
            if (x != null && y != null) {
                try {
                    int xValue = Integer.parseInt(x);
                    int yValue = Integer.parseInt(y);
                    topic.setPosition(xValue, yValue);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (x != null || y != null) {
                Element newPositionEle = DOMUtils.ensureChildElement(this.getElement(topic), "position");
                DOMUtils.setAttribute(newPositionEle, "svg:x", x);
                DOMUtils.setAttribute(newPositionEle, "svg:y", y);
            }
        }
    }

    private void loadBoundaries(ITopic topic, Element topicEle, WorkbookImpl workbook) {
        Element boundariesEle = DOMUtils.getFirstChildElementByTag(topicEle, "boundaries");
        if (boundariesEle == null) {
            return;
        }
        Iterator<Element> boundaryIter = DOMUtils.childElementIterByTag(boundariesEle, "boundary");
        while (boundaryIter.hasNext()) {
            Element boundaryEle = boundaryIter.next();
            IBoundary boundary = workbook.createBoundary();
            topic.addBoundary(boundary);
            this.loadBoundary(boundary, boundaryEle, workbook);
        }
    }

    private void loadBoundary(IBoundary boundary, Element boundaryEle, WorkbookImpl workbook) {
        String startIndex = DOMUtils.getAttribute(boundaryEle, ATTR_START_INDEX);
        String endIndex = DOMUtils.getAttribute(boundaryEle, ATTR_END_INDEX);
        Element newBoundaryEle = this.getElement(boundary);
        DOMUtils.setAttribute(newBoundaryEle, ATTR_START_INDEX, startIndex);
        DOMUtils.setAttribute(newBoundaryEle, ATTR_END_INDEX, endIndex);
        this.loadStyle(boundary, boundaryEle);
    }

    private void loadSubTopics(ITopic topic, Element topicEle, String topicsTag, String topicType, WorkbookImpl workbook) {
        Element subTopicsEle = DOMUtils.getFirstChildElementByTag(topicEle, topicsTag);
        if (subTopicsEle == null) {
            return;
        }
        Iterator<Element> subTopicIter = DOMUtils.childElementIterByTag(subTopicsEle, "topic");
        while (subTopicIter.hasNext()) {
            Element subTopicEle = subTopicIter.next();
            ITopic subTopic = workbook.createTopic();
            topic.add(subTopic, topicType);
            this.loadTopic(subTopic, subTopicEle, workbook);
        }
    }

    private void loadNumbering(ITopic topic, Element topicEle) {
        Element numberingEle = DOMUtils.getFirstChildElementByTag(topicEle, "numbering");
        if (numberingEle == null) {
            return;
        }
        INumbering numbering = topic.getNumbering();
        String format = DOMUtils.getAttribute(numberingEle, "number-format");
        String prefix = DOMUtils.getAttribute(numberingEle, "prefix");
        String suffix = DOMUtils.getAttribute(numberingEle, "suffix");
        String inherited = DOMUtils.getAttribute(numberingEle, ATTR_INHERITED);
        numbering.setFormat(format);
        numbering.setPrefix(prefix);
        numbering.setSuffix(suffix);
        boolean prependParentNumbering = inherited == null || Boolean.parseBoolean(inherited);
        numbering.setPrependsParentNumbers(prependParentNumbering);
    }

    private void loadNotes(ITopic topic, Element topicEle, WorkbookImpl workbook) {
        Element richEle;
        Element notesEle = DOMUtils.getFirstChildElementByTag(topicEle, "notes");
        if (notesEle == null) {
            return;
        }
        INotes notes = topic.getNotes();
        Element plainEle = DOMUtils.getFirstChildElementByTag(notesEle, TAG_PLAIN);
        if (plainEle != null) {
            IPlainNotesContent content = (IPlainNotesContent)workbook.createNotesContent(TAG_PLAIN);
            content.setTextContent(plainEle.getTextContent());
            notes.setContent(TAG_PLAIN, content);
        }
        if ((richEle = DOMUtils.getFirstChildElementByTag(notesEle, TAG_RICH)) != null) {
            IHtmlNotesContent content = (IHtmlNotesContent)workbook.createNotesContent("html");
            this.loadRichNotes(topic, topicEle, richEle, content, workbook);
            notes.setContent("html", content);
        }
    }

    private void loadRichNotes(ITopic topic, Element topicEle, Element richEle, IHtmlNotesContent content, WorkbookImpl workbook) {
        Iterator<Element> it = DOMUtils.childElementIterByTag(richEle, "xhtml:p");
        while (it.hasNext()) {
            Element pEle = it.next();
            IParagraph p = content.createParagraph();
            this.loadSpanList(topic, topicEle, pEle, p, content, workbook);
            content.addParagraph(p);
        }
    }

    private void loadSpanList(ITopic topic, Element topicEle, Element listEle, ISpanList list, IHtmlNotesContent content, WorkbookImpl workbook) {
        NodeList ns = listEle.getChildNodes();
        for (int i = 0; i < ns.getLength(); ++i) {
            Node n = ns.item(i);
            if (n instanceof Text) {
                ITextSpan span = content.createTextSpan(n.getTextContent());
                list.addSpan(span);
                continue;
            }
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            String tag = e.getTagName();
            if ("xhtml:img".equals(tag)) {
                String url = this.findImageUrl(e, workbook);
                if (url == null) continue;
                IImageSpan span = content.createImageSpan(url);
                list.addSpan(span);
                continue;
            }
            if ("xhtml:a".equals(tag)) {
                String href = e.getAttribute("xlink:href");
                if (href == null) continue;
                IHyperlinkSpan hyperlinkSpan = content.createHyperlinkSpan(href);
                list.addSpan(hyperlinkSpan);
                this.loadSpanList(topic, topicEle, e, hyperlinkSpan, content, workbook);
                continue;
            }
            ITextSpan span = content.createTextSpan(e.getTextContent());
            span.setStyleId(DOMUtils.getAttribute(e, "style-id"));
            list.addSpan(span);
        }
    }

    private void loadMarkers(ITopic topic, Element topicEle, WorkbookImpl workbook) {
        Element markersEle = DOMUtils.getFirstChildElementByTag(topicEle, TAG_MARKERS);
        if (markersEle == null) {
            return;
        }
        Iterator<Element> markerIter = DOMUtils.childElementIterByTag(markersEle, "marker");
        while (markerIter.hasNext()) {
            Element markerEle = markerIter.next();
            this.loadMarker(topic, markerEle, workbook);
        }
    }

    private void loadMarker(ITopic topic, Element markerEle, WorkbookImpl workbook) {
        String markerGroupId;
        String markerId;
        String id = DOMUtils.getAttribute(markerEle, "id");
        if (id == null) {
            return;
        }
        String type = DOMUtils.getAttribute(markerEle, "type");
        int sepIndex = id.indexOf(47);
        if (sepIndex >= 0) {
            markerId = id.substring(sepIndex + 1);
            markerGroupId = VAL_USER.equals(type) ? (id.startsWith("#") ? id.substring(1, sepIndex) : id.substring(0, sepIndex)) : null;
        } else {
            markerId = id;
            markerGroupId = VAL_USER.equals(type) || VAL_ATTACHMENT.equals(type) ? this.getDefaultMarkerGroupId() : null;
        }
        if (markerGroupId != null) {
            IFileEntry markerEntry;
            IMarker marker;
            IMarkerGroup group;
            if (this.markerSheet == null) {
                this.markerSheet = (MarkerSheetImpl)workbook.getMarkerSheet();
            }
            if ((group = this.markerSheet.findMarkerGroup(markerGroupId)) == null) {
                group = this.markerSheet.createMarkerGroup(false);
                this.markerSheet.getElementRegistry().unregister(group);
                DOMUtils.replaceId(((MarkerGroupImpl)group).getImplementation(), markerGroupId);
                this.markerSheet.getElementRegistry().register(group);
                this.markerSheet.addMarkerGroup(group);
            }
            if ((marker = group.getMarker(markerId)) == null && (markerEntry = this.findAttachmentEntry(markerId, workbook.getManifest())) != null) {
                String path = markerEntry.getPath();
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                marker = this.markerSheet.createMarker(path);
                this.markerSheet.getElementRegistry().unregister(marker);
                DOMUtils.replaceId(((MarkerImpl)marker).getImplementation(), markerId);
                this.markerSheet.getElementRegistry().register(marker);
            }
        }
        topic.addMarker(markerId);
    }

    private IFileEntry findAttachmentEntry(String attId, IManifest manifest) {
        List<IFileEntry> fileEntries = manifest.getFileEntries();
        for (IFileEntry entry : fileEntries) {
            if (!entry.getPath().contains(attId)) continue;
            return entry;
        }
        return null;
    }

    private String getDefaultMarkerGroupId() {
        if (this.defaultMarkerGroupId == null) {
            this.defaultMarkerGroupId = Core.getIdFactory().createId();
        }
        return this.defaultMarkerGroupId;
    }

    private void loadImage(ITopic topic, Element topicEle, WorkbookImpl workbook) {
        int h;
        String height;
        int w;
        Element imgEle = DOMUtils.getFirstChildElementByTag(topicEle, "xhtml:img");
        if (imgEle == null) {
            return;
        }
        IImage image = topic.getImage();
        String url = this.findImageUrl(imgEle, workbook);
        image.setSource(url);
        String width = DOMUtils.getAttribute(imgEle, "svg:width");
        if (width != null && (w = NumberUtils.safeParseInt(width, -1)) >= 0) {
            image.setWidth(w);
        }
        if ((height = DOMUtils.getAttribute(imgEle, "svg:height")) != null && (h = NumberUtils.safeParseInt(height, -1)) >= 0) {
            image.setHeight(h);
        }
        String alignment = DOMUtils.getAttribute(imgEle, "align");
        image.setAlignment(alignment);
    }

    private String findImageUrl(Element imgEle, WorkbookImpl workbook) {
        String url = DOMUtils.getAttribute(imgEle, "xhtml:src");
        if (HyperlinkUtils.isAttachmentURL(url)) {
            IFileEntry entry;
            String attId = HyperlinkUtils.toAttachmentPath(url);
            if (attId.startsWith("#")) {
                attId = attId.substring(1, attId.length());
            }
            if ((entry = this.findAttachmentEntry(attId, workbook.getManifest())) != null) {
                url = HyperlinkUtils.toAttachmentURL(entry.getPath());
            }
        }
        return url;
    }

    private void loadLabels(ITopic topic, Element topicEle) {
        Iterator<Element> labelsIter = DOMUtils.childElementIterByTag(topicEle, "labels");
        while (labelsIter.hasNext()) {
            Element labelsEle = labelsIter.next();
            Iterator<Element> labelIter = DOMUtils.childElementIterByTag(labelsEle, "label");
            while (labelIter.hasNext()) {
                Element labelEle = labelIter.next();
                String label = labelEle.getTextContent();
                topic.addLabel(label);
            }
        }
    }

    private void loadStructureClass(ITopic topic, Element topicEle) {
        String floatingType = DOMUtils.getAttribute(topicEle, ATTR_FLOATING_TYPE);
        String structureClass = VAL_CENTRAL.equals(floatingType) ? "org.xmind.branchPolicy.map.floating" : this.upgradeStructureClass(DOMUtils.getAttribute(topicEle, "structure-class"));
        topic.setStructureClass(structureClass);
    }

    private String upgradeStructureClass(String structureClass) {
        if (structureClass == null) {
            return null;
        }
        if ("org.xmind.branchPolicy.org-chart.left".equals(structureClass)) {
            structureClass = "org.xmind.ui.logic.left";
        } else if ("org.xmind.branchPolicy.org-chart.right".equals(structureClass)) {
            structureClass = "org.xmind.ui.logic.right";
        } else if ("org.xmind.branchPolicy.chart2d".equals(structureClass)) {
            structureClass = "org.xmind.ui.spreadsheet";
        } else if (structureClass.startsWith("org.xmind.branchPolicy.")) {
            structureClass = "org.xmind.ui." + structureClass.substring(23);
        }
        return structureClass;
    }

    private void loadRelationship(IRelationship rel, Element relEle, WorkbookImpl workbook) {
        this.loadId(rel, relEle, workbook);
        this.loadStyle(rel, relEle);
        this.loadTitle(rel, relEle);
        rel.setEnd1Id(DOMUtils.getAttribute(relEle, ATTR_FROM));
        rel.setEnd2Id(DOMUtils.getAttribute(relEle, ATTR_TO));
        this.loadControlPoint(rel, 0, relEle, ATTR_FROM_POINT);
        this.loadControlPoint(rel, 1, relEle, ATTR_TO_POINT);
    }

    private void loadControlPoint(IRelationship rel, int index, Element relEle, String pointAttr) {
        String[] xy;
        String p = DOMUtils.getAttribute(relEle, pointAttr);
        if (p != null && (xy = p.split(", ")).length == 2) {
            int y;
            int x;
            try {
                x = Integer.parseInt(xy[0]);
                y = Integer.parseInt(xy[1]);
            }
            catch (Throwable e) {
                return;
            }
            rel.getControlPoint(index).setPosition(x, y);
        }
    }
}

