/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.util.Properties;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.Marker;
import org.xmind.core.internal.dom.MarkerSheetImpl;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerResource;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.util.DOMUtils;

public class MarkerImpl
extends Marker
implements ICoreEventSource {
    private Element implementation;
    private MarkerSheetImpl ownedSheet;

    public MarkerImpl(Element implementation, MarkerSheetImpl ownedSheet) {
        this.implementation = DOMUtils.addIdAttribute(implementation);
        this.ownedSheet = ownedSheet;
    }

    public IMarkerSheet getOwnedSheet() {
        return this.ownedSheet;
    }

    public Element getImplementation() {
        return this.implementation;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == Element.class || adapter == Node.class) {
            return this.implementation;
        }
        return super.getAdapter(adapter);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof MarkerImpl)) {
            return false;
        }
        MarkerImpl that = (MarkerImpl)obj;
        return this.implementation == that.implementation;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    public String toString() {
        return "MKR#" + this.getId() + "(" + this.getName() + ")";
    }

    public String getName() {
        Properties properties;
        String name = this.implementation.getAttribute("name");
        if (name.startsWith("%") && (properties = this.ownedSheet.getProperties()) != null) {
            String key = name.substring(1);
            name = properties.getProperty(key, name);
        }
        return name;
    }

    public IMarkerGroup getParent() {
        Node p = this.implementation.getParentNode();
        if (DOMUtils.isElementByTag(p, "marker-group")) {
            return (IMarkerGroup)this.ownedSheet.getElementAdapter((Element)p);
        }
        return null;
    }

    public IMarkerResource getResource() {
        return this.ownedSheet.getMarkerResource(this);
    }

    public String getResourcePath() {
        return this.implementation.getAttribute("resource");
    }

    public void setName(String name) {
        String oldName = this.implementation.hasAttribute("name") ? this.getName() : null;
        DOMUtils.setAttribute(this.implementation, "name", name);
        String newName = this.implementation.hasAttribute("name") ? this.getName() : null;
        this.fireValueChange("name", oldName, newName);
    }

    public String getId() {
        return this.implementation.getAttribute("id");
    }

    public boolean isHidden() {
        return Boolean.parseBoolean(this.implementation.getAttribute("hidden"));
    }

    public void setHidden(boolean hidden) {
        DOMUtils.setAttribute(this.implementation, "hidden", Boolean.toString(hidden));
    }

    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener(this, type, listener);
    }

    private void fireValueChange(String type, Object oldValue, Object newValue) {
        this.getCoreEventSupport().dispatchValueChange(this, type, oldValue, newValue);
    }

    public ICoreEventSupport getCoreEventSupport() {
        return this.ownedSheet.getCoreEventSupport();
    }
}

