/*
 * Decompiled with CFR 0.152.
 */
package com.github.eloyzone.jalalicalendar;

import com.github.eloyzone.jalalicalendar.DayOfWeekPersian;
import com.github.eloyzone.jalalicalendar.JalaliDate;
import com.github.eloyzone.jalalicalendar.MonthPersian;
import java.time.LocalDate;
import java.time.Month;

public class DateConverter {
    private double juliandayDayValue;
    private double persianaYearValue;
    private double persianaMonthSelectedIndex;
    private double persianaDayValue;
    private int persianaWeekDay;
    private double gregorianYearValue;
    private double gregorianMonthSelectedIndex;
    private double gregorianDayValue;
    private String[] NormLeap = new String[]{"Normal year", "Leap year"};
    double GREGORIAN_EPOCH = 1721425.5;
    double[][] JDE0tab1000 = new double[][]{{1721139.29189, 365242.1374, 0.06134, 0.00111, -7.1E-4}, {1721233.25401, 365241.72562, -0.05323, 0.00907, 2.5E-4}, {1721325.70455, 365242.49558, -0.11677, -0.00297, 7.4E-4}, {1721414.39987, 365242.88257, -0.00769, -0.00933, -6.0E-5}};
    double[][] JDE0tab2000 = new double[][]{{2451623.80984, 365242.37404, 0.05169, -0.00411, -5.7E-4}, {2451716.56767, 365241.62603, 0.00325, 0.00888, -3.0E-4}, {2451810.21715, 365242.01767, -0.11575, 0.00337, 7.8E-4}, {2451900.05952, 365242.74049, -0.06223, -0.00823, 3.2E-4}};
    double[] EquinoxpTerms = new double[]{485.0, 324.96, 1934.136, 203.0, 337.23, 32964.467, 199.0, 342.08, 20.186, 182.0, 27.85, 445267.112, 156.0, 73.14, 45036.886, 136.0, 171.52, 22518.443, 77.0, 222.54, 65928.934, 74.0, 296.72, 3034.906, 70.0, 243.58, 9037.513, 58.0, 119.81, 33718.147, 52.0, 297.17, 150.678, 50.0, 21.02, 2281.226, 45.0, 247.54, 29929.562, 44.0, 325.15, 31555.956, 29.0, 60.93, 4443.417, 18.0, 155.12, 67555.328, 17.0, 288.79, 4562.452, 16.0, 198.04, 62894.029, 14.0, 199.76, 31436.921, 12.0, 95.39, 14577.848, 12.0, 287.11, 31931.756, 12.0, 320.81, 34777.259, 9.0, 227.73, 1222.114, 8.0, 15.45, 16859.074};
    private double[] deltaTtab = new double[]{121.0, 112.0, 103.0, 95.0, 88.0, 82.0, 77.0, 72.0, 68.0, 63.0, 60.0, 56.0, 53.0, 51.0, 48.0, 46.0, 44.0, 42.0, 40.0, 38.0, 35.0, 33.0, 31.0, 29.0, 26.0, 24.0, 22.0, 20.0, 18.0, 16.0, 14.0, 12.0, 11.0, 10.0, 9.0, 8.0, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 8.0, 8.0, 9.0, 9.0, 9.0, 9.0, 9.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 11.0, 11.0, 11.0, 11.0, 11.0, 12.0, 12.0, 12.0, 12.0, 13.0, 13.0, 13.0, 14.0, 14.0, 14.0, 14.0, 15.0, 15.0, 15.0, 15.0, 15.0, 16.0, 16.0, 16.0, 16.0, 16.0, 16.0, 16.0, 16.0, 15.0, 15.0, 14.0, 13.0, 13.1, 12.5, 12.2, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 11.9, 11.6, 11.0, 10.2, 9.2, 8.2, 7.1, 6.2, 5.6, 5.4, 5.3, 5.4, 5.6, 5.9, 6.2, 6.5, 6.8, 7.1, 7.3, 7.5, 7.6, 7.7, 7.3, 6.2, 5.2, 2.7, 1.4, -1.2, -2.8, -3.8, -4.8, -5.5, -5.3, -5.6, -5.7, -5.9, -6.0, -6.3, -6.5, -6.2, -4.7, -2.8, -0.1, 2.6, 5.3, 7.7, 10.4, 13.3, 16.0, 18.2, 20.2, 21.1, 22.4, 23.5, 23.8, 24.3, 24.0, 23.9, 23.9, 23.7, 24.0, 24.3, 25.3, 26.2, 27.3, 28.2, 29.1, 30.0, 30.7, 31.4, 32.2, 33.1, 34.0, 35.0, 36.5, 38.3, 40.2, 42.2, 44.5, 46.5, 48.5, 50.5, 52.2, 53.8, 54.9, 55.8, 56.9, 58.3, 60.0, 61.6, 63.0, 65.0, 66.6};
    private double J2000 = 2451545.0;
    private double JulianCentury = 36525.0;
    private double JulianMillennium = this.JulianCentury * 10.0;
    private double[] nutArgCoeff = new double[]{-171996.0, -1742.0, 92095.0, 89.0, -13187.0, -16.0, 5736.0, -31.0, -2274.0, -2.0, 977.0, -5.0, 2062.0, 2.0, -895.0, 5.0, 1426.0, -34.0, 54.0, -1.0, 712.0, 1.0, -7.0, 0.0, -517.0, 12.0, 224.0, -6.0, -386.0, -4.0, 200.0, 0.0, -301.0, 0.0, 129.0, -1.0, 217.0, -5.0, -95.0, 3.0, -158.0, 0.0, 0.0, 0.0, 129.0, 1.0, -70.0, 0.0, 123.0, 0.0, -53.0, 0.0, 63.0, 0.0, 0.0, 0.0, 63.0, 1.0, -33.0, 0.0, -59.0, 0.0, 26.0, 0.0, -58.0, -1.0, 32.0, 0.0, -51.0, 0.0, 27.0, 0.0, 48.0, 0.0, 0.0, 0.0, 46.0, 0.0, -24.0, 0.0, -38.0, 0.0, 16.0, 0.0, -31.0, 0.0, 13.0, 0.0, 29.0, 0.0, 0.0, 0.0, 29.0, 0.0, -12.0, 0.0, 26.0, 0.0, 0.0, 0.0, -22.0, 0.0, 0.0, 0.0, 21.0, 0.0, -10.0, 0.0, 17.0, -1.0, 0.0, 0.0, 16.0, 0.0, -8.0, 0.0, -16.0, 1.0, 7.0, 0.0, -15.0, 0.0, 9.0, 0.0, -13.0, 0.0, 7.0, 0.0, -12.0, 0.0, 6.0, 0.0, 11.0, 0.0, 0.0, 0.0, -10.0, 0.0, 5.0, 0.0, -8.0, 0.0, 3.0, 0.0, 7.0, 0.0, -3.0, 0.0, -7.0, 0.0, 0.0, 0.0, -7.0, 0.0, 3.0, 0.0, -7.0, 0.0, 3.0, 0.0, 6.0, 0.0, 0.0, 0.0, 6.0, 0.0, -3.0, 0.0, 6.0, 0.0, -3.0, 0.0, -6.0, 0.0, 3.0, 0.0, -6.0, 0.0, 3.0, 0.0, 5.0, 0.0, 0.0, 0.0, -5.0, 0.0, 3.0, 0.0, -5.0, 0.0, 3.0, 0.0, -5.0, 0.0, 3.0, 0.0, 4.0, 0.0, 0.0, 0.0, 4.0, 0.0, 0.0, 0.0, 4.0, 0.0, 0.0, 0.0, -4.0, 0.0, 0.0, 0.0, -4.0, 0.0, 0.0, 0.0, -4.0, 0.0, 0.0, 0.0, 3.0, 0.0, 0.0, 0.0, -3.0, 0.0, 0.0, 0.0, -3.0, 0.0, 0.0, 0.0, -3.0, 0.0, 0.0, 0.0, -3.0, 0.0, 0.0, 0.0, -3.0, 0.0, 0.0, 0.0, -3.0, 0.0, 0.0, 0.0, -3.0, 0.0, 0.0, 0.0};
    private double[] nutArgMult = new double[]{0.0, 0.0, 0.0, 0.0, 1.0, -2.0, 0.0, 0.0, 2.0, 2.0, 0.0, 0.0, 0.0, 2.0, 2.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, -2.0, 1.0, 0.0, 2.0, 2.0, 0.0, 0.0, 0.0, 2.0, 1.0, 0.0, 0.0, 1.0, 2.0, 2.0, -2.0, -1.0, 0.0, 2.0, 2.0, -2.0, 0.0, 1.0, 0.0, 0.0, -2.0, 0.0, 0.0, 2.0, 1.0, 0.0, 0.0, -1.0, 2.0, 2.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 2.0, 0.0, -1.0, 2.0, 2.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 2.0, 1.0, -2.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, -2.0, 2.0, 1.0, 2.0, 0.0, 0.0, 2.0, 2.0, 0.0, 0.0, 2.0, 2.0, 2.0, 0.0, 0.0, 2.0, 0.0, 0.0, -2.0, 0.0, 1.0, 2.0, 2.0, 0.0, 0.0, 0.0, 2.0, 0.0, -2.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, -1.0, 2.0, 1.0, 0.0, 2.0, 0.0, 0.0, 0.0, 2.0, 0.0, -1.0, 0.0, 1.0, -2.0, 2.0, 0.0, 2.0, 2.0, 0.0, 1.0, 0.0, 0.0, 1.0, -2.0, 0.0, 1.0, 0.0, 1.0, 0.0, -1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 2.0, -2.0, 0.0, 2.0, 0.0, -1.0, 2.0, 1.0, 2.0, 0.0, 1.0, 2.0, 2.0, 0.0, 1.0, 0.0, 2.0, 2.0, -2.0, 1.0, 1.0, 0.0, 0.0, 0.0, -1.0, 0.0, 2.0, 2.0, 2.0, 0.0, 0.0, 2.0, 1.0, 2.0, 0.0, 1.0, 0.0, 0.0, -2.0, 0.0, 2.0, 2.0, 2.0, -2.0, 0.0, 1.0, 2.0, 1.0, 2.0, 0.0, -2.0, 0.0, 1.0, 2.0, 0.0, 0.0, 0.0, 1.0, 0.0, -1.0, 1.0, 0.0, 0.0, -2.0, -1.0, 0.0, 2.0, 1.0, -2.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 2.0, 2.0, 1.0, -2.0, 0.0, 2.0, 0.0, 1.0, -2.0, 1.0, 0.0, 2.0, 1.0, 0.0, 0.0, 1.0, -2.0, 0.0, -1.0, 0.0, 1.0, 0.0, 0.0, -2.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 2.0, 0.0, -1.0, -1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, -1.0, 1.0, 2.0, 2.0, 2.0, -1.0, -1.0, 2.0, 2.0, 0.0, 0.0, -2.0, 2.0, 2.0, 0.0, 0.0, 3.0, 2.0, 2.0, 2.0, -1.0, 0.0, 2.0, 2.0};
    private double[] oterms = new double[]{-4680.93, -1.55, 1999.25, -51.38, -249.67, -39.05, 7.12, 27.87, 5.79, 2.45};
    private double PERSIAN_EPOCH = 1948320.5;
    private double TropicalYear = 365.24219878;
    double[] perscal;

    public LocalDate jalaliToGregorian(JalaliDate jalaliDate) {
        return this.jalaliToGregorian(jalaliDate.getYear(), jalaliDate.getMonthPersian().getValue(), jalaliDate.getDay());
    }

    public LocalDate jalaliToGregorian(int year, MonthPersian month, int day) {
        this.validateDateValues(year, day);
        return this.jalaliToGregorian(year, month.getValue(), day);
    }

    public LocalDate jalaliToGregorian(int year, int month, int day) {
        this.validateDateValues(year, month, day);
        this.persianaYearValue = year;
        this.persianaMonthSelectedIndex = month - 1;
        this.persianaDayValue = day;
        this.setJulian(this.persianaToJd(this.persianaYearValue, this.persianaMonthSelectedIndex + 1.0, this.persianaDayValue) + 0.5);
        LocalDate localDate = LocalDate.of((int)this.gregorianYearValue, (int)this.gregorianMonthSelectedIndex + 1, (int)this.gregorianDayValue);
        return localDate;
    }

    public JalaliDate gregorianToJalali(int year, int month, int day) {
        this.validateDateValues(year, month, day);
        this.updateFromGregorian(year, month - 1, day);
        int persianYear = (int)this.persianaYearValue;
        int persianMonth = (int)this.persianaMonthSelectedIndex;
        int persianDay = (int)this.persianaDayValue;
        JalaliDate jalaliDate = new JalaliDate();
        jalaliDate.setYear(persianYear);
        jalaliDate.setMonthPersian(MonthPersian.getEnum(persianMonth));
        jalaliDate.setDay(persianDay);
        jalaliDate.setDayOfWeekPersian(DayOfWeekPersian.getEnum(this.persianaWeekDay));
        return jalaliDate;
    }

    protected DayOfWeekPersian getDayOfWeekPersian(JalaliDate jalaliDate) {
        return DayOfWeekPersian.getEnum(this.jalaliToGregorian(jalaliDate).getDayOfWeek().getValue());
    }

    public JalaliDate gregorianToJalali(int year, Month month, int day) {
        this.validateDateValues(year, day);
        return this.gregorianToJalali(year, month.getValue(), day);
    }

    public JalaliDate nowAsJalali() {
        LocalDate localDate = LocalDate.now();
        return this.gregorianToJalali(localDate.getYear(), localDate.getMonth(), localDate.getDayOfMonth());
    }

    public LocalDate nowAsGregorian() {
        return LocalDate.now();
    }

    private void validateDateValues(int year, int month, int day) {
        if (year < 0 || month < 0 || day < 0) {
            throw new IllegalArgumentException("Wrong value(s). date's year-month-day can not be negative");
        }
    }

    private void validateDateValues(int year, int day) {
        if (year < 0 || day < 0) {
            throw new IllegalArgumentException("Wrong value(s). date's year-month-day can not be negative");
        }
    }

    private double jwday(double j) {
        return this.mod(Math.floor(j + 1.5), 7.0);
    }

    private double mod(double a, double b) {
        return a - b * Math.floor(a / b);
    }

    private boolean leapGregorian(double year) {
        return year % 4.0 == 0.0 && (year % 100.0 != 0.0 || year % 400.0 == 0.0);
    }

    private double gregorianToJd(double year, double month, double day) {
        return this.GREGORIAN_EPOCH - 1.0 + 365.0 * (year - 1.0) + Math.floor((year - 1.0) / 4.0) + -Math.floor((year - 1.0) / 100.0) + Math.floor((year - 1.0) / 400.0) + Math.floor((367.0 * month - 362.0) / 12.0 + (double)(month <= 2.0 ? 0 : (this.leapGregorian(year) ? -1 : -2)) + day);
    }

    private double[] jdToGregorian(double jd) {
        double wjd = Math.floor(jd - 0.5) + 0.5;
        double depoch = wjd - this.GREGORIAN_EPOCH;
        double quadricent = Math.floor(depoch / 146097.0);
        double dqc = this.mod(depoch, 146097.0);
        double cent = Math.floor(dqc / 36524.0);
        double dcent = this.mod(dqc, 36524.0);
        double quad = Math.floor(dcent / 1461.0);
        double dquad = this.mod(dcent, 1461.0);
        double yindex = Math.floor(dquad / 365.0);
        double year = quadricent * 400.0 + cent * 100.0 + quad * 4.0 + yindex;
        if (cent != 4.0 && yindex != 4.0) {
            year += 1.0;
        }
        double yearday = wjd - this.gregorianToJd(year, 1.0, 1.0);
        double leapadj = wjd < this.gregorianToJd(year, 3.0, 1.0) ? 0 : (this.leapGregorian(year) ? 1 : 2);
        double month = Math.floor(((yearday + leapadj) * 12.0 + 373.0) / 367.0);
        double day = wjd - this.gregorianToJd(year, month, 1.0) + 1.0;
        double[] returnValue = new double[]{year, month, day};
        return returnValue;
    }

    private double equinox(double year, int which) {
        double Y;
        double[][] JDE0tab;
        if (year < 1000.0) {
            JDE0tab = this.JDE0tab1000;
            Y = year / 1000.0;
        } else {
            JDE0tab = this.JDE0tab2000;
            Y = (year - 2000.0) / 1000.0;
        }
        double JDE0 = JDE0tab[which][0] + JDE0tab[which][1] * Y + JDE0tab[which][2] * Y * Y + JDE0tab[which][3] * Y * Y * Y + JDE0tab[which][4] * Y * Y * Y * Y;
        double T = (JDE0 - 2451545.0) / 36525.0;
        double W = 35999.373 * T - 2.47;
        double deltaL = 1.0 + 0.0334 * this.dcos(W) + 7.0E-4 * this.dcos(2.0 * W);
        double S = 0.0;
        int j = 0;
        for (int i = 0; i < 24; ++i) {
            S += this.EquinoxpTerms[j] * this.dcos(this.EquinoxpTerms[j + 1] + this.EquinoxpTerms[j + 2] * T);
            j += 3;
        }
        double JDE = JDE0 + S * 1.0E-5 / deltaL;
        return JDE;
    }

    private double tehranEquinox(double year) {
        double equJED = this.equinox(year, 0);
        double equJD = equJED - this.deltat(year) / 86400.0;
        double equAPP = equJD + this.equationOfTime(equJED);
        double dtTehran = 0.14583333333333334;
        double equTehran = equAPP + dtTehran;
        return equTehran;
    }

    private double deltat(double year) {
        double dt;
        if (year >= 1620.0 && year <= 2000.0) {
            int i = (int)Math.floor((year - 1620.0) / 2.0);
            double f = (year - 1620.0) / 2.0 - (double)i;
            dt = this.deltaTtab[i] + (this.deltaTtab[i + 1] - this.deltaTtab[i]) * f;
        } else {
            double t = (year - 2000.0) / 100.0;
            if (year < 948.0) {
                dt = 2177.0 + 497.0 * t + 44.1 * t * t;
            } else {
                dt = 102.0 + 102.0 * t + 25.3 * t * t;
                if (year > 2000.0 && year < 2100.0) {
                    dt += 0.37 * (year - 2100.0);
                }
            }
        }
        return dt;
    }

    private double equationOfTime(double jd) {
        double tau = (jd - this.J2000) / this.JulianMillennium;
        double L0 = 280.4664567 + 360007.6982779 * tau + 0.03032028 * tau * tau + tau * tau * tau / 49931.0 + -(tau * tau * tau * tau / 15300.0) + -(tau * tau * tau * tau * tau / 2000000.0);
        L0 = this.fixangle(L0);
        double alpha = this.sunpos(jd)[10];
        double deltaPsi = this.nutation(jd)[0];
        double epsilon = this.obliqeq(jd) + this.nutation(jd)[1];
        double E = L0 + -0.0057183 + -alpha + deltaPsi * this.dcos(epsilon);
        E -= 20.0 * Math.floor(E / 20.0);
        return E /= 1440.0;
    }

    private double[] nutation(double jd) {
        int i;
        double t = (jd - 2451545.0) / 36525.0;
        double dp = 0.0;
        double de = 0.0;
        double[] ta = new double[5];
        double t2 = t * t;
        double t3 = t * t2;
        ta[0] = this.dtr(297.850363 + 445267.11148 * t - 0.0019142 * t2 + t3 / 189474.0);
        ta[1] = this.dtr(357.52772 + 35999.05034 * t - 1.603E-4 * t2 - t3 / 300000.0);
        ta[2] = this.dtr(134.96298 + 477198.867398 * t + 0.0086972 * t2 + t3 / 56250.0);
        ta[3] = this.dtr(93.27191 + 483202.017538 * t - 0.0036825 * t2 + t3 / 327270.0);
        ta[4] = this.dtr(125.04452 - 1934.136261 * t + 0.0020708 * t2 + t3 / 450000.0);
        for (i = 0; i < 5; ++i) {
            ta[i] = this.fixangr(ta[i]);
        }
        double to10 = t / 10.0;
        for (i = 0; i < 63; ++i) {
            double ang = 0.0;
            for (int j = 0; j < 5; ++j) {
                if (this.nutArgMult[i * 5 + j] == 0.0) continue;
                ang += this.nutArgMult[i * 5 + j] * ta[j];
            }
            dp += (this.nutArgCoeff[i * 4 + 0] + this.nutArgCoeff[i * 4 + 1] * to10) * Math.sin(ang);
            de += (this.nutArgCoeff[i * 4 + 2] + this.nutArgCoeff[i * 4 + 3] * to10) * Math.cos(ang);
        }
        double deltaPsi = dp / 3.6E7;
        double deltaEpsilon = de / 3.6E7;
        double[] returnValue = new double[]{deltaPsi, deltaEpsilon};
        return returnValue;
    }

    private double fixangr(double a) {
        return a - Math.PI * 2 * Math.floor(a / (Math.PI * 2));
    }

    private double[] sunpos(double jd) {
        double T = (jd - this.J2000) / this.JulianCentury;
        double T2 = T * T;
        double L0 = 280.46646 + 36000.76983 * T + 3.032E-4 * T2;
        L0 = this.fixangle(L0);
        double M = 357.52911 + 35999.05029 * T + -1.537E-4 * T2;
        M = this.fixangle(M);
        double e = 0.016708634 + -4.2037E-5 * T + -1.267E-7 * T2;
        double C = (1.914602 + -0.004817 * T + -1.4E-5 * T2) * this.dsin(M) + (0.019993 - 1.01E-4 * T) * this.dsin(2.0 * M) + 2.89E-4 * this.dsin(3.0 * M);
        double sunLong = L0 + C;
        double sunAnomaly = M + C;
        double sunR = 1.000001018 * (1.0 - e * e) / (1.0 + e * this.dcos(sunAnomaly));
        double Omega = 125.04 - 1934.136 * T;
        double Lambda = sunLong + -0.00569 + -0.00478 * this.dsin(Omega);
        double epsilon0 = this.obliqeq(jd);
        double epsilon = epsilon0 + 0.00256 * this.dcos(Omega);
        double Alpha = this.rtd(Math.atan2(this.dcos(epsilon0) * this.dsin(sunLong), this.dcos(sunLong)));
        Alpha = this.fixangle(Alpha);
        double Delta = this.rtd(Math.asin(this.dsin(epsilon0) * this.dsin(sunLong)));
        double AlphaApp = this.rtd(Math.atan2(this.dcos(epsilon) * this.dsin(Lambda), this.dcos(Lambda)));
        AlphaApp = this.fixangle(AlphaApp);
        double DeltaApp = this.rtd(Math.asin(this.dsin(epsilon) * this.dsin(Lambda)));
        double[] returnValue = new double[]{L0, M, e, C, sunLong, sunAnomaly, sunR, Lambda, Alpha, Delta, AlphaApp, DeltaApp};
        return returnValue;
    }

    private double dcos(double d) {
        return Math.cos(this.dtr(d));
    }

    private double dtr(double d) {
        return d * Math.PI / 180.0;
    }

    private double rtd(double r) {
        return r * 180.0 / Math.PI;
    }

    private double dsin(double d) {
        return Math.sin(this.dtr(d));
    }

    private double obliqeq(double jd) {
        double u;
        double v = u = (jd - this.J2000) / (this.JulianCentury * 100.0);
        double eps = 23.43929111111111;
        if (Math.abs(u) < 1.0) {
            for (int i = 0; i < 10; ++i) {
                eps += this.oterms[i] / 3600.0 * v;
                v *= u;
            }
        }
        return eps;
    }

    private double fixangle(double a) {
        return a - 360.0 * Math.floor(a / 360.0);
    }

    private double tehranEquinoxJd(double year) {
        double ep = this.tehranEquinox(year);
        double epg = Math.floor(ep);
        return epg;
    }

    private double[] persianaYear(double jd) {
        double guess = this.jdToGregorian(jd)[0] - 2.0;
        double lasteq = this.tehranEquinoxJd(guess);
        while (lasteq > jd) {
            lasteq = this.tehranEquinoxJd(guess -= 1.0);
        }
        double nexteq = lasteq - 1.0;
        while (!(lasteq <= jd) || !(jd < nexteq)) {
            lasteq = nexteq;
            nexteq = this.tehranEquinoxJd(guess += 1.0);
        }
        double adr = Math.round((lasteq - this.PERSIAN_EPOCH) / this.TropicalYear) + 1L;
        double[] returnValue = new double[]{adr, lasteq};
        return returnValue;
    }

    private double[] jdToPersiana(double jd) {
        jd = Math.floor(jd) + 0.5;
        double[] adr = this.persianaYear(jd);
        double year = adr[0];
        double yday = Math.floor(jd) - this.persianaToJd(year, 1.0, 1.0) + 1.0;
        double month = yday <= 186.0 ? Math.ceil(yday / 31.0) : Math.ceil((yday - 6.0) / 30.0);
        double day = Math.floor(jd) - this.persianaToJd(year, month, 1.0) + 1.0;
        double[] return_value = new double[]{year, month, day};
        return return_value;
    }

    private double persianaToJd(double year, double month, double day) {
        double[] adr = new double[]{year - 1.0, 0.0};
        double guess = this.PERSIAN_EPOCH - 1.0 + this.TropicalYear * (year - 1.0 - 1.0);
        while (adr[0] < year) {
            adr = this.persianaYear(guess);
            guess = adr[1] + (this.TropicalYear + 2.0);
        }
        double equinox = adr[1];
        double jd = equinox + (month <= 7.0 ? (month - 1.0) * 31.0 : (month - 1.0) * 30.0 + 6.0) + (day - 1.0);
        return jd;
    }

    protected boolean leapPersiana(double year) {
        return this.persianaToJd(year + 1.0, 1.0, 1.0) - this.persianaToJd(year, 1.0, 1.0) > 365.0;
    }

    private boolean leapPersian(double year) {
        return ((year - (double)(year > 0.0 ? 474 : 473)) % 2820.0 + 474.0 + 38.0) * 682.0 % 2816.0 < 682.0;
    }

    private double persianToJd(double year, double month, double day) {
        double epbase = year - (double)(year >= 0.0 ? 474 : 473);
        double epyear = 474.0 + this.mod(epbase, 2820.0);
        return day + (month <= 7.0 ? (month - 1.0) * 31.0 : (month - 1.0) * 30.0 + 6.0) + Math.floor((epyear * 682.0 - 110.0) / 2816.0) + (epyear - 1.0) * 365.0 + Math.floor(epbase / 2820.0) * 1029983.0 + (this.PERSIAN_EPOCH - 1.0);
    }

    private double[] jdToPersian(double jd) {
        double yday;
        double ycycle;
        jd = Math.floor(jd) + 0.5;
        double depoch = jd - this.persianToJd(475.0, 1.0, 1.0);
        double cycle = Math.floor(depoch / 1029983.0);
        double cyear = this.mod(depoch, 1029983.0);
        if (cyear == 1029982.0) {
            ycycle = 2820.0;
        } else {
            double aux1 = Math.floor(cyear / 366.0);
            double aux2 = this.mod(cyear, 366.0);
            ycycle = Math.floor((2134.0 * aux1 + 2816.0 * aux2 + 2815.0) / 1028522.0) + aux1 + 1.0;
        }
        double year = ycycle + 2820.0 * cycle + 474.0;
        if (year <= 0.0) {
            year -= 1.0;
        }
        double month = (yday = jd - this.persianToJd(year, 1.0, 1.0) + 1.0) <= 186.0 ? Math.ceil(yday / 31.0) : Math.ceil((yday - 6.0) / 30.0);
        double day = jd - this.persianToJd(year, month, 1.0) + 1.0;
        double[] returnValue = new double[]{year, month, day};
        return returnValue;
    }

    private void updateFromGregorian(int gregorianYear, int gregorianMonth, int gregorianDay) {
        double j;
        double year = this.gregorianYearValue = (double)gregorianYear;
        double mon = this.gregorianMonthSelectedIndex = (double)gregorianMonth;
        double mday = this.gregorianDayValue + (double)gregorianDay;
        this.juliandayDayValue = j = this.gregorianToJd(year, mon + 1.0, mday);
        double weekday = this.jwday(j);
        this.persianaWeekDay = (int)weekday;
        this.perscal = this.jdToPersian(j);
        this.perscal = this.jdToPersiana(j);
        this.persianaYearValue = this.perscal[0];
        this.persianaMonthSelectedIndex = this.perscal[1] - 1.0;
        this.persianaDayValue = this.perscal[2];
    }

    private void calcJulian() {
        double j = this.juliandayDayValue;
        double[] date = this.jdToGregorian(j);
        this.gregorianYearValue = date[0];
        this.gregorianMonthSelectedIndex = date[1] - 1.0;
        this.gregorianDayValue = date[2];
    }

    private void setJulian(double j) {
        this.juliandayDayValue = j;
        this.calcJulian();
    }
}

