/*
 * Decompiled with CFR 0.152.
 */
package com.github.eloyzone.jalalicalendar;

import com.github.eloyzone.jalalicalendar.DateFormatterTemporalField;
import com.github.eloyzone.jalalicalendar.JalaliDate;
import java.util.ArrayList;
import java.util.Arrays;

public class JalaliDateFormatter {
    private String pattern;
    private int formatLanguage;
    private JalaliDate jalaliDate;
    public static int FORMAT_IN_PERSIAN = 1;
    public static int FORMAT_IN_ENGLISH = 2;
    private ArrayList<DateFormatterTemporalField> dateFormatterTemporalFields = new ArrayList();
    private String[] validPatternCharacters = new String[]{"y", "m", "M", "d", " ", "/", "-"};

    public JalaliDateFormatter(String pattern) {
        this.pattern = pattern;
        this.formatLanguage = FORMAT_IN_ENGLISH;
    }

    public JalaliDateFormatter(String pattern, int formatLanguage) {
        this.pattern = pattern;
        this.formatLanguage = formatLanguage;
    }

    public String format(JalaliDate jalaliDate) {
        int i;
        this.jalaliDate = jalaliDate;
        this.parsePattern(this.pattern);
        String result = "";
        if (this.formatLanguage == FORMAT_IN_PERSIAN && this.pattern.contains("M")) {
            for (i = this.dateFormatterTemporalFields.size() - 1; i >= 0; --i) {
                result = result + this.applyFormat(i);
            }
        } else {
            for (i = 0; i < this.dateFormatterTemporalFields.size(); ++i) {
                result = result + this.applyFormat(i);
            }
        }
        if (this.formatLanguage == FORMAT_IN_PERSIAN) {
            char[] resultChars = result.toCharArray();
            for (int i2 = 0; i2 < resultChars.length; ++i2) {
                resultChars[i2] = this.replaceWithPersian(resultChars[i2]);
            }
            result = String.valueOf(resultChars);
        }
        return result;
    }

    private String applyFormat(int index) {
        String result = "";
        String temp = "";
        DateFormatterTemporalField dateFormatterTemporalField = this.dateFormatterTemporalFields.get(index);
        switch (dateFormatterTemporalField.getType()) {
            case 1: {
                if (dateFormatterTemporalField.getCount() == 2) {
                    temp = this.jalaliDate.getYear() + "";
                    result = result + temp.substring(1, 3);
                    break;
                }
                result = result + this.jalaliDate.getYear();
                break;
            }
            case 2: {
                int monthValue = this.jalaliDate.getMonthPersian().getValue();
                if (dateFormatterTemporalField.getCount() == 2) {
                    if (monthValue < 10) {
                        temp = "0";
                    }
                    result = result + temp + monthValue;
                    break;
                }
                if (monthValue < 10) {
                    throw new IllegalArgumentException("format of month can not match with value");
                }
                result = result + temp + monthValue;
                break;
            }
            case 4: {
                if (dateFormatterTemporalField.getCount() == 2) {
                    int dayValue = this.jalaliDate.getDay();
                    if (dayValue < 10) {
                        temp = "0";
                    }
                    result = result + temp + dayValue;
                    break;
                }
                int dayValue = this.jalaliDate.getDay();
                if (dayValue < 10) {
                    throw new IllegalArgumentException("format of day can not match with value");
                }
                result = result + temp + dayValue;
                break;
            }
            case 6: {
                for (int i = 0; i < dateFormatterTemporalField.getCount(); ++i) {
                    result = result + " ";
                }
                break;
            }
            case 7: {
                for (int i = 0; i < dateFormatterTemporalField.getCount(); ++i) {
                    result = result + "-";
                }
                break;
            }
            case 8: {
                for (int i = 0; i < dateFormatterTemporalField.getCount(); ++i) {
                    result = result + "/";
                }
                break;
            }
            case 3: {
                String monthString = this.formatLanguage == FORMAT_IN_PERSIAN ? this.jalaliDate.getMonthPersian().getStringInPersian() : this.jalaliDate.getMonthPersian().getStringInEnglish();
                result = result + monthString;
            }
        }
        return result;
    }

    private char replaceWithPersian(char resultChar) {
        if (resultChar == '0') {
            return '\u0660';
        }
        if (resultChar == '1') {
            return '\u0661';
        }
        if (resultChar == '2') {
            return '\u0662';
        }
        if (resultChar == '3') {
            return '\u0663';
        }
        if (resultChar == '4') {
            return '\u0664';
        }
        if (resultChar == '5') {
            return '\u0665';
        }
        if (resultChar == '6') {
            return '\u0666';
        }
        if (resultChar == '7') {
            return '\u0667';
        }
        if (resultChar == '8') {
            return '\u0668';
        }
        if (resultChar == '9') {
            return '\u0669';
        }
        return resultChar;
    }

    private void parsePattern(String pattern) {
        for (int pos = 0; pos < pattern.length(); ++pos) {
            char cur = pattern.charAt(pos);
            if (cur >= 'A' && cur <= 'Z' || cur >= 'a' && cur <= 'z' || cur == ' ' || cur == '/' || cur == '-') {
                int start = pos++;
                while (pos < pattern.length() && pattern.charAt(pos) == cur) {
                    ++pos;
                }
                int count = pos - start;
                if (this.isValidPatternCharacter(String.valueOf(cur))) {
                    this.parseField(cur, count);
                }
                --pos;
                continue;
            }
            throw new IllegalArgumentException("Invalid character for formatting: " + cur);
        }
    }

    private void parseField(char cur, int count) {
        switch (cur) {
            case 'y': {
                if (count == 2) {
                    throw new IllegalArgumentException("Not enough pattern letters: " + cur);
                }
                if (count == 2) {
                    this.dateFormatterTemporalFields.add(new DateFormatterTemporalField(2, 1));
                    break;
                }
                if (count == 4) {
                    this.dateFormatterTemporalFields.add(new DateFormatterTemporalField(4, 1));
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters: " + cur);
            }
            case 'm': {
                if (count == 1) {
                    this.dateFormatterTemporalFields.add(new DateFormatterTemporalField(1, 2));
                    break;
                }
                if (count == 2) {
                    this.dateFormatterTemporalFields.add(new DateFormatterTemporalField(2, 2));
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters: " + cur);
            }
            case 'M': {
                if (count == 1) {
                    this.dateFormatterTemporalFields.add(new DateFormatterTemporalField(1, 3));
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters: " + cur);
            }
            case 'd': {
                if (count == 1) {
                    this.dateFormatterTemporalFields.add(new DateFormatterTemporalField(1, 4));
                    break;
                }
                if (count == 2) {
                    this.dateFormatterTemporalFields.add(new DateFormatterTemporalField(2, 4));
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters: " + cur);
            }
            case ' ': {
                this.dateFormatterTemporalFields.add(new DateFormatterTemporalField(count, 6));
                break;
            }
            case '-': {
                this.dateFormatterTemporalFields.add(new DateFormatterTemporalField(count, 7));
                break;
            }
            case '/': {
                this.dateFormatterTemporalFields.add(new DateFormatterTemporalField(count, 8));
            }
        }
    }

    private boolean isValidPatternCharacter(String character) {
        return Arrays.stream(this.validPatternCharacters).anyMatch(x -> x.equals(character));
    }
}

