/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.coop.netty.http;

import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.op.OpType;
import com.emc.mongoose.base.item.op.Operation;
import com.emc.mongoose.base.item.op.data.DataOperation;
import com.emc.mongoose.base.item.op.path.PathOperation;
import com.emc.mongoose.base.item.op.token.TokenOperation;
import com.emc.mongoose.base.logging.LogUtil;
import com.emc.mongoose.base.logging.Loggers;
import com.emc.mongoose.storage.driver.coop.netty.ResponseHandlerBase;
import com.emc.mongoose.storage.driver.coop.netty.data.ResponseContentUtil;
import com.emc.mongoose.storage.driver.coop.netty.http.HttpStorageDriverBase;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.IOException;
import org.apache.logging.log4j.Level;

public abstract class HttpResponseHandlerBase<I extends Item, O extends Operation<I>>
extends ResponseHandlerBase<HttpObject, I, O> {
    protected HttpResponseHandlerBase(HttpStorageDriverBase<I, O> driver, boolean verifyFlag) {
        super(driver, verifyFlag);
    }

    protected boolean handleResponseStatus(O op, HttpStatusClass statusClass, HttpResponseStatus responseStatus) {
        switch (statusClass) {
            case INFORMATIONAL: {
                Loggers.ERR.warn("{}: {}", (Object)op.toString(), (Object)responseStatus.toString());
                op.status(Operation.Status.RESP_FAIL_CLIENT);
                break;
            }
            case SUCCESS: {
                op.status(Operation.Status.SUCC);
                return true;
            }
            case REDIRECTION: {
                Loggers.ERR.warn("{}: {}", (Object)op.toString(), (Object)responseStatus.toString());
                op.status(Operation.Status.RESP_FAIL_CLIENT);
                break;
            }
            case CLIENT_ERROR: {
                Loggers.ERR.warn("{}: {}", (Object)op.toString(), (Object)responseStatus.toString());
                if (HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE.equals(responseStatus)) {
                    op.status(Operation.Status.RESP_FAIL_SVC);
                    break;
                }
                if (HttpResponseStatus.REQUEST_URI_TOO_LONG.equals(responseStatus)) {
                    op.status(Operation.Status.RESP_FAIL_SVC);
                    break;
                }
                if (HttpResponseStatus.UNAUTHORIZED.equals(responseStatus)) {
                    op.status(Operation.Status.RESP_FAIL_AUTH);
                    break;
                }
                if (HttpResponseStatus.FORBIDDEN.equals(responseStatus)) {
                    op.status(Operation.Status.RESP_FAIL_AUTH);
                    break;
                }
                if (HttpResponseStatus.NOT_FOUND.equals(responseStatus)) {
                    op.status(Operation.Status.RESP_FAIL_NOT_FOUND);
                    break;
                }
                op.status(Operation.Status.RESP_FAIL_CLIENT);
                break;
            }
            case SERVER_ERROR: {
                Loggers.ERR.warn("{}: {}", (Object)op.toString(), (Object)responseStatus.toString());
                if (HttpResponseStatus.GATEWAY_TIMEOUT.equals(responseStatus)) {
                    op.status(Operation.Status.FAIL_TIMEOUT);
                    break;
                }
                if (HttpResponseStatus.INSUFFICIENT_STORAGE.equals(responseStatus)) {
                    op.status(Operation.Status.RESP_FAIL_SPACE);
                    break;
                }
                op.status(Operation.Status.RESP_FAIL_SVC);
                break;
            }
            case UNKNOWN: {
                Loggers.ERR.warn("{}: {}", (Object)op.toString(), (Object)responseStatus.toString());
                op.status(Operation.Status.FAIL_UNKNOWN);
            }
        }
        return false;
    }

    protected abstract void handleResponseHeaders(Channel var1, O var2, HttpHeaders var3);

    protected void handleResponseContentChunk(Channel channel, O op, ByteBuf contentChunk) throws IOException {
        if (OpType.READ.equals((Object)op.type())) {
            if (op instanceof DataOperation) {
                int chunkSize;
                DataOperation dataOp = (DataOperation)op;
                long countBytesDone = dataOp.countBytesDone();
                if (dataOp.respDataTimeStart() == 0L) {
                    try {
                        dataOp.startDataResponse();
                    }
                    catch (IllegalStateException e) {
                        LogUtil.exception((Level)Level.DEBUG, (Throwable)e, (String)"{}", (Object[])new Object[]{dataOp.toString()});
                    }
                }
                if ((chunkSize = contentChunk.readableBytes()) > 0) {
                    if (this.verifyFlag) {
                        if (!Operation.Status.RESP_FAIL_CORRUPT.equals((Object)op.status())) {
                            ResponseContentUtil.verifyChunk((DataOperation)dataOp, (long)countBytesDone, (ByteBuf)contentChunk, (int)chunkSize);
                        }
                    } else {
                        dataOp.countBytesDone(countBytesDone + (long)chunkSize);
                    }
                }
            } else if (op instanceof PathOperation) {
                int chunkSize;
                PathOperation pathOp = (PathOperation)op;
                long countBytesDone = pathOp.countBytesDone();
                if (pathOp.respDataTimeStart() == 0L) {
                    pathOp.startDataResponse();
                }
                if ((chunkSize = contentChunk.readableBytes()) > 0) {
                    pathOp.countBytesDone(countBytesDone + (long)chunkSize);
                }
            } else if (op instanceof TokenOperation) {
                int chunkSize;
                TokenOperation tokenOp = (TokenOperation)op;
                long countBytesDone = tokenOp.countBytesDone();
                if (tokenOp.respDataTimeStart() == 0L) {
                    tokenOp.startDataResponse();
                }
                if ((chunkSize = contentChunk.readableBytes()) > 0) {
                    tokenOp.countBytesDone(countBytesDone + (long)chunkSize);
                }
            } else {
                throw new AssertionError((Object)"Not implemented yet");
            }
        }
    }

    protected void handleResponseContentFinish(Channel channel, O op) {
        this.driver.complete(channel, op);
    }

    protected final void handle(Channel channel, O op, HttpObject msg) throws IOException {
        if (msg instanceof HttpResponse) {
            try {
                op.startResponse();
            }
            catch (IllegalStateException e) {
                LogUtil.exception((Level)Level.DEBUG, (Throwable)e, (String)"{}", (Object[])new Object[]{op.toString()});
            }
            HttpResponse httpResponse = (HttpResponse)msg;
            if (Loggers.MSG.isTraceEnabled()) {
                Loggers.MSG.trace("{} <<<< {}", (Object)op.hashCode(), (Object)httpResponse.status());
            }
            HttpResponseStatus httpResponseStatus = httpResponse.status();
            this.handleResponseStatus(op, httpResponseStatus.codeClass(), httpResponseStatus);
            this.handleResponseHeaders(channel, op, httpResponse.headers());
            if (msg instanceof FullHttpResponse) {
                ByteBuf fullRespContent = ((FullHttpResponse)msg).content();
                this.handleResponseContentChunk(channel, op, fullRespContent);
            }
        }
        if (msg instanceof HttpContent) {
            this.handleResponseContentChunk(channel, op, ((HttpContent)msg).content());
            if (msg instanceof LastHttpContent) {
                this.handleResponseContentFinish(channel, op);
            }
        }
    }
}

