/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.kafka;

import com.emc.mongoose.base.config.IllegalConfigurationException;
import com.emc.mongoose.base.data.DataInput;
import com.emc.mongoose.base.env.ExtensionBase;
import com.emc.mongoose.base.item.Item;
import com.emc.mongoose.base.item.op.Operation;
import com.emc.mongoose.base.storage.driver.StorageDriverFactory;
import com.emc.mongoose.storage.driver.kafka.KafkaStorageDriver;
import com.github.akurilov.confuse.Config;
import com.github.akurilov.confuse.SchemaProvider;
import com.github.akurilov.confuse.io.yaml.YamlSchemaProviderBase;
import java.io.InputStream;
import java.util.List;

public class KafkaStorageDriverExtension<I extends Item, O extends Operation<I>, T extends KafkaStorageDriver<I, O>>
extends ExtensionBase
implements StorageDriverFactory<I, O, T> {
    private static final SchemaProvider SCHEMA_PROVIDER = new YamlSchemaProviderBase(){

        protected final InputStream schemaInputStream() {
            return ((Object)((Object)this)).getClass().getResourceAsStream("/config-schema-storage-driver-kafka.yaml");
        }

        public final String id() {
            return "mongoose";
        }
    };
    private static final String DEFAULTS_FILE_NAME = "defaults-storage-driver-kafka.yaml";
    private static final List<String> RES_INSTALL_FILES = List.of("config/defaults-storage-driver-kafka.yaml");

    public final String id() {
        return "kafka";
    }

    protected final String defaultsFileName() {
        return DEFAULTS_FILE_NAME;
    }

    public final SchemaProvider schemaProvider() {
        return SCHEMA_PROVIDER;
    }

    protected final List<String> resourceFilesToInstall() {
        return RES_INSTALL_FILES;
    }

    public T create(String stepId, DataInput dataInput, Config storageConfig, boolean verifyFlag, int batchSize) throws IllegalConfigurationException, InterruptedException {
        return (T)((Object)new KafkaStorageDriver(stepId, dataInput, storageConfig, verifyFlag, batchSize));
    }
}

