/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.net.base;

import com.emc.mongoose.api.common.concurrent.ThreadUtil;
import com.emc.mongoose.api.common.exception.UserShootHisFootException;
import com.emc.mongoose.api.common.net.ssl.SslContext;
import com.emc.mongoose.api.model.concurrent.NamingThreadFactory;
import com.emc.mongoose.api.model.concurrent.ThreadDump;
import com.emc.mongoose.api.model.data.DataInput;
import com.emc.mongoose.api.model.io.IoType;
import com.emc.mongoose.api.model.io.task.IoTask;
import com.emc.mongoose.api.model.io.task.composite.data.CompositeDataIoTask;
import com.emc.mongoose.api.model.io.task.data.DataIoTask;
import com.emc.mongoose.api.model.item.DataItem;
import com.emc.mongoose.api.model.item.Item;
import com.emc.mongoose.storage.driver.base.StorageDriverBase;
import com.emc.mongoose.storage.driver.net.base.NetStorageDriver;
import com.emc.mongoose.storage.driver.net.base.RequestSentCallback;
import com.emc.mongoose.storage.driver.net.base.data.DataItemFileRegion;
import com.emc.mongoose.storage.driver.net.base.data.SeekableByteChannelChunkedNioStream;
import com.emc.mongoose.storage.driver.net.base.pool.BasicMultiNodeConnPool;
import com.emc.mongoose.storage.driver.net.base.pool.ConnLeaseException;
import com.emc.mongoose.storage.driver.net.base.pool.NonBlockingConnPool;
import com.emc.mongoose.ui.config.load.LoadConfig;
import com.emc.mongoose.ui.config.storage.StorageConfig;
import com.emc.mongoose.ui.config.storage.net.NetConfig;
import com.emc.mongoose.ui.config.storage.net.node.NodeConfig;
import com.emc.mongoose.ui.log.LogUtil;
import com.emc.mongoose.ui.log.Loggers;
import com.github.akurilov.commons.collection.Range;
import com.github.akurilov.commons.system.SizeInBytes;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SeekableByteChannel;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLEngine;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.Level;

public abstract class NetStorageDriverBase<I extends Item, O extends IoTask<I>>
extends StorageDriverBase<I, O>
implements NetStorageDriver<I, O>,
ChannelPoolHandler {
    private static final String CLS_NAME = NetStorageDriverBase.class.getSimpleName();
    private static final Lock IO_EXECUTOR_LOCK = new ReentrantLock();
    private static EventLoopGroup IO_EXECUTOR = null;
    private static int IO_EXECUTOR_REF_COUNT = 0;
    protected final String[] storageNodeAddrs;
    protected final Bootstrap bootstrap;
    protected final int storageNodePort;
    protected final int connAttemptsLimit;
    private final Class<SocketChannel> socketChannelCls;
    private final NonBlockingConnPool connPool;
    private final int socketTimeout;
    private final boolean sslFlag;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NetStorageDriverBase(String jobName, DataInput contentSrc, LoadConfig loadConfig, StorageConfig storageConfig, boolean verifyFlag) throws UserShootHisFootException, InterruptedException {
        super(jobName, contentSrc, loadConfig, storageConfig, verifyFlag);
        NetConfig netConfig = storageConfig.getNetConfig();
        this.sslFlag = netConfig.getSsl();
        long sto = netConfig.getTimeoutMilliSec();
        if (sto < 0L || sto > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Socket timeout shouldn't be more than 2147483647 seconds and less than 0");
        }
        this.socketTimeout = (int)sto;
        NodeConfig nodeConfig = netConfig.getNodeConfig();
        this.storageNodePort = nodeConfig.getPort();
        this.connAttemptsLimit = nodeConfig.getConnAttemptsLimit();
        String[] t = nodeConfig.getAddrs().toArray(new String[0]);
        this.storageNodeAddrs = new String[t.length];
        for (int i = 0; i < t.length; ++i) {
            String n = t[i];
            this.storageNodeAddrs[i] = n + (n.contains(":") ? "" : ":" + this.storageNodePort);
        }
        int confWorkerCount = storageConfig.getDriverConfig().getThreads();
        int workerCount = confWorkerCount < 1 ? ThreadUtil.getHardwareThreadCount() : confWorkerCount;
        int ioRatio = netConfig.getIoRatio();
        NetStorageDriver.Transport transportKey = NetStorageDriver.Transport.valueOf(netConfig.getTransport().toUpperCase());
        if (IO_EXECUTOR_LOCK.tryLock(100000000L, TimeUnit.NANOSECONDS)) {
            try {
                if (IO_EXECUTOR == null) {
                    Loggers.MSG.info("{}: I/O executor doesn't exist yet", (Object)this.toString());
                    if (IO_EXECUTOR_REF_COUNT != 0) {
                        throw new AssertionError((Object)"I/O executor reference count should be 0");
                    }
                    try {
                        String ioExecutorClsName = (String)IO_EXECUTOR_IMPLS.get((Object)transportKey);
                        Class<?> transportCls = Class.forName(ioExecutorClsName);
                        IO_EXECUTOR = (EventLoopGroup)transportCls.getConstructor(Integer.TYPE, ThreadFactory.class).newInstance(workerCount, new NamingThreadFactory("ioWorker", true));
                        try {
                            Method setIoRatioMethod = transportCls.getMethod("setIoRatio", Integer.TYPE);
                            setIoRatioMethod.invoke((Object)IO_EXECUTOR, ioRatio);
                        }
                        catch (ReflectiveOperationException e) {
                            LogUtil.exception((Level)Level.ERROR, (Throwable)e, (String)"Failed to set the I/O ratio", (Object[])new Object[0]);
                        }
                    }
                    catch (ReflectiveOperationException e) {
                        throw new AssertionError((Object)e);
                    }
                }
                Loggers.MSG.debug("{}: increased the I/O executor ref count to {}", (Object)this.toString(), (Object)(++IO_EXECUTOR_REF_COUNT));
            }
            finally {
                IO_EXECUTOR_LOCK.unlock();
            }
        }
        Loggers.ERR.error("Failed to obtain the I/O executor lock in time, thread dump:\n{}", (Object)new ThreadDump().toString());
        String socketChannelClsName = (String)SOCKET_CHANNEL_IMPLS.get((Object)transportKey);
        try {
            this.socketChannelCls = Class.forName(socketChannelClsName);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
        this.bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().group(IO_EXECUTOR)).channel(this.socketChannelCls);
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)netConfig.getTimeoutMilliSec());
        int size = (int)netConfig.getRcvBuf().get();
        if (size > 0) {
            this.bootstrap.option(ChannelOption.SO_RCVBUF, (Object)size);
        }
        if ((size = (int)netConfig.getSndBuf().get()) > 0) {
            this.bootstrap.option(ChannelOption.SO_SNDBUF, (Object)size);
        }
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)netConfig.getKeepAlive());
        this.bootstrap.option(ChannelOption.SO_LINGER, (Object)netConfig.getLinger());
        this.bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)netConfig.getReuseAddr());
        this.bootstrap.option(ChannelOption.TCP_NODELAY, (Object)netConfig.getTcpNoDelay());
        try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put((String)"stepId", (String)this.stepId).put("className", CLS_NAME);){
            this.connPool = this.createConnectionPool();
        }
    }

    protected NonBlockingConnPool createConnectionPool() {
        return new BasicMultiNodeConnPool(this.concurrencyLevel, this.concurrencyThrottle, this.storageNodeAddrs, this.bootstrap, this, this.storageNodePort, this.connAttemptsLimit);
    }

    public final void adjustIoBuffers(long avgTransferSize, IoType ioType) {
        try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put((String)"stepId", (String)this.stepId).put("className", CLS_NAME);){
            int size = avgTransferSize < 4096L ? 4096 : (0x1000000L < avgTransferSize ? 0x1000000 : (int)avgTransferSize);
            if (IoType.CREATE.equals((Object)ioType)) {
                Loggers.MSG.info("Adjust output buffer size: {}", (Object)SizeInBytes.formatFixedSize((long)size));
                this.bootstrap.option(ChannelOption.SO_RCVBUF, (Object)4096);
                this.bootstrap.option(ChannelOption.SO_SNDBUF, (Object)size);
            } else if (IoType.READ.equals((Object)ioType)) {
                Loggers.MSG.info("Adjust input buffer size: {}", (Object)SizeInBytes.formatFixedSize((long)size));
                this.bootstrap.option(ChannelOption.SO_RCVBUF, (Object)size);
                this.bootstrap.option(ChannelOption.SO_SNDBUF, (Object)4096);
            } else {
                this.bootstrap.option(ChannelOption.SO_RCVBUF, (Object)4096);
                this.bootstrap.option(ChannelOption.SO_SNDBUF, (Object)4096);
            }
        }
    }

    protected Channel getUnpooledConnection() throws ConnectException, InterruptedException {
        InetSocketAddress nodeAddr;
        String na = this.storageNodeAddrs[0];
        if (na.contains(":")) {
            String[] addrParts = na.split(":");
            nodeAddr = new InetSocketAddress(addrParts[0], Integer.parseInt(addrParts[1]));
        } else {
            nodeAddr = new InetSocketAddress(na, this.storageNodePort);
        }
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(IO_EXECUTOR)).channel(this.socketChannelCls)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected final void initChannel(SocketChannel channel) throws Exception {
                try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put((String)"stepId", (String)NetStorageDriverBase.this.stepId).put("className", CLS_NAME);){
                    NetStorageDriverBase.this.appendHandlers(channel.pipeline());
                    Loggers.MSG.debug("{}: new unpooled channel {}, pipeline: {}", (Object)NetStorageDriverBase.this.stepId, (Object)channel.hashCode(), (Object)channel.pipeline());
                }
            }
        });
        return bootstrap.connect((SocketAddress)nodeAddr).sync().channel();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean submit(O ioTask) throws IllegalStateException {
        if (!this.isStarted()) {
            throw new IllegalStateException();
        }
        try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put((String)"stepId", (String)this.stepId).put("className", CLS_NAME);){
            if (IoType.NOOP.equals((Object)ioTask.getIoType())) {
                if (this.concurrencyThrottle.tryAcquire()) {
                    ioTask.startRequest();
                    this.sendRequest(null, null, ioTask);
                    ioTask.finishRequest();
                    this.concurrencyThrottle.release();
                    ioTask.setStatus(IoTask.Status.SUCC);
                    ioTask.startResponse();
                    this.complete(null, ioTask);
                    return true;
                }
                boolean bl = false;
                return bl;
            }
            Channel conn = this.connPool.lease();
            if (conn == null) {
                boolean bl = false;
                return bl;
            }
            conn.attr(ATTR_KEY_IOTASK).set(ioTask);
            ioTask.setNodeAddr((String)conn.attr(NonBlockingConnPool.ATTR_KEY_NODE).get());
            ioTask.startRequest();
            this.sendRequest(conn, conn.newPromise().addListener((GenericFutureListener)new RequestSentCallback((IoTask)ioTask)), ioTask);
            return true;
        }
        catch (IllegalStateException e) {
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Submit the I/O task in the invalid state", (Object[])new Object[0]);
            return true;
        }
        catch (ConnLeaseException e) {
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to lease the connection for the I/O task", (Object[])new Object[0]);
            ioTask.setStatus(IoTask.Status.FAIL_IO);
            this.complete(null, ioTask);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int submit(List<O> ioTasks, int from, int to) throws IllegalStateException {
        try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put((String)"stepId", (String)this.stepId).put("className", CLS_NAME);){
            int i = from;
            while (i < to) {
                if (!this.isStarted()) return to - from;
                IoTask nextIoTask = (IoTask)ioTasks.get(i);
                if (IoType.NOOP.equals((Object)nextIoTask.getIoType())) {
                    if (!this.concurrencyThrottle.tryAcquire()) {
                        int n = i - from;
                        return n;
                    }
                    nextIoTask.startRequest();
                    this.sendRequest(null, null, nextIoTask);
                    nextIoTask.finishRequest();
                    this.concurrencyThrottle.release();
                    nextIoTask.setStatus(IoTask.Status.SUCC);
                    nextIoTask.startResponse();
                    this.complete(null, nextIoTask);
                } else {
                    Channel conn = this.connPool.lease();
                    if (conn == null) {
                        int n = i - from;
                        return n;
                    }
                    conn.attr(ATTR_KEY_IOTASK).set((Object)nextIoTask);
                    nextIoTask.setNodeAddr((String)conn.attr(NonBlockingConnPool.ATTR_KEY_NODE).get());
                    nextIoTask.startRequest();
                    this.sendRequest(conn, conn.newPromise().addListener((GenericFutureListener)new RequestSentCallback(nextIoTask)), nextIoTask);
                }
                ++i;
            }
            return to - from;
        }
        catch (IllegalStateException e) {
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Submit the I/O task in the invalid state", (Object[])new Object[0]);
            return to - from;
        }
        catch (RejectedExecutionException e) {
            if (this.isInterrupted()) return to - from;
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to submit the I/O task", (Object[])new Object[0]);
            return to - from;
        }
        catch (ConnLeaseException e) {
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Failed to lease the connection for the I/O task", (Object[])new Object[0]);
            int i = from;
            while (i < to) {
                IoTask nextIoTask = (IoTask)ioTasks.get(i);
                nextIoTask.setStatus(IoTask.Status.FAIL_IO);
                this.complete(null, nextIoTask);
                ++i;
            }
            return to - from;
        }
    }

    protected final int submit(List<O> ioTasks) throws IllegalStateException {
        return this.submit(ioTasks, 0, ioTasks.size());
    }

    protected abstract void sendRequest(Channel var1, ChannelPromise var2, O var3);

    protected final void sendRequestData(Channel channel, O ioTask) throws IOException {
        Item item;
        IoType ioType = ioTask.getIoType();
        if (IoType.CREATE.equals((Object)ioType)) {
            DataIoTask dataIoTask;
            Item item2 = ioTask.getItem();
            if (item2 instanceof DataItem && !((dataIoTask = (DataIoTask)ioTask) instanceof CompositeDataIoTask)) {
                DataItem dataItem = (DataItem)item2;
                String srcPath = dataIoTask.getSrcPath();
                if (null == srcPath || srcPath.isEmpty()) {
                    if (this.sslFlag) {
                        channel.write((Object)new SeekableByteChannelChunkedNioStream((SeekableByteChannel)dataItem));
                    } else {
                        channel.write((Object)new DataItemFileRegion(dataItem));
                    }
                }
                dataIoTask.setCountBytesDone(dataItem.size());
            }
        } else if (IoType.UPDATE.equals((Object)ioType) && (item = ioTask.getItem()) instanceof DataItem) {
            DataItem dataItem = (DataItem)item;
            DataIoTask dataIoTask = (DataIoTask)ioTask;
            List fixedRanges = dataIoTask.getFixedRanges();
            if (fixedRanges == null || fixedRanges.isEmpty()) {
                BitSet[] updRangesMaskPair = dataIoTask.getMarkedRangesMaskPair();
                int rangeCount = DataItem.getRangeCount((long)dataItem.size());
                if (this.sslFlag) {
                    DataItem updatedRange;
                    int i;
                    for (i = 0; i < rangeCount; ++i) {
                        if (!updRangesMaskPair[0].get(i)) continue;
                        dataIoTask.setCurrRangeIdx(i);
                        updatedRange = dataIoTask.getCurrRangeUpdate();
                        channel.write((Object)new SeekableByteChannelChunkedNioStream((SeekableByteChannel)updatedRange));
                    }
                    for (i = 0; i < rangeCount; ++i) {
                        if (!updRangesMaskPair[1].get(i)) continue;
                        dataIoTask.setCurrRangeIdx(i);
                        updatedRange = dataIoTask.getCurrRangeUpdate();
                        channel.write((Object)new SeekableByteChannelChunkedNioStream((SeekableByteChannel)updatedRange));
                    }
                } else {
                    DataItem updatedRange;
                    int i;
                    for (i = 0; i < rangeCount; ++i) {
                        if (!updRangesMaskPair[0].get(i)) continue;
                        dataIoTask.setCurrRangeIdx(i);
                        updatedRange = dataIoTask.getCurrRangeUpdate();
                        channel.write((Object)new DataItemFileRegion(updatedRange));
                    }
                    for (i = 0; i < rangeCount; ++i) {
                        if (!updRangesMaskPair[1].get(i)) continue;
                        dataIoTask.setCurrRangeIdx(i);
                        updatedRange = dataIoTask.getCurrRangeUpdate();
                        channel.write((Object)new DataItemFileRegion(updatedRange));
                    }
                }
                dataItem.commitUpdatedRanges(dataIoTask.getMarkedRangesMaskPair());
            } else {
                long baseItemSize = dataItem.size();
                if (this.sslFlag) {
                    for (Range fixedRange : fixedRanges) {
                        long beg = fixedRange.getBeg();
                        long end = fixedRange.getEnd();
                        long size = fixedRange.getSize();
                        if (size == -1L) {
                            if (beg == -1L) {
                                beg = baseItemSize - end;
                                size = end;
                            } else {
                                size = end == -1L ? baseItemSize - beg : end - beg + 1L;
                            }
                        } else {
                            beg = baseItemSize;
                            dataItem.size(dataItem.size() + dataIoTask.getMarkedRangesSize());
                        }
                        channel.write((Object)new SeekableByteChannelChunkedNioStream((SeekableByteChannel)dataItem.slice(beg, size)));
                    }
                } else {
                    for (Range fixedRange : fixedRanges) {
                        long beg = fixedRange.getBeg();
                        long end = fixedRange.getEnd();
                        long size = fixedRange.getSize();
                        if (size == -1L) {
                            if (beg == -1L) {
                                beg = baseItemSize - end;
                                size = end;
                            } else {
                                size = end == -1L ? baseItemSize - beg : end - beg + 1L;
                            }
                        } else {
                            beg = baseItemSize;
                            dataItem.size(dataItem.size() + dataIoTask.getMarkedRangesSize());
                        }
                        channel.write((Object)new DataItemFileRegion(dataItem.slice(beg, size)));
                    }
                }
            }
            dataIoTask.setCountBytesDone(dataIoTask.getMarkedRangesSize());
        }
    }

    @Override
    public void complete(Channel channel, O ioTask) {
        try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put((String)"stepId", (String)this.stepId).put("className", CLS_NAME);){
            ioTask.finishResponse();
        }
        catch (IllegalStateException e) {
            LogUtil.exception((Level)Level.DEBUG, (Throwable)e, (String)"{}: invalid I/O task state", (Object[])new Object[]{ioTask.toString()});
        }
        if (channel != null) {
            this.connPool.release(channel);
        }
        this.ioTaskCompleted((IoTask)ioTask);
    }

    public final void channelReleased(Channel channel) throws Exception {
    }

    public final void channelAcquired(Channel channel) throws Exception {
    }

    public final void channelCreated(Channel channel) throws Exception {
        ChannelPipeline pipeline = channel.pipeline();
        this.appendHandlers(pipeline);
        if (Loggers.MSG.isTraceEnabled()) {
            Loggers.MSG.trace("{}: new channel pipeline configured: {}", (Object)this.stepId, (Object)pipeline.toString());
        }
    }

    protected void appendHandlers(ChannelPipeline pipeline) {
        if (this.sslFlag) {
            Loggers.MSG.debug("{}: SSL/TLS is enabled for the channel", (Object)this.stepId);
            SSLEngine sslEngine = SslContext.INSTANCE.createSSLEngine();
            sslEngine.setEnabledProtocols(new String[]{"TLSv1", "TLSv1.1", "TLSv1.2", "SSLv3"});
            sslEngine.setUseClientMode(true);
            sslEngine.setEnabledCipherSuites(SslContext.INSTANCE.getServerSocketFactory().getSupportedCipherSuites());
            pipeline.addLast(new ChannelHandler[]{new SslHandler(sslEngine)});
        }
        if (this.socketTimeout > 0) {
            pipeline.addLast(new ChannelHandler[]{new IdleStateHandler((long)this.socketTimeout, (long)this.socketTimeout, (long)this.socketTimeout, TimeUnit.MILLISECONDS)});
        }
    }

    protected final void doInterrupt() throws IllegalStateException {
        block21: {
            try (CloseableThreadContext.Instance ctx = CloseableThreadContext.put((String)"stepId", (String)this.stepId).put("className", CLS_NAME);){
                super.doInterrupt();
                try {
                    if (IO_EXECUTOR_LOCK.tryLock(100000000L, TimeUnit.NANOSECONDS)) {
                        try {
                            Loggers.MSG.debug("{}: decreased the I/O executor ref count to {}", (Object)this.toString(), (Object)(--IO_EXECUTOR_REF_COUNT));
                            if (IO_EXECUTOR_REF_COUNT == 0) {
                                Loggers.MSG.info("{}: shutdown the I/O executor", (Object)this.toString());
                                if (IO_EXECUTOR.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS).await(10L)) {
                                    Loggers.MSG.debug("{}: I/O workers stopped in time", (Object)this.toString());
                                } else {
                                    Loggers.ERR.debug("{}: I/O workers stopping timeout", (Object)this.toString());
                                }
                                IO_EXECUTOR = null;
                            }
                            break block21;
                        }
                        finally {
                            IO_EXECUTOR_LOCK.unlock();
                        }
                    }
                    Loggers.ERR.error("Failed to obtain the I/O executor lock in time, thread dump:\n{}", (Object)new ThreadDump().toString());
                }
                catch (InterruptedException e) {
                    LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"Graceful I/O workers shutdown was interrupted", (Object[])new Object[0]);
                }
            }
        }
    }

    protected void doClose() throws IllegalStateException, IOException {
        super.doClose();
        try {
            this.connPool.close();
        }
        catch (IOException e) {
            LogUtil.exception((Level)Level.WARN, (Throwable)e, (String)"{}: failed to close the connection pool", (Object[])new Object[]{this.toString()});
        }
    }
}

