/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.net.base;

import com.emc.mongoose.api.model.io.task.IoTask;
import com.emc.mongoose.api.model.item.Item;
import com.emc.mongoose.storage.driver.net.base.NetStorageDriver;
import com.emc.mongoose.storage.driver.net.base.NetStorageDriverBase;
import com.emc.mongoose.ui.log.LogUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.PrematureChannelClosureException;
import io.netty.handler.timeout.IdleStateEvent;
import java.io.IOException;
import java.net.SocketTimeoutException;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.Level;

public abstract class ResponseHandlerBase<M, I extends Item, O extends IoTask<I>>
extends SimpleChannelInboundHandler<M> {
    private static final String CLS_NAME = ResponseHandlerBase.class.getSimpleName();
    protected final NetStorageDriverBase<I, O> driver;
    protected final boolean verifyFlag;

    protected ResponseHandlerBase(NetStorageDriverBase<I, O> driver, boolean verifyFlag) {
        this.driver = driver;
        this.verifyFlag = verifyFlag;
    }

    protected final void channelRead0(ChannelHandlerContext ctx, M msg) throws Exception {
        Channel channel = ctx.channel();
        IoTask ioTask = (IoTask)channel.attr(NetStorageDriver.ATTR_KEY_IOTASK).get();
        try (CloseableThreadContext.Instance logCtx = CloseableThreadContext.put((String)"className", (String)CLS_NAME);){
            this.handle(channel, ioTask, msg);
        }
    }

    protected abstract void handle(Channel var1, O var2, M var3) throws IOException;

    public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws IOException {
        Channel channel = ctx.channel();
        IoTask ioTask = (IoTask)channel.attr(NetStorageDriver.ATTR_KEY_IOTASK).get();
        if (ioTask != null) {
            if (this.driver.isInterrupted() || this.driver.isClosed()) {
                ioTask.setStatus(IoTask.Status.INTERRUPTED);
            } else if (cause instanceof PrematureChannelClosureException) {
                LogUtil.exception((Level)Level.WARN, (Throwable)cause, (String)"Premature channel closure", (Object[])new Object[0]);
                ioTask.setStatus(IoTask.Status.FAIL_IO);
            } else {
                LogUtil.exception((Level)Level.WARN, (Throwable)cause, (String)"Client handler failure", (Object[])new Object[0]);
                ioTask.setStatus(IoTask.Status.FAIL_UNKNOWN);
            }
            if (!this.driver.isInterrupted()) {
                try {
                    this.driver.complete(channel, ioTask);
                }
                catch (Exception e) {
                    LogUtil.exception((Level)Level.DEBUG, (Throwable)e, (String)"Failed to complete the I/O task", (Object[])new Object[0]);
                }
            }
        }
    }

    public final void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            throw new SocketTimeoutException();
        }
    }
}

