/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.net.base.data;

import com.emc.mongoose.api.model.item.DataItem;
import io.netty.channel.FileRegion;
import io.netty.util.AbstractReferenceCounted;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;

public class DataItemFileRegion
extends AbstractReferenceCounted
implements FileRegion {
    protected final DataItem dataItem;
    protected final long baseItemSize;
    protected long doneByteCount = 0L;

    public DataItemFileRegion(DataItem dataItem) throws IOException {
        this.dataItem = dataItem;
        this.baseItemSize = dataItem.size();
    }

    public long position() {
        return this.doneByteCount;
    }

    @Deprecated
    public long transfered() {
        return this.doneByteCount;
    }

    public long transferred() {
        return this.doneByteCount;
    }

    public long count() {
        return this.baseItemSize;
    }

    public long transferTo(WritableByteChannel target, long position) throws IOException {
        this.dataItem.position(position);
        this.doneByteCount += (long)this.dataItem.write(target, this.baseItemSize - position);
        return this.doneByteCount;
    }

    public FileRegion retain() {
        super.retain();
        return this;
    }

    public FileRegion retain(int increment) {
        super.retain(increment);
        return this;
    }

    public FileRegion touch() {
        return this.touch((Object)this);
    }

    public FileRegion touch(Object hint) {
        return this;
    }

    protected void deallocate() {
    }
}

