/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.storage.driver.net.base.pool;

import com.emc.mongoose.storage.driver.net.base.pool.ConnLeaseException;
import com.emc.mongoose.storage.driver.net.base.pool.NonBlockingConnPool;
import com.emc.mongoose.ui.log.LogUtil;
import com.emc.mongoose.ui.log.Loggers;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.pool.ChannelPoolHandler;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.logging.log4j.Level;

public class BasicMultiNodeConnPool
implements NonBlockingConnPool {
    private final Semaphore concurrencyThrottle;
    private final String[] nodes;
    private final int n;
    private final int connAttemptsLimit;
    private final Map<String, Bootstrap> bootstraps;
    private final Map<String, List<Channel>> allConns;
    private final Map<String, Queue<Channel>> availableConns;
    private final Object2IntMap<String> connCounts;
    private final Object2IntMap<String> failedConnAttemptCounts;

    public BasicMultiNodeConnPool(int concurrencyLevel, Semaphore concurrencyThrottle, String[] nodes, Bootstrap bootstrap, final ChannelPoolHandler connPoolHandler, int defaultPort, int connAttemptsLimit) {
        this.concurrencyThrottle = concurrencyThrottle;
        if (nodes.length == 0) {
            throw new IllegalArgumentException("Empty nodes array argument");
        }
        this.nodes = nodes;
        this.connAttemptsLimit = connAttemptsLimit;
        this.n = nodes.length;
        this.bootstraps = new HashMap<String, Bootstrap>(this.n);
        this.allConns = new HashMap<String, List<Channel>>(this.n);
        this.availableConns = new HashMap<String, Queue<Channel>>(this.n);
        this.connCounts = new Object2IntOpenHashMap(this.n);
        this.failedConnAttemptCounts = new Object2IntOpenHashMap(this.n);
        for (String node : nodes) {
            InetSocketAddress nodeAddr;
            if (node.contains(":")) {
                String[] addrParts = node.split(":");
                nodeAddr = new InetSocketAddress(addrParts[0], Integer.parseInt(addrParts[1]));
            } else {
                nodeAddr = new InetSocketAddress(node, defaultPort);
            }
            this.bootstraps.put(node, (Bootstrap)bootstrap.clone().remoteAddress((SocketAddress)nodeAddr).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected final void initChannel(Channel conn) throws Exception {
                    assert (conn.eventLoop().inEventLoop());
                    connPoolHandler.channelCreated(conn);
                }
            }));
            this.availableConns.put(node, new ConcurrentLinkedQueue());
            this.connCounts.put((Object)node, 0);
            this.failedConnAttemptCounts.put((Object)node, 0);
        }
        if (concurrencyLevel > 0) {
            for (int i = 0; i < concurrencyLevel; ++i) {
                Channel conn = this.connect();
                if (conn == null) {
                    Loggers.ERR.warn("Failed to pre-create the connections to the target nodes");
                    break;
                }
                String nodeAddr = (String)conn.attr(ATTR_KEY_NODE).get();
                if (conn.isActive()) {
                    Queue<Channel> connQueue = this.availableConns.get(nodeAddr);
                    if (connQueue == null) continue;
                    connQueue.add(conn);
                    continue;
                }
                this.disconnect(nodeAddr, conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel connect() {
        Channel conn = null;
        String selectedNodeAddr = null;
        Object2IntMap<String> object2IntMap = this.connCounts;
        synchronized (object2IntMap) {
            block10: {
                int minConnsCount = Integer.MAX_VALUE;
                int nextConnsCount = 0;
                for (int i = 0; i < this.n; ++i) {
                    String nextNodeAddr = this.nodes[i];
                    nextConnsCount = this.connCounts.getInt((Object)nextNodeAddr);
                    if (nextConnsCount == 0) {
                        selectedNodeAddr = nextNodeAddr;
                        break;
                    }
                    if (nextConnsCount >= minConnsCount) continue;
                    minConnsCount = nextConnsCount;
                    selectedNodeAddr = nextNodeAddr;
                }
                if (selectedNodeAddr != null) {
                    Loggers.MSG.debug("New connection to \"{}\"", selectedNodeAddr);
                    try {
                        conn = this.connect(selectedNodeAddr);
                        conn.attr(ATTR_KEY_NODE).set((Object)selectedNodeAddr);
                        this.allConns.computeIfAbsent(selectedNodeAddr, sna -> new ArrayList()).add(conn);
                        this.connCounts.put((Object)selectedNodeAddr, nextConnsCount + 1);
                        if (this.connAttemptsLimit > 0) {
                            this.failedConnAttemptCounts.put((Object)selectedNodeAddr, 0);
                        }
                    }
                    catch (Exception e) {
                        LogUtil.exception((Level)Level.DEBUG, (Throwable)e, (String)"Failed to create a new connection to {}", (Object[])new Object[]{selectedNodeAddr});
                        if (this.connAttemptsLimit <= 0) break block10;
                        int selectedNodeFailedConnAttemptsCount = this.failedConnAttemptCounts.getInt((Object)selectedNodeAddr) + 1;
                        this.failedConnAttemptCounts.put((Object)selectedNodeAddr, selectedNodeFailedConnAttemptsCount);
                        if (selectedNodeFailedConnAttemptsCount <= this.connAttemptsLimit) break block10;
                        Loggers.ERR.error("Failed to connect to the node \"{}\" {} times successively, excluding the node from the connection pool forever", (Object)selectedNodeAddr, (Object)selectedNodeFailedConnAttemptsCount);
                        this.connCounts.put((Object)selectedNodeAddr, Integer.MAX_VALUE);
                        boolean allNodesExcluded = true;
                        for (String node : this.nodes) {
                            if (this.connCounts.getInt((Object)node) >= Integer.MAX_VALUE) continue;
                            allNodesExcluded = false;
                            break;
                        }
                        if (!allNodesExcluded) break block10;
                        Loggers.ERR.fatal("No storage nodes left in the connection pool!");
                    }
                }
            }
        }
        return conn;
    }

    protected Channel connect(String addr) throws Exception {
        return this.bootstraps.get(addr).connect().sync().channel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect(String addr, Channel conn) {
        Object object = this.connCounts;
        synchronized (object) {
            this.connCounts.put((Object)addr, this.connCounts.getInt((Object)addr) - 1);
        }
        object = this.allConns;
        synchronized (object) {
            this.allConns.get(addr).remove(conn);
        }
        conn.close();
    }

    protected Channel poll() {
        int i;
        for (int j = i = ThreadLocalRandom.current().nextInt(this.n); j < i + this.n; ++j) {
            Queue<Channel> connQueue = this.availableConns.get(this.nodes[j % this.n]);
            Channel conn = connQueue.poll();
            if (conn == null) continue;
            return conn;
        }
        return null;
    }

    @Override
    public final Channel lease() throws ConnLeaseException {
        Channel conn = null;
        if (this.concurrencyThrottle.tryAcquire()) {
            conn = this.poll();
            if (null == conn) {
                conn = this.connect();
            }
            if (conn == null) {
                this.concurrencyThrottle.release();
                throw new ConnLeaseException();
            }
        }
        return conn;
    }

    @Override
    public final int lease(List<Channel> conns, int maxCount) throws ConnLeaseException {
        int availableCount = this.concurrencyThrottle.drainPermits();
        if (availableCount == 0) {
            return availableCount;
        }
        if (availableCount > maxCount) {
            this.concurrencyThrottle.release(availableCount - maxCount);
            availableCount = maxCount;
        }
        for (int i = 0; i < availableCount; ++i) {
            Channel conn = this.poll();
            if (null == conn) {
                conn = this.connect();
            }
            if (conn == null) {
                this.concurrencyThrottle.release(availableCount - i);
                throw new ConnLeaseException();
            }
            conns.add(conn);
        }
        return availableCount;
    }

    @Override
    public final void release(Channel conn) {
        String nodeAddr = (String)conn.attr(ATTR_KEY_NODE).get();
        if (conn.isActive()) {
            Queue<Channel> connQueue = this.availableConns.get(nodeAddr);
            if (connQueue != null) {
                connQueue.add(conn);
            }
        } else {
            this.disconnect(nodeAddr, conn);
        }
        this.concurrencyThrottle.release();
    }

    @Override
    public final void release(List<Channel> conns) {
        for (Channel conn : conns) {
            String nodeAddr = (String)conn.attr(ATTR_KEY_NODE).get();
            if (conn.isActive()) {
                Queue<Channel> connQueue = this.availableConns.get(nodeAddr);
                connQueue.add(conn);
            } else {
                this.disconnect(nodeAddr, conn);
            }
            this.concurrencyThrottle.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.availableConns.clear();
        this.bootstraps.clear();
        Object2IntMap<String> object2IntMap = this.connCounts;
        synchronized (object2IntMap) {
            this.connCounts.clear();
        }
        int closedConnCount = 0;
        Map<String, List<Channel>> map = this.allConns;
        synchronized (map) {
            for (String nodeAddr : this.allConns.keySet()) {
                for (Channel conn : this.allConns.get(nodeAddr)) {
                    conn.close();
                    ++closedConnCount;
                }
            }
            this.allConns.clear();
        }
        Loggers.MSG.debug("Closed all {} connections", (Object)closedConnCount);
    }
}

