/*
 * Decompiled with CFR 0.152.
 */
package com.github.endoscope.storage.aggr;

import com.github.endoscope.core.Stats;
import com.github.endoscope.storage.Filters;
import com.github.endoscope.storage.StatDetails;
import com.github.endoscope.storage.Storage;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregatedStorage
implements com.github.endoscope.storage.AggregatedStorage {
    private static final Logger log = LoggerFactory.getLogger(AggregatedStorage.class);
    private static final long MINUTE_LENGTH_MS = 60000L;
    private static final long DAY_LENGTH_MS = 86400000L;
    private static final long WEEK_LENGTH_MS = 604800000L;
    private static final long MONTH_LENGTH_MS = 2592000000L;
    protected Storage defaultStorage;
    protected Storage dailyStorage;
    protected Storage weeklyStorage;
    protected Storage monthlyStorage;
    private boolean aggregateOnly = false;

    public void setStorage(Storage defaultStorage, Storage dailyStorage, Storage weeklyStorage, Storage monthlyStorage) {
        this.defaultStorage = defaultStorage;
        this.dailyStorage = dailyStorage;
        this.weeklyStorage = weeklyStorage;
        this.monthlyStorage = monthlyStorage;
    }

    public boolean isAggregateOnly() {
        return this.aggregateOnly;
    }

    public void setAggregateOnly(boolean aggregateOnly) {
        this.aggregateOnly = aggregateOnly;
    }

    public void setup(String initParam) {
        if (this.defaultStorage == null) {
            throw new IllegalStateException("Storage not setup properly");
        }
    }

    public String save(Stats stats, String instance, String type) {
        this.validateStartDate(stats);
        String result = null;
        if (!this.isAggregateOnly()) {
            result = this.defaultStorage.save(stats, instance, type);
        }
        this.updateAggregated(this.dailyStorage, 5, stats, type);
        this.updateAggregated(this.weeklyStorage, 3, stats, type);
        this.updateAggregated(this.monthlyStorage, 2, stats, type);
        return result;
    }

    public String replace(String statsId, Stats stats, String instance, String type) {
        throw new RuntimeException("Operation not supported");
    }

    private Calendar cal(Date d) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTime(d);
        return calendar;
    }

    private void updateAggregated(Storage storage, int timeUnit, Stats stats, String type) {
        Stats aggregated;
        Date end;
        Date start;
        if (timeUnit == 3) {
            Calendar c = this.cal(stats.getStartDate());
            c.set(7, 2);
            start = DateUtils.truncate((Calendar)c, (int)5).getTime();
            end = DateUtils.addSeconds((Date)DateUtils.addDays((Date)start, (int)7), (int)-1);
        } else {
            start = DateUtils.truncate((Calendar)this.cal(stats.getStartDate()), (int)timeUnit).getTime();
            end = DateUtils.addSeconds((Date)DateUtils.ceiling((Calendar)this.cal(stats.getStartDate()), (int)timeUnit).getTime(), (int)-1);
        }
        List ids = storage.find(DateUtils.addSeconds((Date)start, (int)1), DateUtils.addSeconds((Date)end, (int)-1), null, type);
        String replaceId = null;
        if (ids.isEmpty()) {
            aggregated = new Stats();
        } else {
            if (ids.size() > 0) {
                log.warn("Found more than one aggregated stat to update! IDS: {}", (Object)ids);
            }
            replaceId = (String)ids.get(0);
            aggregated = storage.load(replaceId);
        }
        aggregated.merge(stats, true);
        aggregated.setStartDate(start);
        aggregated.setEndDate(end);
        storage.replace(replaceId, aggregated, null, type);
    }

    private void validateStartDate(Stats stats) {
        if (stats.getStartDate() == null) {
            throw new IllegalStateException("Start date cannot be null");
        }
    }

    public Stats load(String groupId) {
        return this.defaultStorage.load(groupId);
    }

    private Storage chooseStorage(Date from, Date to) {
        long periodLength = to.getTime() - from.getTime() + 60000L;
        if (periodLength < 86400000L) {
            return this.defaultStorage;
        }
        if (periodLength < 604800000L) {
            return this.dailyStorage;
        }
        if (periodLength < 2592000000L) {
            return this.weeklyStorage;
        }
        return this.monthlyStorage;
    }

    private Storage chooseDetailsStorage(Date from, Date to) {
        long periodLength = to.getTime() - from.getTime() - 60000L;
        if (periodLength > 86400000L) {
            return this.dailyStorage;
        }
        return this.defaultStorage;
    }

    private String fixInstance(Storage storage, String instance) {
        return this.defaultStorage == storage ? instance : null;
    }

    public List<String> find(Date from, Date to, String instance, String type) {
        Storage storage = this.chooseStorage(from, to);
        instance = this.fixInstance(storage, instance);
        return storage.find(from, to, instance, type);
    }

    public Filters findFilters(Date from, Date to, String type) {
        Storage storage = this.chooseStorage(from, to);
        return storage.findFilters(from, to, type);
    }

    public StatDetails loadDetails(String detailsId, List<String> groupIds) {
        return this.defaultStorage.loadDetails(detailsId, groupIds);
    }

    public StatDetails loadDetails(String detailsId, Date from, Date to, String instance, String type) {
        Storage storage = this.chooseDetailsStorage(from, to);
        instance = this.fixInstance(storage, instance);
        return storage.loadDetails(detailsId, from, to, instance, type);
    }

    public Stats loadAggregated(boolean topLevelOnly, Date from, Date to, String instance, String type) {
        Storage storage = this.chooseStorage(from, to);
        instance = this.fixInstance(storage, instance);
        return storage.loadAggregated(topLevelOnly, from, to, instance, type);
    }

    public void cleanup(int daysToKeep, String type) {
        this.defaultStorage.cleanup(daysToKeep, type);
    }
}

