/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java8.util.Objects;
import java8.util.Optional;
import java8.util.stream.Stream;
import java8.util.stream.StreamSupport;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.AbstractSchemaExtractor$$Lambda$1;
import org.everit.json.schema.loader.AbstractSchemaExtractor$$Lambda$2;
import org.everit.json.schema.loader.AbstractSchemaExtractor$$Lambda$3;
import org.everit.json.schema.loader.AbstractSchemaExtractor$$Lambda$4;
import org.everit.json.schema.loader.AbstractSchemaExtractor$$Lambda$5;
import org.everit.json.schema.loader.AbstractSchemaExtractor$$Lambda$6;
import org.everit.json.schema.loader.AbstractSchemaExtractor$$Lambda$7;
import org.everit.json.schema.loader.AbstractSchemaExtractor$$Lambda$8;
import org.everit.json.schema.loader.AbstractSchemaExtractor$$Lambda$9;
import org.everit.json.schema.loader.ArraySchemaLoader;
import org.everit.json.schema.loader.ExclusiveLimitHandler;
import org.everit.json.schema.loader.ExclusiveLimitHandlers;
import org.everit.json.schema.loader.ExtractionResult;
import org.everit.json.schema.loader.JsonObject;
import org.everit.json.schema.loader.JsonValue;
import org.everit.json.schema.loader.LoaderConfig;
import org.everit.json.schema.loader.ObjectSchemaLoader;
import org.everit.json.schema.loader.PropertySnifferSchemaExtractor;
import org.everit.json.schema.loader.SchemaExtractor;
import org.everit.json.schema.loader.SchemaLoader;

abstract class AbstractSchemaExtractor
implements SchemaExtractor {
    static final List<String> NUMBER_SCHEMA_PROPS = Arrays.asList("minimum", "maximum", "exclusiveMinimum", "exclusiveMaximum", "multipleOf");
    static final List<String> STRING_SCHEMA_PROPS = Arrays.asList("minLength", "maxLength", "pattern", "format");
    protected JsonObject schemaJson;
    private Set<String> consumedKeys;
    final SchemaLoader defaultLoader;
    private ExclusiveLimitHandler exclusiveLimitHandler;

    AbstractSchemaExtractor(SchemaLoader defaultLoader) {
        this.defaultLoader = (SchemaLoader)Objects.requireNonNull((Object)defaultLoader, (String)"defaultLoader cannot be null");
    }

    @Override
    public final ExtractionResult extract(JsonObject schemaJson) {
        this.schemaJson = (JsonObject)Objects.requireNonNull((Object)schemaJson, (String)"schemaJson cannot be null");
        this.exclusiveLimitHandler = ExclusiveLimitHandlers.ofSpecVersion(this.config().specVersion);
        this.consumedKeys = new HashSet<String>(schemaJson.keySet().size());
        return new ExtractionResult(this.consumedKeys, this.extract());
    }

    void keyConsumed(String key) {
        if (this.schemaJson.keySet().contains(key)) {
            this.consumedKeys.add(key);
        }
    }

    void keysConsumed(List<String> keys) {
        for (String key : keys) {
            this.keyConsumed(key);
        }
    }

    JsonValue require(String key) {
        this.keyConsumed(key);
        return this.schemaJson.require(key);
    }

    Optional<JsonValue> maybe(String key) {
        this.keyConsumed(key);
        return this.schemaJson.maybe(key);
    }

    boolean containsKey(String key) {
        return this.schemaJson.containsKey(key);
    }

    boolean schemaHasAnyOf(Collection<String> propNames) {
        Stream stream = StreamSupport.stream(propNames);
        JsonObject jsonObject = this.schemaJson;
        jsonObject.getClass();
        return stream.anyMatch(AbstractSchemaExtractor$$Lambda$1.lambdaFactory$(jsonObject));
    }

    LoaderConfig config() {
        return this.schemaJson.ls.config;
    }

    ObjectSchema.Builder buildObjectSchema() {
        this.keysConsumed(this.config().specVersion.objectKeywords());
        return new ObjectSchemaLoader(this.schemaJson.ls, this.config(), this.defaultLoader).load();
    }

    ArraySchema.Builder buildArraySchema() {
        this.keysConsumed(this.config().specVersion.arrayKeywords());
        return new ArraySchemaLoader(this.schemaJson.ls, this.config(), this.defaultLoader).load();
    }

    NumberSchema.Builder buildNumberSchema() {
        this.keysConsumed(PropertySnifferSchemaExtractor.NUMBER_SCHEMA_PROPS);
        NumberSchema.Builder builder = NumberSchema.builder();
        Optional optional = this.maybe("minimum").map(AbstractSchemaExtractor$$Lambda$2.lambdaFactory$());
        NumberSchema.Builder builder2 = builder;
        builder2.getClass();
        optional.ifPresent(AbstractSchemaExtractor$$Lambda$3.lambdaFactory$(builder2));
        Optional optional2 = this.maybe("maximum").map(AbstractSchemaExtractor$$Lambda$4.lambdaFactory$());
        NumberSchema.Builder builder3 = builder;
        builder3.getClass();
        optional2.ifPresent(AbstractSchemaExtractor$$Lambda$5.lambdaFactory$(builder3));
        Optional optional3 = this.maybe("multipleOf").map(AbstractSchemaExtractor$$Lambda$6.lambdaFactory$());
        NumberSchema.Builder builder4 = builder;
        builder4.getClass();
        optional3.ifPresent(AbstractSchemaExtractor$$Lambda$7.lambdaFactory$(builder4));
        this.maybe("exclusiveMinimum").ifPresent(AbstractSchemaExtractor$$Lambda$8.lambdaFactory$(this, builder));
        this.maybe("exclusiveMaximum").ifPresent(AbstractSchemaExtractor$$Lambda$9.lambdaFactory$(this, builder));
        return builder;
    }

    abstract List<Schema.Builder<?>> extract();

    static /* synthetic */ void lambda$buildNumberSchema$1(AbstractSchemaExtractor this_, NumberSchema.Builder builder, JsonValue exclMax) {
        this_.exclusiveLimitHandler.handleExclusiveMaximum(exclMax, builder);
    }

    static /* synthetic */ void lambda$buildNumberSchema$0(AbstractSchemaExtractor this_, NumberSchema.Builder builder, JsonValue exclMin) {
        this_.exclusiveLimitHandler.handleExclusiveMinimum(exclMin, builder);
    }
}

