/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java8.util.Objects;
import java8.util.Optional;
import java8.util.stream.Collectors;
import java8.util.stream.Stream;
import java8.util.stream.StreamSupport;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.EmptySchema;
import org.everit.json.schema.FalseSchema;
import org.everit.json.schema.FormatValidator;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.TrueSchema;
import org.everit.json.schema.internal.AFormatValidator;
import org.everit.json.schema.loader.AdjacentSchemaExtractionState;
import org.everit.json.schema.loader.CombinedSchemaLoader;
import org.everit.json.schema.loader.ConstSchemaExtractor;
import org.everit.json.schema.loader.EnumSchemaExtractor;
import org.everit.json.schema.loader.ExtractionResult;
import org.everit.json.schema.loader.JsonObject;
import org.everit.json.schema.loader.JsonValue;
import org.everit.json.schema.loader.LoaderConfig;
import org.everit.json.schema.loader.LoadingState;
import org.everit.json.schema.loader.NotSchemaExtractor;
import org.everit.json.schema.loader.PropertySnifferSchemaExtractor;
import org.everit.json.schema.loader.ReferenceSchemaExtractor;
import org.everit.json.schema.loader.SchemaClient;
import org.everit.json.schema.loader.SchemaExtractor;
import org.everit.json.schema.loader.SchemaLoader$$Lambda$1;
import org.everit.json.schema.loader.SchemaLoader$$Lambda$10;
import org.everit.json.schema.loader.SchemaLoader$$Lambda$11;
import org.everit.json.schema.loader.SchemaLoader$$Lambda$12;
import org.everit.json.schema.loader.SchemaLoader$$Lambda$13;
import org.everit.json.schema.loader.SchemaLoader$$Lambda$14;
import org.everit.json.schema.loader.SchemaLoader$$Lambda$15;
import org.everit.json.schema.loader.SchemaLoader$$Lambda$16;
import org.everit.json.schema.loader.SchemaLoader$$Lambda$17;
import org.everit.json.schema.loader.SchemaLoader$$Lambda$2;
import org.everit.json.schema.loader.SchemaLoader$$Lambda$3;
import org.everit.json.schema.loader.SchemaLoader$$Lambda$4;
import org.everit.json.schema.loader.SchemaLoader$$Lambda$5;
import org.everit.json.schema.loader.SchemaLoader$$Lambda$6;
import org.everit.json.schema.loader.SchemaLoader$$Lambda$7;
import org.everit.json.schema.loader.SchemaLoader$$Lambda$8;
import org.everit.json.schema.loader.SchemaLoader$$Lambda$9;
import org.everit.json.schema.loader.SchemaLoader$SchemaLoaderBuilder$$Lambda$1;
import org.everit.json.schema.loader.SchemaLoader$SchemaLoaderBuilder$$Lambda$2;
import org.everit.json.schema.loader.SpecificationVersion;
import org.everit.json.schema.loader.TypeBasedSchemaExtractor;
import org.everit.json.schema.loader.internal.DefaultSchemaClient;
import org.everit.json.schema.loader.internal.WrappingFormatValidator;
import org.everit.json.schema.regexp.JavaUtilRegexpFactory;
import org.everit.json.schema.regexp.RegexpFactory;
import org.json.JSONObject;
import org.json.JSONPointer;

public class SchemaLoader {
    private final LoaderConfig config;
    private final LoadingState ls;

    static JSONObject toOrgJSONObject(JsonObject value) {
        return new JSONObject(value.toMap());
    }

    public static SchemaLoaderBuilder builder() {
        return new SchemaLoaderBuilder();
    }

    public static Schema load(JSONObject schemaJson) {
        return SchemaLoader.load(schemaJson, new DefaultSchemaClient());
    }

    public static Schema load(JSONObject schemaJson, SchemaClient httpClient) {
        SchemaLoader loader = SchemaLoader.builder().schemaJson(schemaJson).httpClient(httpClient).build();
        return loader.load().build();
    }

    public SchemaLoader(SchemaLoaderBuilder builder) {
        SpecificationVersion specVersion;
        Object effectiveRootSchemaJson = builder.rootSchemaJson == null ? builder.schemaJson : builder.rootSchemaJson;
        Optional<String> schemaKeywordValue = SchemaLoader.extractSchemaKeywordValue(effectiveRootSchemaJson);
        if (schemaKeywordValue.isPresent()) {
            try {
                specVersion = SpecificationVersion.getByMetaSchemaUrl((String)schemaKeywordValue.get());
            }
            catch (IllegalArgumentException e) {
                if (builder.specVersionIsExplicitlySet) {
                    specVersion = builder.specVersion;
                }
                throw new SchemaException("#", "could not determine version");
            }
        } else {
            specVersion = builder.specVersion;
        }
        this.config = new LoaderConfig(builder.httpClient, builder.formatValidators, specVersion, builder.useDefaults, builder.nullableSupport, builder.regexpFactory);
        this.ls = new LoadingState(this.config, builder.pointerSchemas, effectiveRootSchemaJson, builder.schemaJson, builder.id, builder.pointerToCurrentObj);
    }

    private static Optional<String> extractSchemaKeywordValue(Object effectiveRootSchemaJson) {
        Object schemaObj;
        Object schemaValue;
        if (effectiveRootSchemaJson instanceof Map && (schemaValue = (schemaObj = (Map)effectiveRootSchemaJson).get("$schema")) != null) {
            return Optional.of((Object)((String)schemaValue));
        }
        if (effectiveRootSchemaJson instanceof JsonObject && (schemaValue = ((JsonObject)(schemaObj = (JsonObject)effectiveRootSchemaJson)).get("$schema")) != null) {
            return Optional.of((Object)((String)schemaValue));
        }
        return Optional.empty();
    }

    SchemaLoader(LoadingState ls) {
        this.ls = ls;
        this.config = ls.config;
    }

    private Schema.Builder loadSchemaBoolean(Boolean rawBoolean) {
        return rawBoolean != false ? TrueSchema.builder() : FalseSchema.builder();
    }

    private Schema.Builder loadSchemaObject(JsonObject o) {
        Schema.Builder effectiveReturnedSchema;
        Collection<Schema.Builder<?>> extractedSchemas = this.runSchemaExtractors(o);
        if (extractedSchemas.isEmpty()) {
            effectiveReturnedSchema = EmptySchema.builder();
        } else if (extractedSchemas.size() == 1) {
            effectiveReturnedSchema = extractedSchemas.iterator().next();
        } else {
            Stream stream = StreamSupport.stream(extractedSchemas).map(SchemaLoader$$Lambda$1.lambdaFactory$());
            Schema.class.getClass();
            Collection built = (Collection)stream.map(SchemaLoader$$Lambda$2.lambdaFactory$(Schema.class)).collect(Collectors.toList());
            effectiveReturnedSchema = CombinedSchema.allOf(built).isSynthetic(true);
        }
        this.loadCommonSchemaProperties(effectiveReturnedSchema);
        return effectiveReturnedSchema;
    }

    private Collection<Schema.Builder<?>> runSchemaExtractors(JsonObject o) {
        if (o.containsKey("$ref")) {
            return new ReferenceSchemaExtractor((SchemaLoader)this).extract((JsonObject)o).extractedSchemas;
        }
        List<SchemaExtractor> extractors = Arrays.asList(new EnumSchemaExtractor(this), new CombinedSchemaLoader(this), new NotSchemaExtractor(this), new ConstSchemaExtractor(this), new TypeBasedSchemaExtractor(this), new PropertySnifferSchemaExtractor(this));
        AdjacentSchemaExtractionState state = new AdjacentSchemaExtractionState(o);
        for (SchemaExtractor extractor : extractors) {
            ExtractionResult result = extractor.extract(state.projectedSchemaJson());
            state = state.reduce(result);
        }
        Collection<Schema.Builder<?>> extractedSchemas = state.extractedSchemaBuilders();
        return extractedSchemas;
    }

    private void loadCommonSchemaProperties(Schema.Builder builder) {
        Optional optional = this.ls.schemaJson().maybe(this.config.specVersion.idKeyword()).map(SchemaLoader$$Lambda$3.lambdaFactory$());
        Schema.Builder builder2 = builder;
        builder2.getClass();
        optional.ifPresent(SchemaLoader$$Lambda$4.lambdaFactory$(builder2));
        Optional optional2 = this.ls.schemaJson().maybe("title").map(SchemaLoader$$Lambda$5.lambdaFactory$());
        Schema.Builder builder3 = builder;
        builder3.getClass();
        optional2.ifPresent(SchemaLoader$$Lambda$6.lambdaFactory$(builder3));
        Optional optional3 = this.ls.schemaJson().maybe("description").map(SchemaLoader$$Lambda$7.lambdaFactory$());
        Schema.Builder builder4 = builder;
        builder4.getClass();
        optional3.ifPresent(SchemaLoader$$Lambda$8.lambdaFactory$(builder4));
        if (this.ls.specVersion() == SpecificationVersion.DRAFT_7) {
            Optional optional4 = this.ls.schemaJson().maybe("readOnly").map(SchemaLoader$$Lambda$9.lambdaFactory$());
            Schema.Builder builder5 = builder;
            builder5.getClass();
            optional4.ifPresent(SchemaLoader$$Lambda$10.lambdaFactory$(builder5));
            Optional optional5 = this.ls.schemaJson().maybe("writeOnly").map(SchemaLoader$$Lambda$11.lambdaFactory$());
            Schema.Builder builder6 = builder;
            builder6.getClass();
            optional5.ifPresent(SchemaLoader$$Lambda$12.lambdaFactory$(builder6));
        }
        if (this.config.nullableSupport) {
            builder.nullable((Boolean)this.ls.schemaJson().maybe("nullable").map(SchemaLoader$$Lambda$13.lambdaFactory$()).orElse((Object)Boolean.FALSE));
        }
        if (this.config.useDefaults) {
            Optional optional6 = this.ls.schemaJson().maybe("default").map(SchemaLoader$$Lambda$14.lambdaFactory$());
            Schema.Builder builder7 = builder;
            builder7.getClass();
            optional6.ifPresent(SchemaLoader$$Lambda$15.lambdaFactory$(builder7));
        }
        builder.schemaLocation(new JSONPointer(this.ls.pointerToCurrentObj).toURIFragment());
    }

    public Schema.Builder<?> load() {
        return (Schema.Builder)this.ls.schemaJson.canBeMappedTo(Boolean.class, SchemaLoader$$Lambda$16.lambdaFactory$(this)).orMappedTo(JsonObject.class, SchemaLoader$$Lambda$17.lambdaFactory$(this)).requireAny();
    }

    Schema.Builder<?> loadChild(JsonValue childJson) {
        return new SchemaLoader(childJson.ls).load();
    }

    SpecificationVersion specVersion() {
        return this.ls.specVersion();
    }

    @Deprecated
    Optional<FormatValidator> getFormatValidator(String formatName) {
        return Optional.ofNullable((Object)this.config.formatValidators.get(formatName));
    }

    static /* synthetic */ Schema.Builder access$lambda$0(SchemaLoader schemaLoader, Boolean bl) {
        return schemaLoader.loadSchemaBoolean(bl);
    }

    static /* synthetic */ Schema.Builder access$lambda$1(SchemaLoader schemaLoader, JsonObject jsonObject) {
        return schemaLoader.loadSchemaObject(jsonObject);
    }

    public static class SchemaLoaderBuilder {
        SchemaClient httpClient = new DefaultSchemaClient();
        Object schemaJson;
        Object rootSchemaJson;
        Map<String, ReferenceSchema.Builder> pointerSchemas = new HashMap<String, ReferenceSchema.Builder>();
        URI id;
        List<String> pointerToCurrentObj = Collections.emptyList();
        Map<String, FormatValidator> formatValidators = new HashMap<String, FormatValidator>();
        SpecificationVersion specVersion;
        private boolean specVersionIsExplicitlySet = false;
        boolean useDefaults = false;
        private boolean nullableSupport = false;
        RegexpFactory regexpFactory = new JavaUtilRegexpFactory();

        public SchemaLoaderBuilder() {
            this.setSpecVersion(SpecificationVersion.DRAFT_4);
        }

        public SchemaLoaderBuilder addFormatValidator(FormatValidator formatValidator) {
            this.formatValidators.put(((AFormatValidator)formatValidator).formatName(), formatValidator);
            return this;
        }

        @Deprecated
        public SchemaLoaderBuilder addFormatValidator(String formatName, FormatValidator formatValidator) {
            if (!Objects.equals((Object)formatName, (Object)((AFormatValidator)formatValidator).formatName())) {
                this.formatValidators.put(formatName, new WrappingFormatValidator(formatName, formatValidator));
            } else {
                this.formatValidators.put(formatName, formatValidator);
            }
            return this;
        }

        public SchemaLoaderBuilder draftV6Support() {
            this.setSpecVersion(SpecificationVersion.DRAFT_6);
            this.specVersionIsExplicitlySet = true;
            return this;
        }

        public SchemaLoaderBuilder draftV7Support() {
            this.setSpecVersion(SpecificationVersion.DRAFT_7);
            this.specVersionIsExplicitlySet = true;
            return this;
        }

        private void setSpecVersion(SpecificationVersion specVersion) {
            this.specVersion = specVersion;
        }

        private Optional<SpecificationVersion> specVersionInSchema() {
            Optional specVersion = Optional.empty();
            if (this.schemaJson instanceof Map) {
                Map schemaObj = (Map)this.schemaJson;
                String metaSchemaURL = (String)schemaObj.get("$schema");
                try {
                    specVersion = Optional.ofNullable((Object)metaSchemaURL).map(SchemaLoader$SchemaLoaderBuilder$$Lambda$1.lambdaFactory$());
                }
                catch (IllegalArgumentException e) {
                    return specVersion;
                }
            }
            return specVersion;
        }

        public SchemaLoader build() {
            this.specVersionInSchema().ifPresent(SchemaLoader$SchemaLoaderBuilder$$Lambda$2.lambdaFactory$(this));
            this.formatValidators.putAll(this.specVersion.defaultFormatValidators());
            return new SchemaLoader(this);
        }

        @Deprecated
        public JSONObject getRootSchemaJson() {
            return new JSONObject((Map)(this.rootSchemaJson == null ? this.schemaJson : this.rootSchemaJson));
        }

        public SchemaLoaderBuilder httpClient(SchemaClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public SchemaLoaderBuilder resolutionScope(String id) {
            try {
                return this.resolutionScope(new URI(id));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        public SchemaLoaderBuilder resolutionScope(URI id) {
            this.id = id;
            return this;
        }

        SchemaLoaderBuilder pointerSchemas(Map<String, ReferenceSchema.Builder> pointerSchemas) {
            this.pointerSchemas = pointerSchemas;
            return this;
        }

        SchemaLoaderBuilder rootSchemaJson(Object rootSchemaJson) {
            this.rootSchemaJson = rootSchemaJson;
            return this;
        }

        public SchemaLoaderBuilder schemaJson(JSONObject schemaJson) {
            return this.schemaJson(schemaJson.toMap());
        }

        public SchemaLoaderBuilder schemaJson(Object schema) {
            if (schema instanceof JSONObject) {
                schema = ((JSONObject)schema).toMap();
            }
            this.schemaJson = schema;
            return this;
        }

        SchemaLoaderBuilder formatValidators(Map<String, FormatValidator> formatValidators) {
            this.formatValidators = formatValidators;
            return this;
        }

        SchemaLoaderBuilder pointerToCurrentObj(List<String> pointerToCurrentObj) {
            this.pointerToCurrentObj = (List)Objects.requireNonNull(pointerToCurrentObj);
            return this;
        }

        public SchemaLoaderBuilder useDefaults(boolean useDefaults) {
            this.useDefaults = useDefaults;
            return this;
        }

        public SchemaLoaderBuilder nullableSupport(boolean nullableSupport) {
            this.nullableSupport = nullableSupport;
            return this;
        }

        public SchemaLoaderBuilder regexpFactory(RegexpFactory regexpFactory) {
            this.regexpFactory = regexpFactory;
            return this;
        }

        static /* synthetic */ void access$lambda$0(SchemaLoaderBuilder schemaLoaderBuilder, SpecificationVersion specificationVersion) {
            schemaLoaderBuilder.setSpecVersion(specificationVersion);
        }
    }
}

