/*
 * Decompiled with CFR 0.152.
 */
package com.github.erosb.jsonsKema;

import java.math.BigDecimal;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0004\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\n"}, d2={"getAsBigDecimal", "Ljava/math/BigDecimal;", "number", "", "isDecimalNotation", "", "value", "", "stringToNumber", "", "json-sKema"})
public final class ValidatorKt {
    @NotNull
    public static final BigDecimal getAsBigDecimal(@NotNull Object number) {
        BigDecimal bigDecimal;
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        if (number instanceof BigDecimal) {
            bigDecimal = (BigDecimal)number;
        } else if (number instanceof BigInteger) {
            bigDecimal = new BigDecimal((BigInteger)number);
        } else if (number instanceof Integer || number instanceof Long) {
            bigDecimal = new BigDecimal(((Number)number).longValue());
        } else {
            double d = ((Number)number).doubleValue();
            BigDecimal bigDecimal2 = BigDecimal.valueOf(d);
            Intrinsics.checkNotNull((Object)bigDecimal2);
            bigDecimal = bigDecimal2;
        }
        return bigDecimal;
    }

    private static final boolean isDecimalNotation(String value) {
        return StringsKt.indexOf$default((CharSequence)value, (char)'.', (int)0, (boolean)false, (int)6, null) > -1 || StringsKt.indexOf$default((CharSequence)value, (char)'e', (int)0, (boolean)false, (int)6, null) > -1 || StringsKt.indexOf$default((CharSequence)value, (char)'E', (int)0, (boolean)false, (int)6, null) > -1 || Intrinsics.areEqual((Object)"-0", (Object)value);
    }

    private static final Number stringToNumber(String value) {
        char initial = value.charAt(0);
        if (Intrinsics.compare((int)initial, (int)48) >= 0 && Intrinsics.compare((int)initial, (int)57) <= 0 || initial == '-') {
            BigInteger bi;
            char at1;
            if (ValidatorKt.isDecimalNotation(value)) {
                try {
                    BigDecimal bd = new BigDecimal(value);
                    if (initial == '-' && BigDecimal.ZERO.compareTo(bd) == 0) {
                        return -0.0;
                    }
                    return bd;
                }
                catch (NumberFormatException retryAsDouble) {
                    try {
                        double d = Double.parseDouble(value);
                        if (Double.isNaN(d) || Double.isInfinite(d)) {
                            throw new NumberFormatException("val [" + value + "] is not a valid number.");
                        }
                        return d;
                    }
                    catch (NumberFormatException ignore) {
                        throw new NumberFormatException("val [" + value + "] is not a valid number.");
                    }
                }
            }
            if (initial == '0' && value.length() > 1) {
                at1 = value.charAt(1);
                if (Intrinsics.compare((int)at1, (int)48) >= 0 && Intrinsics.compare((int)at1, (int)57) <= 0) {
                    throw new NumberFormatException("val [" + value + "] is not a valid number.");
                }
            } else if (initial == '-' && value.length() > 2) {
                at1 = value.charAt(1);
                char at2 = value.charAt(2);
                if (at1 == '0' && Intrinsics.compare((int)at2, (int)48) >= 0 && Intrinsics.compare((int)at2, (int)57) <= 0) {
                    throw new NumberFormatException("val [" + value + "] is not a valid number.");
                }
            }
            if ((bi = new BigInteger(value)).bitLength() <= 31) {
                return bi.intValue();
            }
            if (bi.bitLength() <= 63) {
                return bi.longValue();
            }
            return bi;
        }
        throw new NumberFormatException("val [" + value + "] is not a valid number.");
    }

    public static final /* synthetic */ Number access$stringToNumber(String value) {
        return ValidatorKt.stringToNumber(value);
    }
}

