/*
 * Decompiled with CFR 0.152.
 */
package com.bikeemotion.quartz.jobstore.hazelcast;

import com.bikeemotion.quartz.jobstore.hazelcast.TriggerState;
import java.io.Serializable;
import org.quartz.DateBuilder;
import org.quartz.JobKey;
import org.quartz.TriggerKey;
import org.quartz.spi.OperableTrigger;

public final class TriggerWrapper
implements Serializable,
Comparable<TriggerWrapper> {
    private static final long serialVersionUID = 1L;
    public final TriggerKey key;
    public final JobKey jobKey;
    public final OperableTrigger trigger;
    private final Long acquiredAt;
    private TriggerState state;

    public Long getNextFireTime() {
        return this.trigger == null || this.trigger.getNextFireTime() == null ? null : Long.valueOf(this.trigger.getNextFireTime().getTime());
    }

    private TriggerWrapper(OperableTrigger trigger, TriggerState state) {
        if (trigger == null) {
            throw new IllegalArgumentException("Trigger cannot be null!");
        }
        this.trigger = trigger;
        this.key = trigger.getKey();
        this.jobKey = trigger.getJobKey();
        this.state = state;
        this.acquiredAt = state == TriggerState.ACQUIRED ? Long.valueOf(DateBuilder.newDate().build().getTime()) : null;
    }

    public static TriggerWrapper newTriggerWrapper(OperableTrigger trigger) {
        return TriggerWrapper.newTriggerWrapper(trigger, TriggerState.NORMAL);
    }

    public static TriggerWrapper newTriggerWrapper(TriggerWrapper tw, TriggerState state) {
        return new TriggerWrapper(tw.trigger, state);
    }

    public static TriggerWrapper newTriggerWrapper(OperableTrigger trigger, TriggerState state) {
        TriggerWrapper tw = new TriggerWrapper(trigger, state);
        return tw;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TriggerWrapper) {
            TriggerWrapper tw = (TriggerWrapper)obj;
            if (tw.key.equals((Object)this.key)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public OperableTrigger getTrigger() {
        return this.trigger;
    }

    public TriggerState getState() {
        return this.state;
    }

    public Long getAcquiredAt() {
        return this.acquiredAt;
    }

    public String toString() {
        return "TriggerWrapper{trigger=" + this.trigger + ", state=" + (Object)((Object)this.state) + ", nextFireTime=" + this.getNextFireTime() + ", acquiredAt=" + this.getAcquiredAt() + '}';
    }

    @Override
    public int compareTo(TriggerWrapper o) {
        return this.getNextFireTime().compareTo(o.getNextFireTime());
    }
}

